/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl.pool;

import java.util.Properties;
import oracle.bpm.lang.Str;
import oracle.bpm.pool.Factory;
import oracle.bpm.pool.LockOwner;
import oracle.bpm.pool.PoolUtils;
import oracle.bpm.pool.TimedMultiValuatedCache;
import oracle.bpm.util.StackTrace;

public class TimedMultivaluePool<K, V>
extends TimedMultiValuatedCache<K, V> {
    static final long serialVersionUID = 4251260454011389037L;
    static final long serialCheck = 8657381392587039101L;

    private TimedMultivaluePool(Factory<V> factory, int size, int entrysize, int timeToLive, int minNoDisposable, boolean waitForConnections, int maxRetries, long waitTimeout, boolean multipleLocks) {
        super(factory, size, entrysize, timeToLive, minNoDisposable, waitForConnections, maxRetries, waitTimeout, multipleLocks);
    }

    public static <K, V> TimedMultivaluePool<K, V> create(Factory<V> factory, Properties properties) {
        return TimedMultivaluePool.create(factory, properties, PoolUtils.getDefaults());
    }

    public static <K, V> TimedMultivaluePool<K, V> create(Factory<V> factory, Properties properties, Properties defaults) {
        int size = PoolUtils.getIntParameter("fuego.cache.maxsize", properties, defaults);
        int entrysize = PoolUtils.getIntParameter("fuego.cache.maxentrysize", properties, defaults);
        int timeToLive = PoolUtils.getIntParameter("fuego.cache.timeout", properties, defaults);
        int minNoDisposable = PoolUtils.getIntParameter("fuego.cache.minnodisposable", properties, defaults);
        boolean waitForLock = PoolUtils.getBoolParameter("fuego.cache.wait", properties, defaults);
        int maxRetries = PoolUtils.getIntParameter("fuego.cache.maxretries", properties, defaults);
        long waitTimeout = PoolUtils.getLongParameter("fuego.cache.retrytimeout", properties, defaults);
        boolean multipleLocks = PoolUtils.getBoolParameter("fuego.cache.multiplelocks", properties, defaults);
        return new TimedMultivaluePool<K, V>(factory, size, entrysize, timeToLive, minNoDisposable, waitForLock, maxRetries, waitTimeout, multipleLocks);
    }

    public V get(K key, Properties authenticationProperties) {
        Str.Holder holder = new Str.Holder();
        holder.value = "";
        assert (this.fillStackTrace(holder));
        return super.getLocked(key, authenticationProperties, new LockOwnerImpl(Thread.currentThread(), holder.value));
    }

    private boolean fillStackTrace(Str.Holder holder) {
        holder.value = StackTrace.getStackTrace();
        return true;
    }

    private static class LockOwnerImpl
    implements LockOwner {
        private String stackTrace_d;
        private Thread thread_d;

        LockOwnerImpl(Thread thread, String stackTrace) {
            this.thread_d = thread;
            this.stackTrace_d = stackTrace;
        }

        @Override
        public boolean isEqualTo(LockOwner otherObject) {
            if (otherObject == null) {
                return false;
            }
            if (!(otherObject instanceof LockOwnerImpl)) {
                return false;
            }
            return this.getThread().equals(((LockOwnerImpl)otherObject).getThread());
        }

        @Override
        public String getInfo() {
            return this.thread_d.toString() + "->" + this.stackTrace_d;
        }

        @Override
        public String getParticipantInfo() {
            return null;
        }

        public String getStackTrace() {
            return this.stackTrace_d;
        }

        public Thread getThread() {
            return this.thread_d;
        }

        @Override
        public String getThreadInfo() {
            return this.thread_d.getName();
        }

        public boolean equals(Object otherObject) {
            if (otherObject == null) {
                return false;
            }
            if (!(otherObject instanceof LockOwnerImpl)) {
                return false;
            }
            return this.getThread().equals(((LockOwnerImpl)otherObject).getThread());
        }

        public int hashCode() {
            return this.getThread().hashCode();
        }
    }
}

