/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.connector.ConnectionPoolMonitor;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.connector.TransactionListener;
import oracle.bpm.connector.TransactionMonitor;
import oracle.bpm.connector.impl.StatementHolder;
import oracle.bpm.lang.Int;

public class TransactionMonitorImpl
implements TransactionMonitor,
TransactionListener {
    private int committedTransactions;
    private int rollbackedTransactions;
    private int runningTransactions;
    private static TransactionMonitorImpl instance;
    private static Map<String, ConnectionPoolMonitor> connectionPoolMonitorProvider;

    private TransactionMonitorImpl() {
    }

    public static void deregisterConnectionPoolMonitorProvider(String configuration) {
        connectionPoolMonitorProvider.remove(configuration);
    }

    public static void registerConnectionPoolMonitorProvider(String configuration, ConnectionPoolMonitor monitor) {
        if (!TransactionMonitorImpl.isConnectionPoolMonitorRegistered(configuration)) {
            connectionPoolMonitorProvider.put(configuration, monitor);
        }
    }

    public static boolean isConnectionPoolMonitorRegistered(String configuration) {
        return connectionPoolMonitorProvider.containsKey(configuration);
    }

    public static TransactionMonitor getInstance() {
        if (instance == null) {
            instance = new TransactionMonitorImpl();
            ConnectorTransaction.addTransactionFinishedListener(instance);
        }
        return instance;
    }

    public static List getSortedList(Map statements) {
        StatementComparator comparator = new StatementComparator(statements);
        ArrayList<String> sortedList = new ArrayList<String>();
        for (String statement : statements.keySet()) {
            int position = Collections.binarySearch(sortedList, statement, comparator);
            if (position < 0) {
                position = -position - 1;
            }
            sortedList.add(position, statement);
        }
        return sortedList;
    }

    @Override
    public Map getAllConnectionPoolMonitors() {
        return Collections.unmodifiableMap(connectionPoolMonitorProvider);
    }

    @Override
    public int getCommittedTransactions() {
        return this.committedTransactions;
    }

    @Override
    public ConnectionPoolMonitor getConnectionPoolMonitor(String configuration) {
        return connectionPoolMonitorProvider.get(configuration);
    }

    @Override
    public int getRollbackedTransactions() {
        return this.rollbackedTransactions;
    }

    @Override
    public int getRunningTransactions() {
        return this.runningTransactions;
    }

    @Override
    public Iterator getAllJDBCExecutedStatements() {
        Map<String, Integer> statements = StatementHolder.getInstance().getExecutedStatements();
        return TransactionMonitorImpl.getSortedList(statements).iterator();
    }

    @Override
    public void transactionCommitted() {
        ++this.committedTransactions;
        this.decrementRunningTransactions();
    }

    @Override
    public void transactionRollbacked() {
        ++this.rollbackedTransactions;
        this.decrementRunningTransactions();
    }

    @Override
    public void transactionStarted() {
        ++this.runningTransactions;
    }

    private void decrementRunningTransactions() {
        if (this.runningTransactions > 0) {
            --this.runningTransactions;
        }
    }

    static {
        connectionPoolMonitorProvider = new TreeMap<String, ConnectionPoolMonitor>();
    }

    private static class StatementComparator
    implements Comparator<String> {
        private Map statementMap;

        public StatementComparator(Map statementMap) {
            this.statementMap = statementMap;
        }

        @Override
        public int compare(String s1, String s2) {
            Integer value2;
            Integer value1 = (Integer)this.statementMap.get(s1);
            if (value1 == null) {
                value1 = Int.ZERO;
            }
            if ((value2 = (Integer)this.statementMap.get(s2)) == null) {
                value2 = Int.ZERO;
            }
            return value2.compareTo(value1);
        }
    }
}

