/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.Properties;
import oracle.bpm.configuration.exception.InvalidConfigurationException;
import oracle.bpm.configuration.impl.RemoteConfiguration;
import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.lib.msg.LibMsg;

public final class RemoteJDBCConfiguration
extends RemoteConfiguration
implements ConfigurationEditorBean {
    private String databaseType;

    public RemoteJDBCConfiguration(Properties properties) {
        super(properties);
        this.databaseType = properties.getProperty("jdbc.remote.type");
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public String getDatabaseType() {
        if (this.databaseType != null) {
            return this.databaseType;
        }
        return "";
    }

    @Override
    public Properties asProperties() {
        Properties properties = super.asProperties();
        properties.put("jdbc.remote.type", this.getDatabaseType());
        return properties;
    }

    @Override
    public void check() throws Exception {
    }

    @Override
    public void validate() throws InvalidConfigurationException {
        super.validate();
        if (this.getDatabaseType().equals("")) {
            throw InvalidConfigurationException.validationFailed(LibMsg.REMOTE_JDBC_TYPE.getString());
        }
    }
}

