/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.Properties;
import oracle.bpm.configuration.exception.InvalidConfigurationException;
import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.connector.SecureMailConnectionType;
import oracle.bpm.lib.msg.LibMsg;

public abstract class MailConfigurationBean
implements ConfigurationEditorBean {
    private String password;
    private SecureMailConnectionType secureConnectionType;
    private String serverHost;
    private String serverPort;
    private String userName;

    protected MailConfigurationBean(Properties properties) {
        this.serverHost = properties.getProperty("mail.server.host");
        this.serverPort = properties.getProperty("mail.server.port");
        this.userName = properties.getProperty("user");
        this.password = properties.getProperty("password");
        String secureConnectionTypeString = properties.getProperty("mail.secure.connection.type");
        this.secureConnectionType = secureConnectionTypeString != null ? SecureMailConnectionType.valueOf(secureConnectionTypeString) : SecureMailConnectionType.SSL;
    }

    public String getServerHost() {
        return this.serverHost != null ? this.serverHost : "";
    }

    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    public String getServerPort() {
        return this.serverPort != null ? this.serverPort : "";
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public String getUserName() {
        return this.userName != null ? this.userName : "";
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password != null ? this.password : "";
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSecureConnectionType() {
        return this.secureConnectionType != null ? this.secureConnectionType.toString() : "";
    }

    public void setSecureConnectionType(String secureConnectionType) {
        this.secureConnectionType = SecureMailConnectionType.valueOf(secureConnectionType);
    }

    @Override
    public Properties asProperties() {
        Properties properties = new Properties();
        properties.put("mail.server.host", this.getServerHost());
        properties.put("mail.server.port", this.getServerPort());
        properties.put("user", this.getUserName());
        properties.put("password", this.getPassword());
        properties.put("mail.secure.connection.type", this.getSecureConnectionType());
        return properties;
    }

    @Override
    public void check() throws Exception {
    }

    @Override
    public void validate() throws InvalidConfigurationException {
        if ("".equals(this.getServerHost().trim())) {
            throw InvalidConfigurationException.validationFailed(LibMsg.MAIL_SERVER_HOST.getString());
        }
        if ("".equals(this.getUserName().trim())) {
            throw InvalidConfigurationException.validationFailed(LibMsg.USER.getString());
        }
        if ("".equals(this.getPassword().trim())) {
            throw InvalidConfigurationException.validationFailed(LibMsg.PASSWORD.getString());
        }
        if ("".equals(this.getSecureConnectionType().trim())) {
            throw InvalidConfigurationException.validationFailed(LibMsg.MAIL_SECURE_CONNECTION_TYPE.getString());
        }
    }
}

