/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.impl.BaseJ2EEConnector;
import oracle.bpm.connector.impl.LocalJ2eeConfigType;
import oracle.bpm.connector.impl.UserTransactionProvider;
import oracle.bpm.connector.spi.ConnectorFactory;

public class LocalJ2EEConnector
extends BaseJ2EEConnector {
    LocalJ2EEConnector(ConnectorFactory factory, ConnectorService manager, String name, Properties properties) {
        super(factory, manager, "__internal__", properties);
    }

    @Override
    public ConfigType getConfigType() {
        return LocalJ2eeConfigType.get();
    }

    @Override
    public Context createContext(Properties authenticationProperties) throws NamingException {
        UserTransactionProvider provider = LocalJ2EEConnector.getThreadUserTransactionProvider();
        return provider == null ? LocalJ2EEConnector.createInitialContext() : provider.getContext();
    }

    @Override
    public Context createStandaloneContext(Properties authenticationProperties) throws NamingException {
        return LocalJ2EEConnector.createInitialContext();
    }

    @Override
    public UserTransaction createUserTransaction() throws NamingException {
        UserTransactionProvider provider = LocalJ2EEConnector.getThreadUserTransactionProvider();
        return provider == null ? this.lookupUserTransaction() : provider.getUserTransaction();
    }

    @Override
    public void releaseContext(Context context) throws NamingException {
        UserTransactionProvider provider = LocalJ2EEConnector.getThreadUserTransactionProvider();
        if (provider == null || context != provider.getContext()) {
            context.close();
        }
    }

    private static UserTransactionProvider getThreadUserTransactionProvider() {
        return UserTransactionProvider.get();
    }

    private static Context createInitialContext() throws NamingException {
        return new InitialContext();
    }

    private UserTransaction lookupUserTransaction() throws NamingException {
        return (UserTransaction)this.getContext().lookup("java:comp/UserTransaction");
    }
}

