/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.Properties;
import oracle.bpm.configuration.exception.InvalidConfigurationException;
import oracle.bpm.configuration.impl.RemoteConfiguration;
import oracle.bpm.configuration.util.ValidationUtilities;
import oracle.bpm.connector.JmsDestinationType;
import oracle.bpm.lib.msg.LibMsg;

public final class JMSConfiguration
extends RemoteConfiguration {
    private String connectionFactory = "";
    private JmsDestinationType destinationType = JmsDestinationType.QUEUE;
    private String listenerPort;
    private String password;
    private String username;

    public JMSConfiguration(Properties properties) {
        super(properties);
        String destinationType = properties.getProperty("jmsDestinationType");
        this.destinationType = destinationType != null ? JmsDestinationType.valueOf(destinationType) : JmsDestinationType.QUEUE;
        this.connectionFactory = properties.getProperty("jmsConnectionFactory");
        this.listenerPort = properties.getProperty("jmsListenerPort");
        this.username = properties.getProperty("username");
        this.password = ValidationUtilities.unscrambleText(properties.getProperty("password"));
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setListenerPort(String listenerPort) {
        this.listenerPort = listenerPort;
    }

    public String getListenerPort() {
        return this.listenerPort != null ? this.listenerPort : "";
    }

    public void setConnectionFactory(String connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getConnectionFactory() {
        return this.connectionFactory != null ? this.connectionFactory : "";
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = JmsDestinationType.valueOf(destinationType);
    }

    public String getDestinationType() {
        return this.destinationType.toString();
    }

    @Override
    public Properties asProperties() {
        Properties properties = super.asProperties();
        properties.put("jmsDestinationType", this.getDestinationType());
        properties.put("jmsConnectionFactory", this.getConnectionFactory());
        properties.put("jmsListenerPort", this.getListenerPort());
        properties.put("username", this.getUsername());
        properties.put("password", ValidationUtilities.scrambleText(this.getPassword()));
        return properties;
    }

    @Override
    public void validate() throws InvalidConfigurationException {
        super.validate();
        if (this.getConnectionFactory().trim().equals("")) {
            throw InvalidConfigurationException.validationFailed(LibMsg.JMS_CONNECTION_FACTORY.getString());
        }
    }

    @Override
    public void check() throws Exception {
    }
}

