/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.ConnectorTransactionCoordinator;
import oracle.bpm.connector.impl.BaseConnector;
import oracle.bpm.connector.impl.J2EETransactionCoordinator;
import oracle.bpm.connector.spi.ConnectorFactory;
import oracle.bpm.connector.spi.TransactionConnectorInterface;
import oracle.bpm.lang.SuspendableThreadLocal;

public abstract class BaseJ2EEConnector
extends BaseConnector
implements TransactionConnectorInterface {
    private final ThreadLocal<Context> contexts = new SuspendableThreadLocal<Context>();
    private final J2EETransactionCoordinator coordinator;
    private final ThreadLocal<UserTransaction> userTransactions = new SuspendableThreadLocal<UserTransaction>();

    public BaseJ2EEConnector(ConnectorFactory factory, ConnectorService manager, String name, Properties properties) {
        super(factory, manager, name, properties);
        this.coordinator = new J2EETransactionCoordinator(this);
    }

    @Override
    public String getCoordinatorKey() {
        return this.getCoordinator().getCoordinatorKey();
    }

    @Override
    public final Object getResource() throws Exception {
        return this.getResource(null);
    }

    @Override
    public final Object getResource(int resourceType) throws Exception {
        return this.getResource(resourceType, null);
    }

    @Override
    public final Object getResource(Properties authenticationProperties) throws Exception {
        return this.getResource(1, authenticationProperties);
    }

    @Override
    public final Object getResource(int resourceType, Properties auhenticationProperties) throws Exception {
        switch (resourceType) {
            case 1: {
                return this.getContextInternal(auhenticationProperties);
            }
            case 3: {
                return this.createStandaloneContext(auhenticationProperties);
            }
            case 0: 
            case 2: {
                throw new UnsupportedOperationException("J2EE do not support obtaining DirContext");
            }
        }
        throw new IllegalArgumentException("invalid resource type " + resourceType);
    }

    @Override
    public UserTransaction getUserTransaction() {
        return this.userTransactions.get();
    }

    @Override
    public final void transactionFinished() {
        this.contexts.set(null);
        this.userTransactions.set(null);
    }

    @Override
    public ConnectorTransactionCoordinator createCoordinator() throws Exception {
        return this.coordinator;
    }

    @Override
    public boolean handleServiceType(String type) {
        return false;
    }

    @Override
    public void restart() {
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() {
    }

    protected final Context getContext() {
        Context context = this.contexts.get();
        assert (context != null) : "should not invoke this method (getContext) without starting the transaction";
        return context;
    }

    protected J2EETransactionCoordinator getCoordinator() {
        return this.coordinator;
    }

    abstract Context createContext(Properties var1) throws NamingException;

    abstract Context createStandaloneContext(Properties var1) throws NamingException;

    abstract UserTransaction createUserTransaction() throws NamingException;

    private Context getContextInternal(Properties authenticationProperties) throws Exception {
        Context result = this.contexts.get();
        if (result == null) {
            result = this.initTransaction(authenticationProperties);
        }
        assert (result != null) : "Did not initialize the thread context";
        return result;
    }

    private Context initTransaction(Properties authenticationProperties) throws Exception {
        Context result = this.createContext(authenticationProperties);
        this.contexts.set(result);
        UserTransaction userTransaction = this.createUserTransaction();
        this.userTransactions.set(userTransaction);
        this.coordinator.begin();
        return result;
    }
}

