/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.configuration.util.ValidationUtilities;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.connector.spi.ConnectorFactory;
import oracle.bpm.connector.spi.ConnectorInterface;
import oracle.bpm.lang.SuspendableThreadLocal;

public abstract class BaseConnector
implements ConnectorInterface {
    private final ConnectorFactory factory;
    private final ConnectorService manager;
    private final String name;
    private final Properties properties;
    private final ThreadLocal<Map<Integer, Object>> resources = new SuspendableThreadLocal<Map<Integer, Object>>();

    protected BaseConnector(ConnectorFactory factory, ConnectorService manager, String name, Properties properties) {
        this.factory = factory;
        this.manager = manager;
        this.name = name;
        this.properties = properties;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public final ConfigType getType() {
        return this.getConfigType().getParent();
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public String getAdditionalProperty(String key) {
        return this.getProperty("custom." + key);
    }

    public String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.getProperties().getProperty(key, defaultValue);
    }

    public void putProperty(Properties p, String key, Object value) {
        if (value != null) {
            p.put(key, value);
        }
    }

    public void putNullableProperty(Properties p, String key, Object value) {
        if (value != null) {
            p.put(key, value);
        } else {
            p.remove(key);
        }
    }

    public void putProperty(Properties p, String key) {
        String value = this.getProperty(key);
        if (value != null) {
            p.put(key, value);
        }
    }

    @Override
    public boolean supports(long feature) {
        return this.getConfigType().supports(feature);
    }

    public String getEncryptedProperty(String key) {
        return ValidationUtilities.unscrambleText(this.getProperties().getProperty(key));
    }

    public String getPassword() {
        return this.getEncryptedProperty("password");
    }

    protected ConnectorFactory getFactory() {
        return this.factory;
    }

    protected ConnectorService getManager() {
        return this.manager;
    }

    protected Object obtainResource(int resourceType) {
        Map<Integer, Object> threadResources = this.getThreadResources();
        return threadResources == null ? null : threadResources.get(resourceType);
    }

    protected void registerResource(int resourceType, Object resource) {
        if (ConnectorTransaction.hasCurrent()) {
            Map<Integer, Object> threadResources = this.getThreadResources();
            if (threadResources == null) {
                return;
            }
            Object previousValue = threadResources.put(resourceType, resource);
            assert (previousValue == null) : "should not register twice different resources";
        }
    }

    protected void releaseResources() {
        if (this.resources.get() != null) {
            this.resources.get().clear();
            this.resources.set(null);
        }
    }

    protected Properties getPoolProperties() {
        Properties poolProperties = new Properties();
        poolProperties.put("fuego.cache.maxentrysize", this.getProperty("jdbc.pool.max", "10"));
        poolProperties.put("fuego.cache.timeout", this.getProperty("jdbc.pool.idle_timeout", "5"));
        poolProperties.put("fuego.cache.minnodisposable", this.getProperty("jdbc.pool.min", "0"));
        return poolProperties;
    }

    protected Properties getCustomProperties() {
        Properties result = new Properties();
        for (Map.Entry<Object, Object> entry1 : this.getProperties().entrySet()) {
            String key = (String)entry1.getKey();
            Object value = entry1.getValue();
            if (!key.startsWith("custom.")) continue;
            result.put(key.substring("custom.".length()), value);
        }
        return result;
    }

    private Map<Integer, Object> getThreadResources() {
        Map<Integer, Object> threadResources = this.resources.get();
        if (threadResources == null) {
            threadResources = new HashMap<Integer, Object>();
            this.resources.set(threadResources);
        }
        return threadResources;
    }
}

