/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector;

import oracle.bpm.configuration.Configuration;
import oracle.bpm.configuration.ConfigurationManager;
import oracle.bpm.configuration.ConfigurationManagerListener;
import oracle.bpm.configuration.KnownConfigTypes;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.spi.ConnectorInterface;
import oracle.bpm.lang.Environment;
import oracle.bpm.log.Log;

public class SynchConnectorService
extends ConnectorService
implements ConfigurationManagerListener<Configuration> {
    private ConfigurationManager manager_d;

    SynchConnectorService(ConfigurationManager manager, Environment environment) {
        super(null, environment);
        this.manager_d = manager;
        this.manager_d.addListener(this);
    }

    @Override
    public void configurationAdded(Configuration configuration) {
        this.getConfigurations().addEntry(configuration.clone());
        if (configuration.getBaseConfigType().equals(KnownConfigTypes.JCL)) {
            try {
                this.restartServices();
            }
            catch (ConnectorException e) {
                Log.logWarning(e);
            }
        }
    }

    @Override
    public void configurationDeleted(Configuration configuration) {
        this.getConfigurations().removeEntry(configuration.getName());
        if (configuration.getBaseConfigType().equals(KnownConfigTypes.JCL)) {
            try {
                this.restartServices();
            }
            catch (ConnectorException e) {
                Log.logWarning(e);
            }
            return;
        }
        ConnectorInterface ci = this.getConnectorsMap().get(configuration.getName());
        if (ci != null) {
            ci.stop();
            this.getConnectorsMap().remove(configuration.getName());
        }
    }

    @Override
    public void configurationUpdated(Configuration configuration) {
        this.getConfigurations().removeEntry(configuration.getName());
        this.getConfigurations().addEntry(configuration.clone());
        if (configuration.getBaseConfigType().equals(KnownConfigTypes.JCL)) {
            try {
                this.restartServices();
            }
            catch (ConnectorException e) {
                Log.logWarning(e);
            }
            return;
        }
        ConnectorInterface ci = this.getConnectorsMap().get(configuration.getName());
        if (ci != null) {
            ci.stop();
            this.getConnectorsMap().remove(configuration.getName());
        }
    }

    @Override
    public ConnectorInterface getConnector(String name) throws ConnectorException {
        ConnectorInterface ci = super.getConnector(name);
        if (ci == null) {
            Configuration configuration = this.getConfiguration(name);
            if (configuration == null) {
                return null;
            }
            if (configuration.getBaseConfigType().equals(KnownConfigTypes.JCL)) {
                throw ConnectorException.cannotUseJCLConfiguration(configuration);
            }
            ci = this.createConnector(configuration);
            try {
                ci.start();
                this.addConnector(ci);
            }
            catch (Exception e) {
                throw ConnectorException.exceptionOnInit(ci, e);
            }
        }
        return ci;
    }

    @Override
    public boolean hasConnector(String name) {
        return this.getConfigurations().contains(name);
    }

    @Override
    void checkServiceStatus() throws ConnectorException {
        if (!this.isStarted()) {
            throw ConnectorException.serviceNotStarted();
        }
    }

    private Configuration getConfiguration(String name) {
        return this.getConfigurations().getEntry(name);
    }
}

