/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.directory.DirContext;
import oracle.bpm.configuration.KnownConfigTypes;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.connector.spi.ConnectorInterface;

public final class JNDIHelper {
    private JNDIHelper() {
    }

    public static Context getContext(String name) throws ConnectorException {
        Object resource = ConnectorTransaction.current().getResource(name, KnownConfigTypes.JNDI, 1);
        return (Context)resource;
    }

    public static Context getContext(String name, String principal, String credentials) throws ConnectorException {
        Properties authProperties = JNDIHelper.buildAuthProperties(principal, credentials);
        Object resource = ConnectorTransaction.current().getResource(name, KnownConfigTypes.JNDI, 1, authProperties);
        return (Context)resource;
    }

    public static DirContext getDirContext(String name) throws ConnectorException {
        Object resource = ConnectorTransaction.current().getResource(name, KnownConfigTypes.JNDI, 0);
        return (DirContext)resource;
    }

    public static Context getDirContext(String name, String principal, String credentials) throws ConnectorException {
        Properties authProperties = JNDIHelper.buildAuthProperties(principal, credentials);
        Object resource = ConnectorTransaction.current().getResource(name, KnownConfigTypes.JNDI, 0, authProperties);
        return (Context)resource;
    }

    public static Context getReadOnlyContext(String name) throws ConnectorException {
        ConnectorInterface connector = ConnectorTransaction.getConnectorInterface(name, KnownConfigTypes.JNDI);
        try {
            return (Context)connector.getResource(1);
        }
        catch (Exception e) {
            throw ConnectorException.exceptionOnGetResource(connector, e);
        }
    }

    public static Context getReadOnlyContext(String name, String principal, String credentials) throws ConnectorException {
        ConnectorInterface connector = ConnectorTransaction.getConnectorInterface(name, KnownConfigTypes.JNDI);
        Properties authProperties = JNDIHelper.buildAuthProperties(principal, credentials);
        try {
            return (Context)connector.getResource(1, authProperties);
        }
        catch (Exception e) {
            throw ConnectorException.exceptionOnGetResource(connector, e);
        }
    }

    public static DirContext getReadOnlyDirContext(String name) throws ConnectorException {
        ConnectorInterface connector = ConnectorTransaction.getConnectorInterface(name, KnownConfigTypes.JNDI);
        try {
            return (DirContext)connector.getResource(2);
        }
        catch (Exception e) {
            throw ConnectorException.exceptionOnGetResource(connector, e);
        }
    }

    public static DirContext getReadOnlyDirContext(String name, String principal, String credentials) throws ConnectorException {
        ConnectorInterface connector = ConnectorTransaction.getConnectorInterface(name, KnownConfigTypes.JNDI);
        Properties authProperties = JNDIHelper.buildAuthProperties(principal, credentials);
        try {
            return (DirContext)connector.getResource(3, authProperties);
        }
        catch (Exception e) {
            throw ConnectorException.exceptionOnGetResource(connector, e);
        }
    }

    public static Properties buildAuthProperties(String principal, String credentials) {
        Properties authProperties = new Properties();
        if (principal != null) {
            authProperties.put("java.naming.security.principal", principal);
        }
        if (credentials != null) {
            authProperties.put("java.naming.security.credentials", credentials);
        }
        return authProperties;
    }
}

