/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oracle.bpm.collections.sets.IdentityHashSet;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.connector.CompositeConnectorService;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.ConnectorRuntimeException;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.ConnectorServiceInterface;
import oracle.bpm.connector.ConnectorTransactionCoordinator;
import oracle.bpm.connector.TransactionException;
import oracle.bpm.connector.TransactionListener;
import oracle.bpm.connector.spi.ConnectorInterface;
import oracle.bpm.lang.SuspendableThreadLocal;
import oracle.bpm.log.Log;
import oracle.bpm.util.ExceptionFormatter;

public final class ConnectorTransaction {
    private StackTraceElement[] creatorStack;
    private ConnectorServiceInterface currentService_d;
    private Thread owner;
    private Map<String, ConnectorTransactionCoordinator> registeredCoordinators = new HashMap<String, ConnectorTransactionCoordinator>();
    private Set<Synchronization> registeredSynchronizations = new IdentityHashSet<Synchronization>();
    private Map<ConnectorInterface, Set<Object>> resourcesByConnector = new HashMap<ConnectorInterface, Set<Object>>();
    private Map<String, List<Object>> resourcesByCoordinator = new HashMap<String, List<Object>>();
    private long timestamp;
    private int transactionId;
    private static ThreadLocal<ConnectorTransaction> transactions = new SuspendableThreadLocal<ConnectorTransaction>();
    private static List<ConnectorTransaction> allTransactions = new ArrayList<ConnectorTransaction>();
    private static final Object allTransactionsLock = new Object();
    public static final int STATUS_COMMITTED = 3;
    public static final int STATUS_ROLLEDBACK = 4;
    private static int finishingTransactions;
    private static final Object finishingTransactionsLock;
    private static Set<TransactionListener> transactionFinishedListeners;
    private static volatile int transactionIdCounter;

    private ConnectorTransaction(ConnectorServiceInterface service) {
        this.currentService_d = service;
        StackTraceHolder holder = new StackTraceHolder();
        assert (this.fillStackTrace(holder));
        this.creatorStack = holder.value;
        this.owner = Thread.currentThread();
        this.transactionId = ++transactionIdCounter;
    }

    public static Iterator<ConnectorTransaction> getAllTransactions() {
        return new ArrayList<ConnectorTransaction>(allTransactions).iterator();
    }

    public static void setConnectorService(ConnectorService service) {
        if (ConnectorTransaction.isStarted()) {
            throw ConnectorRuntimeException.cannotChangeConnectorService();
        }
        CompositeConnectorService.getInstance().setConnectorService(service);
    }

    public static String getConnectorServiceProperty(String key, String defaultValue) {
        ConnectorServiceInterface service = ConnectorTransaction.getConnectorService();
        return service.getProperty(key, defaultValue);
    }

    public static void setDefaultConnectorService(ConnectorService service) {
        CompositeConnectorService.getInstance().setDefaultConnectorService(service);
    }

    public static ConnectorServiceInterface getDefaultConnectorService() {
        return CompositeConnectorService.getInstance().getDefaultConnectorService();
    }

    public static boolean isStarted() {
        return transactions.get() != null;
    }

    public static void addTransactionFinishedListener(TransactionListener listener) {
        transactionFinishedListeners.add(listener);
    }

    public static ConnectorTransaction current() {
        ConnectorTransaction result = transactions.get();
        if (result == null) {
            throw ConnectorRuntimeException.transactionNotStarted();
        }
        return result;
    }

    public static boolean hasConnectorService() {
        return CompositeConnectorService.getInstance().hasConnectorService();
    }

    public static boolean hasCurrent() {
        return ConnectorTransaction.isStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectorTransaction start() {
        if (ConnectorTransaction.isStarted()) {
            throw ConnectorRuntimeException.transactionAlreadyStarted(ConnectorTransaction.getCreatorStackTraceAsString(ConnectorTransaction.current().creatorStack));
        }
        CompositeConnectorService service = CompositeConnectorService.getInstance();
        if (!service.isReady()) {
            throw ConnectorRuntimeException.noConnectorServiceForThisThread();
        }
        ConnectorTransaction newContext = new ConnectorTransaction(service);
        newContext.setTimestamp(System.currentTimeMillis());
        transactions.set(newContext);
        Object object = allTransactionsLock;
        synchronized (object) {
            allTransactions.add(newContext);
        }
        ConnectorTransaction.notifyTransactionOperation(0);
        return newContext;
    }

    public static String getConnectorServiceProperty(String key) {
        ConnectorServiceInterface service = ConnectorTransaction.getConnectorService();
        return service.getProperty(key);
    }

    public static ConnectorServiceInterface getConnectorService() {
        return CompositeConnectorService.getInstance().getConnectorService();
    }

    public static ConnectorInterface getConnectorInterface(String name, ConfigType type) throws ConnectorException {
        return CompositeConnectorService.getInstance().getConnectorInterface(name, type);
    }

    public int getId() {
        return this.transactionId;
    }

    public String getCreatorStackTrace() {
        return ConnectorTransaction.getCreatorStackTraceAsString(this.creatorStack);
    }

    public Iterator getRegisteredCoordinators() {
        return Collections.unmodifiableMap(this.registeredCoordinators).keySet().iterator();
    }

    public Iterator<Synchronization> getRegisteredSynchronizations() {
        return Collections.unmodifiableSet(this.registeredSynchronizations).iterator();
    }

    public Object getResource(String connectorName, ConfigType type) throws ConnectorException {
        ConnectorInterface connectorInterface = this.registerConnectorInterfaceCoordinator(connectorName, type);
        try {
            Object resource = connectorInterface.getResource();
            this.registerResource(connectorInterface, resource);
            return resource;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw ConnectorException.exceptionOnGetResource(connectorInterface, e);
        }
    }

    public Object getResource(String connectorName, ConfigType type, int resourceType) throws ConnectorException {
        return this.getResource(connectorName, type, resourceType, null);
    }

    public Object getResource(String connectorName, ConfigType type, int resourceType, Properties authenticationProperties) throws ConnectorException {
        ConnectorInterface connectorInterface = this.registerConnectorInterfaceCoordinator(connectorName, type);
        try {
            Object resource = connectorInterface.getResource(resourceType, authenticationProperties);
            this.registerResource(connectorInterface, resource);
            return resource;
        }
        catch (Exception e) {
            throw ConnectorException.exceptionOnGetResource(connectorInterface, resourceType, e);
        }
    }

    public Iterator getResourcesByCoordinator(String key) {
        return Collections.unmodifiableList(this.resourcesByCoordinator.get(key)).iterator();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void abort() throws Exception {
        this.rollback(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws Exception {
        if (this.owner != Thread.currentThread()) {
            throw ConnectorException.notOwnerThread();
        }
        if (this.currentService_d.isStopping()) {
            return;
        }
        Object object = finishingTransactionsLock;
        synchronized (object) {
            ++finishingTransactions;
        }
        boolean fail = false;
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        try {
            try {
                this.beforeCompletion();
            }
            catch (Throwable t) {
                fail = true;
                for (ConnectorTransactionCoordinator coordinator : this.registeredCoordinators.values()) {
                    try {
                        coordinator.rollback(this.getResourcesForCoordinator(coordinator.getCoordinatorKey()));
                    }
                    catch (Throwable t2) {
                        if (!Log.isDebugging()) continue;
                        Log.logDebug(t2);
                    }
                }
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                Log.logFatal(t);
            }
            for (ConnectorTransactionCoordinator coordinator : this.registeredCoordinators.values()) {
                try {
                    coordinator.commit(this.getResourcesForCoordinator(coordinator.getCoordinatorKey()));
                }
                catch (Throwable t2) {
                    if (Log.isDebugging()) {
                        Log.logDebug("An exception occurred while committing on one of the coordinators involved in the distributed transaction. An exceptionOnCommit will be thrown and this is one of the causes: " + ExceptionFormatter.fullTechLevel(t2));
                    }
                    throwables.add(t2);
                    fail = true;
                }
            }
        }
        finally {
            ConnectorTransaction.finish(this);
            if (!fail) {
                ConnectorTransaction.notifyTransactionOperation(1);
                this.afterCompletion(3);
            } else {
                ConnectorTransaction.notifyTransactionOperation(2);
                this.afterCompletion(4);
            }
            Object object2 = finishingTransactionsLock;
            synchronized (object2) {
                --finishingTransactions;
                finishingTransactionsLock.notifyAll();
            }
        }
        if (fail) {
            throw TransactionException.exceptionOnCommit(throwables);
        }
    }

    public void registerSynchronization(Synchronization s) {
        this.registeredSynchronizations.add(s);
    }

    public void rollback() throws Exception {
        this.rollback(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void rollbackRunningTransactions(ConnectorService service) {
        assert (service.isStopping()) : "ConnectorService must be in STOPPING status to abort all running transactions";
        Object object = finishingTransactionsLock;
        synchronized (object) {
            while (finishingTransactions > 0) {
                try {
                    finishingTransactionsLock.wait();
                }
                catch (InterruptedException e) {
                    Log.logWarning(e);
                }
            }
            Iterator<ConnectorTransaction> iterator = ConnectorTransaction.getAllTransactions();
            while (iterator.hasNext()) {
                ConnectorTransaction transaction = iterator.next();
                try {
                    if (transaction.getCurrentService() != service) continue;
                    transaction.rollback(false);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    Log.logWarning(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback(boolean checkOwnerThread) throws Exception {
        if (checkOwnerThread && this.owner != Thread.currentThread()) {
            throw ConnectorException.notOwnerThread();
        }
        if (this.currentService_d.isStopping() && checkOwnerThread) {
            return;
        }
        Object object = finishingTransactionsLock;
        synchronized (object) {
            ++finishingTransactions;
        }
        boolean fail = false;
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        try {
            for (ConnectorTransactionCoordinator coordinator : this.registeredCoordinators.values()) {
                try {
                    coordinator.rollback(this.getResourcesForCoordinator(coordinator.getCoordinatorKey()));
                }
                catch (Throwable t) {
                    throwables.add(t);
                    fail = true;
                    if (!Log.isDebugging()) continue;
                    Log.logDebug("An exception occurred while rolling back on one of the coordinators involved in the distributed transaction. An exceptionOnRollback will be thrown and this is one of the causes: " + ExceptionFormatter.fullTechLevel(t));
                }
            }
        }
        finally {
            ConnectorTransaction.finish(this);
            ConnectorTransaction.notifyTransactionOperation(2);
            this.afterCompletion(4);
            Object object2 = finishingTransactionsLock;
            synchronized (object2) {
                --finishingTransactions;
                finishingTransactionsLock.notifyAll();
            }
        }
        if (fail) {
            throw TransactionException.exceptionOnRollback(throwables);
        }
    }

    ConnectorTransactionCoordinator getCoordinator(String key) {
        return this.registeredCoordinators.get(key);
    }

    ConnectorServiceInterface getCurrentService() {
        return this.currentService_d;
    }

    List getResourcesForCoordinator(String key) {
        return this.resourcesByCoordinator.get(key);
    }

    private static String getCreatorStackTraceAsString(StackTraceElement[] stack) {
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i < stack.length; ++i) {
            StackTraceElement stackTraceElement = stack[i];
            sb.append(stackTraceElement);
            sb.append("\n");
        }
        return sb.toString();
    }

    private static void notifyTransactionOperation(int operation) {
        for (TransactionListener transactionFinishedListener : transactionFinishedListeners) {
            if (operation == 0) {
                transactionFinishedListener.transactionStarted();
                continue;
            }
            if (operation == 1) {
                transactionFinishedListener.transactionCommitted();
                continue;
            }
            if (operation != 2) continue;
            transactionFinishedListener.transactionRollbacked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void finish(ConnectorTransaction t) {
        transactions.set(null);
        Object object = allTransactionsLock;
        synchronized (object) {
            allTransactions.remove(t);
        }
    }

    private boolean fillStackTrace(StackTraceHolder holder) {
        StackTraceHolder.access$102(holder, new Throwable().getStackTrace());
        return true;
    }

    private void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    private ConnectorInterface registerConnectorInterfaceCoordinator(String connectorName, ConfigType type) throws ConnectorException {
        ConnectorInterface connectorInterface = this.getCurrentService().getConnectorInterface(connectorName, type);
        String key = connectorInterface.getCoordinatorKey();
        if (!this.registeredCoordinators.containsKey(key)) {
            try {
                ConnectorTransactionCoordinator c = connectorInterface.createCoordinator();
                if (c != null) {
                    this.registeredCoordinators.put(key, c);
                }
            }
            catch (Exception e) {
                throw ConnectorException.exceptionOnCreateCoordinator(connectorInterface, e);
            }
        }
        return connectorInterface;
    }

    private void afterCompletion(int status) {
        for (Synchronization synchronization : this.registeredSynchronizations) {
            synchronization.afterCompletion(status);
        }
    }

    private void beforeCompletion() {
        for (Synchronization synchronization : this.registeredSynchronizations) {
            synchronization.beforeCompletion();
        }
    }

    private void registerResource(ConnectorInterface connector, Object resource) {
        List<Object> coordinatorResources;
        Set<Object> connectorResources = this.resourcesByConnector.get(connector);
        if (connectorResources == null) {
            connectorResources = new IdentityHashSet<Object>();
            this.resourcesByConnector.put(connector, connectorResources);
        }
        if (connectorResources.contains(resource)) {
            return;
        }
        connectorResources.add(resource);
        if (connector instanceof Synchronization) {
            this.registerSynchronization((Synchronization)((Object)connector));
        }
        if ((coordinatorResources = this.resourcesByCoordinator.get(connector.getCoordinatorKey())) == null) {
            coordinatorResources = new ArrayList<Object>();
            this.resourcesByCoordinator.put(connector.getCoordinatorKey(), coordinatorResources);
        }
        coordinatorResources.add(resource);
    }

    static {
        finishingTransactionsLock = new Object();
        transactionFinishedListeners = new IdentityHashSet<TransactionListener>();
        transactionIdCounter = 0;
    }

    private static class StackTraceHolder {
        private StackTraceElement[] value = new StackTraceElement[0];

        private StackTraceHolder() {
        }

        static /* synthetic */ StackTraceElement[] access$102(StackTraceHolder x0, StackTraceElement[] x1) {
            x0.value = x1;
            return x1;
        }
    }

    public static interface Synchronization {
        public void afterCompletion(int var1);

        public void beforeCompletion();
    }
}

