/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector;

import fuego.directory.DirConfiguration;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.configuration.Configuration;
import oracle.bpm.configuration.ConfigurationManager;
import oracle.bpm.configuration.ConfigurationRuntimeException;
import oracle.bpm.configuration.ConfigurationSet;
import oracle.bpm.configuration.ConnectorType;
import oracle.bpm.connector.ClassLoaderService;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.ConnectorMessagesListener;
import oracle.bpm.connector.ConnectorServiceInterface;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.connector.RuntimeConnectorService;
import oracle.bpm.connector.SynchConnectorService;
import oracle.bpm.connector.spi.ConnectorFactory;
import oracle.bpm.connector.spi.ConnectorInterface;
import oracle.bpm.lang.DefaultEnvironment;
import oracle.bpm.lang.Environment;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;

public abstract class ConnectorService
implements ConnectorServiceInterface {
    private ClassLoaderService classLoaderService;
    private ConfigurationSet<Configuration> configurations;
    private Map<String, ConnectorInterface> connectors;
    private List<String> connectorsFailedOnStartup;
    private Environment environment;
    private List<ConnectorMessagesListener> listeners;
    private int status = 2;
    static final int ST_STARTED = 1;
    static final int ST_STOPPED = 2;
    static final int ST_STOPPING = 3;
    static final int ST_STARTING = 4;

    protected ConnectorService(ConfigurationSet<Configuration> configurations, Environment environment) {
        this.setConfigurations(configurations);
        if (this.getConfigurations() == null) {
            ConfigurationSet<Configuration> configs = ConfigurationSet.create();
            this.setConfigurations(configs);
        }
        this.connectors = new HashMap<String, ConnectorInterface>();
        this.environment = environment != null ? environment : new DefaultEnvironment();
        this.listeners = new ArrayList<ConnectorMessagesListener>();
        this.connectorsFailedOnStartup = new ArrayList<String>();
        this.classLoaderService = new ClassLoaderService(this);
    }

    public static ConnectorService create(InputStream is, Environment environment) throws ConnectorException {
        return ConnectorService.create(is, environment, false);
    }

    public static ConnectorService create(InputStream is, Environment environment, boolean ignoreUnregistered) throws ConnectorException {
        return ConnectorService.create(ConfigurationSet.create(is, ignoreUnregistered), environment);
    }

    public static ConnectorService create(ConfigurationSet configurationSet, Environment environment) throws ConnectorException {
        RuntimeConnectorService result = new RuntimeConnectorService(configurationSet, environment);
        ((ConnectorService)result).init();
        return result;
    }

    public static ConnectorService create(ConfigurationSet configurationSet) throws ConnectorException {
        return ConnectorService.create(configurationSet, null);
    }

    public static ConnectorService create(ConfigurationManager manager) throws ConnectorException {
        return ConnectorService.create(manager, manager.getEnvironment());
    }

    public static ConnectorService create(ConfigurationManager manager, Environment environment) throws ConnectorException {
        SynchConnectorService result = new SynchConnectorService(manager, environment);
        result.init();
        result.start();
        return result;
    }

    public static ConnectorService create(ConfigurationManager manager, Environment environment, ConnectorMessagesListener listener) throws ConnectorException {
        SynchConnectorService result = new SynchConnectorService(manager, environment);
        result.addMessagesListener(listener);
        result.init();
        result.start();
        return result;
    }

    public static ConnectorService createFromDirectory(DirectorySession session, Environment environment) throws ConnectorException {
        return ConnectorService.createFromDirectory(session, environment, false);
    }

    public static ConnectorService createFromDirectory(DirectorySession session, Environment environment, boolean lazy) throws ConnectorException {
        return ConnectorService.createFromDirectory(session, environment, lazy, false);
    }

    public static ConnectorService createFromDirectory(DirectorySession session, Environment environment, boolean lazy, boolean ignoreUnregistered) throws ConnectorException {
        ConnectorService result;
        if (!lazy) {
            ConfigurationSet<Configuration> configurations;
            try {
                DirConfiguration directoryConfigurations = DirConfiguration.fetch(session);
                configurations = directoryConfigurations == null || directoryConfigurations.getProperties().length() == 0 ? ConfigurationSet.create() : ConfigurationSet.create(directoryConfigurations.getProperties(), ignoreUnregistered);
            }
            catch (ConfigurationRuntimeException e) {
                throw ConfigurationRuntimeException.parseException(session, e);
            }
            catch (DirectoryException e) {
                throw ConnectorException.exceptionOnLoad(session, e);
            }
            result = new RuntimeConnectorService(configurations, environment);
        } else {
            ConfigurationManager<Configuration> manager = ConfigurationManager.createFromDirectory(session);
            result = new SynchConnectorService(manager, environment);
        }
        result.init();
        return result;
    }

    @Override
    public void addConfiguration(String name, String strType, String strSubType, Properties properties) throws ConnectorException {
        assert (strType != null) : "The type can not be null";
        assert (strSubType != null) : "The SubType can not be null";
        ConfigType type = ConfigType.find(strType);
        ConfigType subType = type.getSubType(strSubType);
        Configuration configuration = new Configuration(name, type);
        if (subType != null) {
            configuration.setConfigType(subType);
        }
        configuration.getProperties().putAll((Map<?, ?>)properties);
        this.getConfigurations().addEntry(configuration.clone());
        if (configuration.getBaseConfigType() instanceof ConnectorType) {
            ConnectorInterface connector = this.createConnector(configuration);
            this.addConnector(connector);
            ConnectorService.startConnector(connector);
        }
    }

    @Override
    public void addConfiguration(String name, String strType, Properties properties) throws ConnectorException {
        assert (strType != null) : "The type can not be null";
        ConfigType type = ConfigType.find(strType);
        Configuration configuration = new Configuration(name, type);
        configuration.getProperties().putAll((Map<?, ?>)properties);
        this.getConfigurations().addEntry(configuration.clone());
        if (configuration.getBaseConfigType() instanceof ConnectorType) {
            ConnectorInterface connector = this.createConnector(configuration);
            this.addConnector(connector);
            ConnectorService.startConnector(connector);
        }
    }

    @Override
    public ClassLoaderService getClassLoaderService() {
        return this.classLoaderService;
    }

    public void addMessagesListener(ConnectorMessagesListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public Enumeration<ConnectorInterface> getConnectors() {
        return Collections.enumeration(this.connectors.values());
    }

    public Map<String, ConnectorInterface> getConnectorsMap() {
        return this.connectors;
    }

    public List<String> getConnectorsFailedOnStartup() {
        return this.connectorsFailedOnStartup;
    }

    @Override
    public String getProperty(String key) {
        return this.environment.getProperty(key, null);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.environment.getProperty(key, defaultValue);
    }

    @Override
    public boolean isStarting() {
        return this.getStatus() == 4;
    }

    @Override
    public boolean isStarted() {
        return this.getStatus() == 1;
    }

    @Override
    public boolean isStopping() {
        return this.getStatus() == 3;
    }

    @Override
    public boolean isStopped() {
        return this.getStatus() == 2;
    }

    public void removeConfiguration(String name) throws ConnectorException {
        Configuration configuration = this.getConfigurations().removeEntry(name);
        if (configuration != null && configuration.getBaseConfigType() instanceof ConnectorType) {
            ConnectorInterface connector = this.getConnectorInterface(name, configuration.getBaseConfigType());
            this.removeConnector(connector);
            ConnectorService.stopConnector(connector);
        }
    }

    public boolean removeMessagesListener(ConnectorMessagesListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void start() throws ConnectorException {
        this.start(false);
    }

    @Override
    public void start(boolean startonerror) throws ConnectorException {
        this.startService(startonerror, true);
    }

    @Override
    public void stop() {
        this.stopService(true);
    }

    public ConfigurationSet<Configuration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(ConfigurationSet<Configuration> configurations) {
        this.configurations = configurations;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public ConnectorInterface getConnector(String name) throws ConnectorException {
        return this.connectors.get(name);
    }

    @Override
    public ConnectorInterface getConnectorInterface(String connectorName, ConfigType type) throws ConnectorException {
        this.checkServiceStatus();
        if (this.getConnectorsFailedOnStartup().contains(connectorName)) {
            throw ConnectorException.connectorNotInitialized(connectorName, type);
        }
        ConnectorInterface connectorInterface = this.getConnector(connectorName);
        if (connectorInterface == null) {
            throw ConnectorException.connectorNotFound(connectorName, type);
        }
        if (!connectorInterface.getConfigType().getBaseType().equals(type)) {
            throw ConnectorException.connectorTypeMismatch(connectorName, type);
        }
        return connectorInterface;
    }

    @Override
    public boolean hasConnector(String name) {
        return this.connectors.containsKey(name);
    }

    @Override
    public Object getResource(String connectorName, ConfigType type, int resourceType) throws ConnectorException {
        return this.getResource(connectorName, type, resourceType, null);
    }

    @Override
    public Object getResource(String connectorName, ConfigType type, int resourceType, Properties authenticationProperties) throws ConnectorException {
        ConnectorInterface connectorInterface = this.getConnectorInterface(connectorName, type);
        try {
            return connectorInterface.getResource(resourceType, authenticationProperties);
        }
        catch (ConnectorException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConnectorException.exceptionOnGetResource(connectorInterface, e);
        }
    }

    protected void addConnector(ConnectorInterface connectorInterface) {
        this.connectors.put(connectorInterface.getName(), connectorInterface);
    }

    protected ConnectorInterface createConnector(Configuration configuration) throws ConnectorException {
        ConnectorFactory factory = ConnectorFactory.getFactory(configuration);
        ConnectorInterface connectorInterface = factory.createConnector(this, configuration.getName(), configuration.getProperties());
        if (Log.isDebugging()) {
            Log.logDebug(LibMsg.CREATE_CONNECTOR(configuration.getName(), configuration.getBaseConfigType().getName()));
        }
        return connectorInterface;
    }

    protected void finalize() throws Throwable {
        if (this.isStarted()) {
            this.stop();
        }
    }

    protected void removeConnector(ConnectorInterface connectorInterface) {
        this.connectors.remove(connectorInterface.getName());
    }

    abstract void checkServiceStatus() throws ConnectorException;

    static void startConnector(ConnectorInterface connectorInterface) throws ConnectorException {
        try {
            connectorInterface.start();
        }
        catch (Exception e) {
            throw ConnectorException.exceptionOnInit(connectorInterface, e);
        }
    }

    static void stopConnector(ConnectorInterface connectorInterface) {
        connectorInterface.stop();
    }

    Environment getEnvironment() {
        return this.environment;
    }

    void restartServices() throws ConnectorException {
        this.stopService(true);
        this.classLoaderService.restart();
        this.init();
        this.startService(false, false);
    }

    Object getNonTXResource(String connectorName, ConfigType type, int resourceType) throws ConnectorException {
        ConnectorInterface connectorInterface = ConnectorTransaction.getConnectorInterface(connectorName, type);
        try {
            return connectorInterface.getResource(resourceType);
        }
        catch (Exception e) {
            throw ConnectorException.exceptionOnGetResource(connectorInterface, resourceType, e);
        }
    }

    void init() throws ConnectorException {
        this.checkFactories();
    }

    private void startService(boolean startonerror, boolean startExternalService) throws ConnectorException {
        if (this.getStatus() != 2) {
            return;
        }
        this.setStatus(4);
        this.connectorsFailedOnStartup.clear();
        if (startExternalService) {
            this.classLoaderService.start(startonerror);
        }
        Enumeration<ConnectorInterface> enumeration = this.getConnectors();
        while (enumeration.hasMoreElements()) {
            ConnectorInterface connectorInterface = enumeration.nextElement();
            try {
                ConnectorService.startConnector(connectorInterface);
            }
            catch (ConnectorException e) {
                if (!startonerror) {
                    throw e;
                }
                Log.logInfo(e);
                this.connectorsFailedOnStartup.add(connectorInterface.getName());
            }
        }
        this.setStatus(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopService(boolean stopExternalServices) {
        if (this.getStatus() != 1) {
            return;
        }
        this.setStatus(3);
        try {
            if (stopExternalServices) {
                this.classLoaderService.stop();
            }
            this.rollbackRunningTransactions();
            Enumeration<ConnectorInterface> enumeration = this.getConnectors();
            while (enumeration.hasMoreElements()) {
                ConnectorInterface connectorInterface = enumeration.nextElement();
                connectorInterface.stop();
            }
        }
        finally {
            this.setStatus(2);
        }
    }

    private void checkFactories() throws ConnectorException {
        for (Configuration configuration : this.getConfigurations()) {
            if (!(configuration.getBaseConfigType() instanceof ConnectorType)) continue;
            ConnectorFactory.getFactory(configuration);
        }
    }

    private void rollbackRunningTransactions() {
        ConnectorTransaction.rollbackRunningTransactions(this);
    }
}

