/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector;

import fuego.directory.DirectoryConfiguration;
import fuego.directory.DirectoryConfigurationManager;
import fuego.directory.provider.DirectoryConfigType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import oracle.bpm.collections.Procedure;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.configuration.ConfigurationRuntimeException;
import oracle.bpm.connector.ClassLoaderService;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.ConnectorRuntimeException;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.ConnectorServiceInterface;
import oracle.bpm.connector.spi.ConnectorInterface;

public class CompositeConnectorService
implements ConnectorServiceInterface {
    private ConnectorService defaultConnectorService;
    private final Map<String, ConnectorService> directoryConnectorServicesMap = new HashMap<String, ConnectorService>();
    private InheritableThreadLocal<ConnectorService> threadConnectorService = new InheritableThreadLocal();
    private static CompositeConnectorService instance = new CompositeConnectorService();

    public static CompositeConnectorService getInstance() {
        return instance;
    }

    public static boolean restartDirectoryConnectorService(String directoryId, DirectoryConfiguration directoryConfiguration) {
        try {
            ConnectorService connectorService = CompositeConnectorService.getInstance().getDirectoryConnectorServiceById(directoryId);
            if (connectorService != null) {
                connectorService.stop();
            }
            connectorService = ConnectorService.create(directoryConfiguration.getConnectorsConfigurations());
            connectorService.start(true);
            CompositeConnectorService.getInstance().setDirectoryConnectorService(directoryId, connectorService);
            return true;
        }
        catch (ConnectorException e) {
            throw ConfigurationRuntimeException.cannotCreateService(e);
        }
    }

    public void setDefaultConnectorService(ConnectorService defaultConnectorService) {
        if (this.defaultConnectorService != null && !this.defaultConnectorService.isStopped()) {
            throw new IllegalStateException("Cannot set the default Connector Service while connector service is started");
        }
        this.defaultConnectorService = defaultConnectorService;
    }

    public void setConnectorService(ConnectorService connectorService) {
        this.threadConnectorService.set(connectorService);
    }

    public ConnectorServiceInterface getDefaultConnectorService() {
        return this.defaultConnectorService;
    }

    public ConnectorServiceInterface getThreadConnectorService() {
        return (ConnectorServiceInterface)this.threadConnectorService.get();
    }

    @Override
    public ClassLoaderService getClassLoaderService() {
        return this.getBaseConnectorService().getClassLoaderService();
    }

    public ConnectorServiceInterface getConnectorService() {
        ConnectorService baseConnectorService = this.getBaseConnectorService();
        if (baseConnectorService == null) {
            throw ConnectorRuntimeException.noConnectorServiceForThisThread();
        }
        return baseConnectorService;
    }

    public boolean hasConnectorService() {
        ConnectorServiceInterface service = (ConnectorServiceInterface)this.threadConnectorService.get();
        if (service == null) {
            service = this.defaultConnectorService;
        }
        return service != null;
    }

    @Override
    public boolean isStarting() {
        boolean result = false;
        ConnectorService service = this.getBaseConnectorService();
        if (service != null) {
            result = service.isStarting();
        }
        result = result || this.forAllDirectoryServices(new Procedure<ConnectorService>(){

            @Override
            public boolean execute(ConnectorService service) {
                return service.isStarting();
            }
        }, false);
        return result;
    }

    @Override
    public boolean isStarted() {
        boolean result = false;
        ConnectorService service = this.getBaseConnectorService();
        if (service == null && this.directoryConnectorServicesMap.size() == 0) {
            result = false;
        } else {
            if (service != null) {
                result = service.isStarted();
            }
            result = result && this.forAllDirectoryServices(new Procedure<ConnectorService>(){

                @Override
                public boolean execute(ConnectorService service) {
                    return service.isStarted();
                }
            }, true);
        }
        return result;
    }

    @Override
    public boolean isStopping() {
        boolean result = false;
        ConnectorService service = this.getBaseConnectorService();
        if (service != null) {
            result = service.isStopping();
        }
        result = result || this.forAllDirectoryServices(new Procedure<ConnectorService>(){

            @Override
            public boolean execute(ConnectorService service) {
                return service.isStopping();
            }
        }, false);
        return result;
    }

    @Override
    public boolean isStopped() {
        boolean result = true;
        ConnectorService service = this.getBaseConnectorService();
        if (service == null && this.directoryConnectorServicesMap.size() == 0) {
            result = true;
        } else {
            if (service != null) {
                result = service.isStopped();
            }
            result = result && this.forAllDirectoryServices(new Procedure<ConnectorService>(){

                @Override
                public boolean execute(ConnectorService service) {
                    return service.isStopped();
                }
            }, true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws ConnectorException {
        ConnectorService service = this.getBaseConnectorService();
        try {
            if (service != null) {
                service.start();
            }
            this.forAllDirectoryServices(new Procedure<ConnectorService>(){

                @Override
                public boolean execute(ConnectorService service) {
                    try {
                        service.start();
                    }
                    catch (ConnectorException e) {
                        throw new RuntimeException(e);
                    }
                    return true;
                }
            }, true);
        }
        catch (Throwable throwable) {
            this.forAllDirectoryServices(new /* invalid duplicate definition of identical inner class */, true);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(boolean startonerror) throws ConnectorException {
        ConnectorService service = this.getBaseConnectorService();
        try {
            if (service != null) {
                service.start(startonerror);
            }
            this.forAllDirectoryServices(new Procedure<ConnectorService>(startonerror){
                final /* synthetic */ boolean val$startonerror;
                {
                    this.val$startonerror = bl;
                }

                @Override
                public boolean execute(ConnectorService service) {
                    try {
                        service.start(this.val$startonerror);
                    }
                    catch (ConnectorException e) {
                        throw new RuntimeException(e);
                    }
                    return true;
                }
            }, true);
        }
        catch (Throwable throwable) {
            this.forAllDirectoryServices(new /* invalid duplicate definition of identical inner class */, true);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        ConnectorService service = this.getBaseConnectorService();
        try {
            this.forAllDirectoryServices(new Procedure<ConnectorService>(){

                @Override
                public boolean execute(ConnectorService service) {
                    service.stop();
                    return true;
                }
            }, true);
        }
        finally {
            if (service != null) {
                service.stop();
            }
        }
    }

    @Override
    public ConnectorInterface getConnectorInterface(String connectorName, ConfigType type) throws ConnectorException {
        ConnectorInterface result = null;
        ConnectorService service = this.getBaseConnectorService();
        if (service != null && service.hasConnector(connectorName)) {
            result = service.getConnectorInterface(connectorName, type);
        }
        if (result == null && this.directoryConnectorServicesMap.size() > 0) {
            result = this.getDirectoryConnectorInterface(connectorName, type);
        }
        if (result == null && service == null && connectorName != null) {
            throw ConnectorRuntimeException.noConnectorServiceForThisThread();
        }
        if (result == null) {
            throw ConnectorException.connectorNotFound(connectorName, type);
        }
        return result;
    }

    @Override
    public boolean hasConnector(String name) {
        boolean result = false;
        ConnectorService service = this.getBaseConnectorService();
        if (service != null) {
            result = service.hasConnector(name);
        }
        if (!result) {
            for (ConnectorService directoryConnectorService : this.directoryConnectorServicesMap.values()) {
                if (!directoryConnectorService.hasConnector(name)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public String getProperty(String key) {
        String result;
        block2: {
            ConnectorService connectorService;
            result = null;
            ConnectorService service = this.getBaseConnectorService();
            if (service != null) {
                result = service.getProperty(key);
            }
            if (result != null || this.directoryConnectorServicesMap.size() <= 0) break block2;
            Iterator<ConnectorService> i$ = this.directoryConnectorServicesMap.values().iterator();
            while (i$.hasNext() && (result = (connectorService = i$.next()).getProperty(key)) == null) {
            }
        }
        return result;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String result = this.getProperty(key);
        return result != null ? result : defaultValue;
    }

    public ClassLoaderService getServiceClassLoader() {
        ConnectorService service = this.getBaseConnectorService();
        return service != null ? service.getClassLoaderService() : null;
    }

    @Override
    public Object getResource(String name, ConfigType type, int resourceType) throws ConnectorException {
        Object result = null;
        ConnectorService service = this.getBaseConnectorService();
        if (service != null && service.hasConnector(name)) {
            result = service.getResource(name, type, resourceType);
        }
        if (result == null && this.directoryConnectorServicesMap.size() > 0) {
            result = this.getDirectoryConnectorResource(name, type, resourceType, null);
        }
        if (result == null) {
            throw ConnectorException.connectorNotFound(name, type);
        }
        return result;
    }

    @Override
    public Object getResource(String name, ConfigType type, int resourceType, Properties properties) throws ConnectorException {
        Object result = null;
        ConnectorService service = this.getBaseConnectorService();
        if (service != null && service.hasConnector(name)) {
            result = service.getResource(name, type, resourceType, properties);
        }
        if (result == null && this.directoryConnectorServicesMap.size() > 0) {
            result = this.getDirectoryConnectorResource(name, type, resourceType, properties);
        }
        if (result == null) {
            throw ConnectorException.connectorNotFound(name, type);
        }
        return result;
    }

    @Override
    public void addConfiguration(String name, String strType, Properties properties) throws ConnectorException {
        ConnectorService service = this.getBaseConnectorService();
        if (service == null) {
            throw new IllegalStateException("Connector service is null");
        }
        service.addConfiguration(name, strType, properties);
    }

    @Override
    public void addConfiguration(String name, String strType, String strSubType, Properties properties) throws ConnectorException {
        ConnectorService service = this.getBaseConnectorService();
        if (service == null) {
            throw new IllegalStateException("Connector service is null");
        }
        service.addConfiguration(name, strType, strSubType, properties);
    }

    boolean isReady() {
        return this.hasConnectorService() || this.areDirectoryConnectorServicesReady();
    }

    private ConnectorInterface getDirectoryConnectorInterface(String connectorName, ConfigType type) throws ConnectorException {
        ConnectorInterface result = null;
        if (type instanceof DirectoryConfigType) {
            DirectoryConfigType dirConfigType = (DirectoryConfigType)type;
            ConnectorService directoryConnectorService = this.directoryConnectorServicesMap.get(dirConfigType.getDirectoryId());
            if (directoryConnectorService != null) {
                result = directoryConnectorService.getConnectorInterface(connectorName, dirConfigType.getActualConfigType());
            }
        } else if (connectorName.equals("__internal__")) {
            ConnectorService directoryConnectorService = this.getDirectoryConnectorServiceForConnector(connectorName);
            result = directoryConnectorService.getConnectorInterface(connectorName, type);
        }
        return result;
    }

    private Object getDirectoryConnectorResource(String name, ConfigType type, int resourceType, Properties properties) throws ConnectorException {
        Object result = null;
        if (type instanceof DirectoryConfigType) {
            DirectoryConfigType dirConfigType = (DirectoryConfigType)type;
            ConnectorService directoryConnectorService = this.directoryConnectorServicesMap.get(dirConfigType.getDirectoryId());
            if (directoryConnectorService != null) {
                result = directoryConnectorService.getResource(name, dirConfigType.getActualConfigType(), resourceType, properties);
            }
        } else if (name.equals("__internal__")) {
            ConnectorService directoryConnectorService = this.getDirectoryConnectorServiceForConnector(name);
            result = directoryConnectorService.getResource(name, type, resourceType, properties);
        }
        return result;
    }

    private ConnectorService getDirectoryConnectorServiceById(String directoryId) {
        return this.directoryConnectorServicesMap.get(directoryId);
    }

    private void setDirectoryConnectorService(String directoryId, ConnectorService directoryConnectorService) {
        if (this.directoryConnectorServicesMap.get(directoryId) != null && !this.directoryConnectorServicesMap.get(directoryId).isStopped()) {
            throw new IllegalStateException("Cannot set the directory Connector Service while connector service is started");
        }
        this.directoryConnectorServicesMap.put(directoryId, directoryConnectorService);
    }

    private ConnectorService getDirectoryConnectorServiceForConnector(String connectorName) {
        ConnectorService result = null;
        for (ConnectorService connectorService : this.directoryConnectorServicesMap.values()) {
            if (!connectorService.hasConnector(connectorName)) continue;
            result = connectorService;
            break;
        }
        return result;
    }

    private ConnectorService getBaseConnectorService() {
        ConnectorService baseConnectorService = (ConnectorService)this.threadConnectorService.get();
        if (baseConnectorService == null) {
            baseConnectorService = this.defaultConnectorService;
        }
        return baseConnectorService;
    }

    private boolean areDirectoryConnectorServicesReady() {
        boolean allDirServicesReady = true;
        Map<String, DirectoryConfigurationManager> managersMap = DirectoryConfigurationManager.getAllRuntimes();
        for (Map.Entry<String, DirectoryConfigurationManager> entry : managersMap.entrySet()) {
            try {
                entry.getValue().getDirectoryConfiguration();
                if (this.getDirectoryConnectorServiceById(entry.getKey()) != null) continue;
                allDirServicesReady = false;
            }
            catch (IllegalStateException e) {
                if (entry.getValue().isAutoLoaded()) continue;
                allDirServicesReady = false;
            }
            break;
        }
        return allDirServicesReady;
    }

    private boolean forAllDirectoryServices(Procedure<ConnectorService> procedure, boolean defaultResult) {
        boolean result = defaultResult;
        for (ConnectorService connectorService : this.directoryConnectorServicesMap.values()) {
            result &= procedure.execute(connectorService);
        }
        return result;
    }
}

