/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.impl;

import java.util.Properties;
import oracle.bpm.configuration.exception.InvalidConfigurationException;
import oracle.bpm.configuration.impl.BaseConfigurationEditorBean;
import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.configuration.util.ValidationUtilities;
import oracle.bpm.connector.impl.PoolConfigurationBean;
import oracle.bpm.lib.msg.LibMsg;

public abstract class DatabaseConfiguration
extends BaseConfigurationEditorBean
implements ConfigurationEditorBean,
PoolConfigurationBean {
    private int connectionIdleTime;
    private int entrySize;
    private String host;
    private int maxOpenCursors;
    private int minConnections;
    private String password;
    private int port;
    private String schema;
    private int size;
    private String user;
    private boolean xa;

    protected DatabaseConfiguration(Properties properties) {
        super(properties);
        this.schema = properties.getProperty("jdbc.schema");
        this.user = properties.getProperty("user");
        this.password = ValidationUtilities.unscrambleText(properties.getProperty("password"));
        this.host = properties.getProperty("jdbc.host");
        this.xa = Boolean.valueOf(properties.getProperty("jdbc.xa", "false"));
        this.size = Integer.parseInt(properties.getProperty("jdbc.pool.max", "10"));
        this.entrySize = Integer.parseInt(properties.getProperty("jdbc.pool.entry.max", "10"));
        this.minConnections = Integer.parseInt(properties.getProperty("jdbc.pool.min", "0"));
        this.maxOpenCursors = Integer.parseInt(properties.getProperty("jdbc.pool.maxopencursors", "100"));
        this.connectionIdleTime = Integer.parseInt(properties.getProperty("jdbc.pool.idle_timeout", "5"));
    }

    public abstract String getURL(Properties var1);

    public final void setHost(String host) {
        this.host = host;
    }

    public final String getHost() {
        if (this.host != null) {
            return this.host;
        }
        return "";
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final String getPassword() {
        if (this.password != null) {
            return this.password;
        }
        return "";
    }

    public final void setPort(int port) {
        this.port = port;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setSchema(String schema) {
        this.schema = schema;
    }

    public final String getSchema() {
        if (this.schema != null) {
            return this.schema;
        }
        return "";
    }

    public final void setUser(String user) {
        this.user = user;
    }

    public final String getUser() {
        if (this.user != null) {
            return this.user;
        }
        return "";
    }

    public final void setXa(boolean xa) {
        this.xa = xa;
    }

    public final boolean isXa() {
        return this.xa;
    }

    @Override
    public int getEntrySize() {
        return this.entrySize;
    }

    @Override
    public void setEntrySize(int entrySize) {
        this.entrySize = entrySize;
    }

    @Override
    public void setConnectionIdleTime(int connectionIdleTime) {
        this.connectionIdleTime = connectionIdleTime;
    }

    @Override
    public int getConnectionIdleTime() {
        return this.connectionIdleTime;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public void setMaxOpenCursors(int maxOpenCursors) {
        this.maxOpenCursors = maxOpenCursors;
    }

    public int getMaxOpenCursors() {
        return this.maxOpenCursors;
    }

    public String getUrl() {
        return this.getURL(this.asProperties());
    }

    @Override
    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    @Override
    public int getMinConnections() {
        return this.minConnections;
    }

    @Override
    public Properties asProperties() {
        Properties properties = super.asProperties();
        properties.put("jdbc.schema", this.getSchema());
        properties.put("user", this.getUser());
        properties.put("password", ValidationUtilities.scrambleText(this.getPassword()));
        properties.put("jdbc.host", this.getHost());
        properties.put("jdbc.port", String.valueOf(this.getPort()));
        properties.put("jdbc.xa", String.valueOf(this.isXa()));
        properties.put("jdbc.pool.max", String.valueOf(this.getSize()));
        properties.put("jdbc.pool.entry.max", String.valueOf(this.getEntrySize()));
        properties.put("jdbc.pool.min", String.valueOf(this.getMinConnections()));
        properties.put("jdbc.pool.maxopencursors", String.valueOf(this.getMaxOpenCursors()));
        properties.put("jdbc.pool.idle_timeout", String.valueOf(this.getConnectionIdleTime()));
        return properties;
    }

    @Override
    public void validate() throws InvalidConfigurationException {
        this.validateConnectionValues();
        this.validateAuthenticationValues();
        this.validatePoolValues();
    }

    protected void validateAuthenticationValues() throws InvalidConfigurationException {
        if (this.getUser().length() == 0) {
            throw InvalidConfigurationException.validationFailed(LibMsg.USER.getString());
        }
        if (Character.isDigit(this.getUser().charAt(0))) {
            throw InvalidConfigurationException.userValidationFailed(LibMsg.USER.getString());
        }
        if (this.getUser().indexOf(39) != -1 || this.getUser().indexOf(34) != -1 || this.getUser().indexOf(45) != -1 || this.getUser().indexOf(32) != -1) {
            throw InvalidConfigurationException.validationFailed(LibMsg.USER.getString());
        }
        if (this.getSchema().length() > 0 && Character.isDigit(this.getSchema().charAt(0))) {
            throw InvalidConfigurationException.schemaValidationFailed(LibMsg.SCHEMA.getString());
        }
        if (this.getSchema().indexOf(39) != -1 || this.getSchema().indexOf(34) != -1 || this.getSchema().indexOf(45) != -1) {
            throw InvalidConfigurationException.validationFailed(LibMsg.SCHEMA.getString());
        }
    }

    protected void validateConnectionValues() throws InvalidConfigurationException {
        if (this.getHost().trim().equals("")) {
            throw InvalidConfigurationException.validationFailed(LibMsg.HOST.getString());
        }
        if (!ValidationUtilities.checkPort(this.getPort())) {
            throw InvalidConfigurationException.validationFailed(LibMsg.PORT.getString());
        }
    }

    protected void validatePoolValues() throws InvalidConfigurationException {
        if (this.getSize() <= 0) {
            throw InvalidConfigurationException.validationFailed(LibMsg.POOL_MAX.getString());
        }
        if (this.getMinConnections() < 0) {
            throw InvalidConfigurationException.validationFailed(LibMsg.POOL_MIN.getString());
        }
        if (this.getMaxOpenCursors() < 0) {
            throw InvalidConfigurationException.validationFailed(LibMsg.MAX_OPEN_CURSORS.getString());
        }
        if (this.getConnectionIdleTime() < 0) {
            throw InvalidConfigurationException.validationFailed(LibMsg.POOL_IDLE_TIME.getString());
        }
        if (this.getMaxOpenCursors() != 0 && this.getMaxOpenCursors() < this.getSize()) {
            throw InvalidConfigurationException.validationFailed(LibMsg.MAX_OPEN_CURSORS_GREATER_POOL_MAX);
        }
    }
}

