/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration;

import fuego.directory.DirConfiguration;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import java.io.IOException;
import java.io.StringWriter;
import oracle.bpm.configuration.BaseConfiguration;
import oracle.bpm.configuration.ConfigurationManager;
import oracle.bpm.configuration.ConfigurationRuntimeException;
import oracle.bpm.configuration.ConfigurationSet;

class DirectoryManager<T extends BaseConfiguration>
extends ConfigurationManager<T> {
    private DirectorySession session;

    public DirectoryManager(ConfigurationSet<T> configurations, DirectorySession session) {
        super(configurations);
        this.session = session;
    }

    @Override
    public void reloadConfigurations() {
        throw new UnsupportedOperationException("reload not implemented on directory configurations");
    }

    @Override
    protected void persistConfigurations() {
        try {
            StringWriter writer = new StringWriter();
            this.configurations.writeXML(writer);
            writer.close();
            String properties = writer.toString();
            DirConfiguration configuration = DirConfiguration.fetch(this.session);
            if (configuration == null) {
                DirConfiguration.create(this.session, properties);
            } else {
                configuration.setProperties(properties);
                configuration.update();
            }
        }
        catch (DirectoryException e) {
            throw ConfigurationRuntimeException.cannotCreateManager(this.session, (Exception)e);
        }
        catch (IOException e) {
            throw ConfigurationRuntimeException.cannotCreateManager(this.session, (Exception)e);
        }
    }

    @Override
    protected void configRemoved(T deletedEntry) {
    }
}

