/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.configuration.BaseConfiguration;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.configuration.Configuration;
import oracle.bpm.configuration.ConfigurationRuntimeException;
import oracle.bpm.configuration.ConfigurationSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigurationLoader<T extends BaseConfiguration>
extends DefaultHandler {
    protected String currentName;
    protected Properties currentProperties;
    protected String currentSubType;
    protected String currentType;
    protected InputStream is_d;
    private ConfigurationSet<T> container_d;
    private boolean ignoreUnregistered;
    static final String SET_TAG = "set";
    protected static final String CONFIGURATION_TAG = "configuration";
    public static final String PROPERTY_TAG = "property";
    protected static final String VARIABLE_TAG = "variable";
    public static final String NAME_TAG = "name";
    public static final String VALUE_TAG = "value";
    public static final String TYPE_TAG = "type";
    public static final String SUBTYPE_TAG = "subtype";

    protected ConfigurationLoader(ConfigurationSet<T> configuration, InputStream is, boolean ignoreUnregistered) {
        this.setContainer(configuration);
        this.is_d = is;
        this.ignoreUnregistered = ignoreUnregistered;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (CONFIGURATION_TAG.equalsIgnoreCase(qName)) {
            this.addConfig();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (CONFIGURATION_TAG.equalsIgnoreCase(qName)) {
            this.currentName = this.getConfigurationName(attributes.getValue(NAME_TAG));
            this.currentType = attributes.getValue(TYPE_TAG);
            this.currentSubType = attributes.getValue(SUBTYPE_TAG);
            this.currentProperties = new Properties();
        }
        if (PROPERTY_TAG.equalsIgnoreCase(qName)) {
            if (this.currentProperties == null) {
                throw new SAXException(ConfigurationRuntimeException.invalidFormatForProperty(qName));
            }
            String value = attributes.getValue(VALUE_TAG);
            if (value == null) {
                value = "";
            }
            this.currentProperties.put(attributes.getValue(NAME_TAG), value);
        }
        if (VARIABLE_TAG.equalsIgnoreCase(qName)) {
            this.getContainer().addVariable(attributes.getValue(NAME_TAG), attributes.getValue(VALUE_TAG));
        }
    }

    public void parse() throws ConfigurationRuntimeException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(this.is_d, (DefaultHandler)this);
        }
        catch (SAXException ex) {
            if (ex.getException() != null) {
                throw ConfigurationRuntimeException.parseException(ex.getException());
            }
            throw ConfigurationRuntimeException.parseException(ex);
        }
        catch (ParserConfigurationException e) {
            throw ConfigurationRuntimeException.parseException(e);
        }
        catch (IOException e) {
            throw ConfigurationRuntimeException.parseException(e);
        }
    }

    public void setContainer(ConfigurationSet<T> container_d) {
        this.container_d = container_d;
    }

    protected String getConfigurationName(String parsedName) {
        return parsedName;
    }

    protected void addConfig() {
        ConfigType st = this.currentSubType == null || this.currentType.equals(this.currentSubType) ? ConfigType.find(this.currentType) : ConfigType.find(this.currentType, this.currentSubType);
        if (st == null) {
            if (!this.ignoreUnregistered) {
                throw ConfigurationRuntimeException.subTypeNotRegistered(this.currentType, this.currentSubType);
            }
        } else {
            Configuration configuration = this.createConfiguration(st);
            this.getContainer().addEntry(configuration);
        }
        this.currentProperties = null;
        this.currentName = null;
        this.currentType = null;
        this.currentSubType = null;
    }

    protected Configuration createConfiguration(ConfigType st) {
        return new Configuration(this.currentName, st, this.currentProperties);
    }

    protected ConfigurationSet getContainer() {
        return this.container_d;
    }
}

