/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;

@Component(module="Fuego.Lib")
public class ServerSession {
    @Hidden
    protected static Map<String, Object> map_sd = Collections.synchronizedMap(new HashMap());

    @Hidden
    public ServerSession() {
    }

    public static boolean isEmpty() {
        return map_sd.isEmpty();
    }

    public static void clear() {
        map_sd.clear();
    }

    public static boolean containsKey(String name) {
        return map_sd.containsKey(name);
    }

    public static boolean containsValue(Object value) {
        return map_sd.containsValue(value);
    }

    public static String[] keys() {
        return map_sd.keySet().toArray(new String[map_sd.size()]);
    }

    public static void putObjectIn(String name, Object value) {
        if (Log.isDebugging()) {
            Log.logDebug(LibMsg.SESSIONCOMPONENT_TRACE_PUT("ServerSession", name, "" + value));
        }
        map_sd.put(name, value);
    }

    public static void putValueIn(String name, String value) {
        if (Log.isDebugging()) {
            Log.logDebug(LibMsg.SESSIONCOMPONENT_TRACE_PUT("ServerSession", name, "" + value));
        }
        map_sd.put(name, value);
    }

    public static Object removeObjectValueFrom(String name) {
        Object result = map_sd.remove(name);
        if (Log.isDebugging()) {
            Log.logDebug(LibMsg.SESSIONCOMPONENT_TRACE_REMOVE("ServerSession", name));
        }
        return result;
    }

    public static String removeValueFrom(String name) {
        Object result = map_sd.remove(name);
        if (Log.isDebugging()) {
            Log.logDebug(LibMsg.SESSIONCOMPONENT_TRACE_REMOVE("ServerSession", name));
        }
        if (result != null && result instanceof String) {
            return (String)result;
        }
        return null;
    }

    public static Object retrieveObjectFrom(String name, Object defaultValue) {
        Object result = map_sd.get(name);
        if (result != null) {
            if (Log.isDebugging()) {
                Log.logDebug(LibMsg.SESSIONCOMPONENT_TRACE_RETRIEVEFOUND("ServerSession", name, "" + result));
            }
        } else if (Log.isDebugging()) {
            Log.logDebug(LibMsg.SESSIONCOMPONENT_TRACE_RETRIEVENOTFOUND("ServerSession", name, "" + defaultValue));
        }
        return result == null ? defaultValue : result;
    }

    public static String retrieveValueFrom(String name) {
        String result = (String)map_sd.get(name);
        if (Log.isDebugging()) {
            Log.logDebug(LibMsg.SESSIONCOMPONENT_TRACE_RETRIEVEFOUND("ServerSession", name, result));
        }
        return result;
    }

    public static int size() {
        return map_sd.size();
    }

    public static Object[] values() {
        return map_sd.values().toArray();
    }
}

