/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import fuego.directory.DirDeployedProcess;
import fuego.directory.DirectorySession;
import java.util.ArrayList;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.EnterpriseOnly;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.components.Activity;
import oracle.bpm.components.ActivityInterface;
import oracle.bpm.components.DirectoryException;
import oracle.bpm.components.InstanceRetrieverInterface;
import oracle.bpm.components.Participant;
import oracle.bpm.components.ProcessInstance;
import oracle.bpm.components.ProcessInterface;
import oracle.bpm.lang.ArgumentMap;
import oracle.bpm.lang.DynamicObject;

@Component(module="Fuego.Lib")
public class Process {
    protected ProcessInterface process;

    @Hidden
    public Process() {
        this.process = ProcessInstance.getProcess().process;
    }

    @Exclude
    public Process(ProcessInterface aProcess) {
        this.process = aProcess;
    }

    @Deprecated
    @Exclude
    public static String createInstance(ProcessInstance server, String processId, DynamicObject parameters) {
        return Process.createInstance(server, processId, null, (ArgumentMap)parameters);
    }

    @Exclude
    public static String createInstance(ProcessInstance server, String processId, String argumentsSetName, DynamicObject arguments) {
        return server.getBean().createInstance(processId, argumentsSetName, arguments);
    }

    @Exclude
    public static String createInstance(ProcessInstance server, String processId, String argumentsSetName, ArgumentMap arguments) {
        return server.getBean().createInstance(processId, argumentsSetName, arguments);
    }

    @Exclude
    public static Process defaultInstance() {
        return ProcessInstance.getProcess();
    }

    public Activity[] getActivities() {
        ActivityInterface[] activities = this.getProcess().getActivitiesInterface();
        Activity[] result = new Activity[activities.length];
        for (int i = 0; i < activities.length; ++i) {
            result[i] = new Activity(activities[i]);
        }
        return result;
    }

    @Exclude
    public ActivityInterface getActivityInterface(String activityName) {
        return this.getProcess().getActivityInterface(activityName);
    }

    public final String getId() {
        return this.process.getId();
    }

    public int getIdNumber() {
        return ProcessInstance.getCurrent().getBean().getProcessIn();
    }

    public String getName() {
        return this.process.getName();
    }

    @Exclude
    public ProcessInterface getProcess() {
        return this.process;
    }

    public String retrieveEncryptedPropertyFor(String name, String key) throws DirectoryException {
        return this.retrieveEncryptedPropertyFor(null, name, key);
    }

    public String retrieveEncryptedPropertyFor(String application, String name, String key) throws DirectoryException {
        try {
            return this.getProcess().retrieveEncryptedPropertyFor(application, name, key);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveInstances() {
        return this.instancesImpl(2);
    }

    @Hidden
    public Object retrieveObjectPropertyFor(String name) throws DirectoryException {
        return this.retrieveObjectPropertyFor(null, name);
    }

    public Object retrieveObjectPropertyFor(String application, String name) throws DirectoryException {
        try {
            return this.getProcess().retrieveObjectPropertyFor(application, name);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrievePendingInstances() {
        return this.instancesImpl(0);
    }

    @Hidden
    public String retrievePropertyFor(String name) throws DirectoryException {
        return this.retrievePropertyFor(null, name);
    }

    public String retrievePropertyFor(String application, String name) throws DirectoryException {
        try {
            return this.getProcess().retrievePropertyFor(application, name);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveSelectedInstances(Participant participant) {
        return this.selectedInstancesImpl(2, participant);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveSelectedPendingInstances(Participant participant) {
        return this.selectedInstancesImpl(0, participant);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveSelectedSuspendedInstances(Participant participant) {
        return this.selectedInstancesImpl(1, participant);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveSuspendedInstances() {
        return this.instancesImpl(1);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveUnselectedInstances() {
        return this.unselectedInstancesImpl(2);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveUnselectedPendingInstances() {
        return this.unselectedInstancesImpl(0);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveUnselectedSuspendedInstances() {
        return this.unselectedInstancesImpl(1);
    }

    public void storeEncryptedPropertyFor(String name, String value, String key) throws DirectoryException {
        this.storeEncryptedPropertyFor(null, name, value, key);
    }

    public void storeEncryptedPropertyFor(String application, String name, String value, String key) throws DirectoryException {
        try {
            this.getProcess().storeEncryptedPropertyFor(application, name, value, key);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Hidden
    public void storeObjectPropertyFor(String name, Object value) throws Exception {
        this.storeObjectPropertyFor(null, name, value);
    }

    public void storeObjectPropertyFor(String application, String name, Object value) throws Exception {
        this.getProcess().storeObjectPropertyFor(application, name, value);
    }

    @Hidden
    public void storePropertyFor(String name, String value) throws DirectoryException {
        this.storePropertyFor(null, name, value);
    }

    public void storePropertyFor(String application, String name, String value) throws DirectoryException {
        try {
            this.getProcess().storePropertyFor(application, name, value);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Hidden
    protected DirDeployedProcess getDirectoryServiceProcess() throws DirectoryException {
        try {
            return DirDeployedProcess.fetch(this.getDirectorySession(), this.getIdNumber());
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Hidden
    protected DirectorySession getDirectorySession() throws DirectoryException {
        try {
            return ProcessInstance.getDirectorySession();
        }
        catch (Exception e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Hidden
    boolean isProcedure() {
        return this.process.isProcedure();
    }

    @Hidden
    private ArrayList instancesImpl(int type) {
        InstanceRetrieverInterface instanceRetrieverInterface = ProcessInstance.getCurrent().getInstanceRetrieverInterface();
        return instanceRetrieverInterface.getInstances(type);
    }

    @Hidden
    private ArrayList selectedInstancesImpl(int type, Participant participant) {
        InstanceRetrieverInterface instanceRetrieverInterface = ProcessInstance.getCurrent().getInstanceRetrieverInterface();
        return instanceRetrieverInterface.getSelectedInstances(type, participant.participantInterface());
    }

    @Hidden
    private ArrayList unselectedInstancesImpl(int type) {
        InstanceRetrieverInterface instanceRetrieverInterface = ProcessInstance.getCurrent().getInstanceRetrieverInterface();
        return instanceRetrieverInterface.getUnselectedInstances(type);
    }
}

