/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import fuego.directory.DirHumanParticipant;
import fuego.directory.DirOrganizationalUnit;
import fuego.directory.Directory;
import fuego.directory.DirectoryPassport;
import fuego.directory.DirectorySession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.component.metadata.ReplacementFor;
import oracle.bpm.components.Attachment;
import oracle.bpm.components.ComponentRuntimeException;
import oracle.bpm.components.DirectoryException;
import oracle.bpm.components.Locale;
import oracle.bpm.components.NoSuchParticipantException;
import oracle.bpm.components.ParticipantInterface;
import oracle.bpm.components.ProcessBeanInterface;
import oracle.bpm.components.ProcessInstance;
import oracle.bpm.components.ProcessInstanceInterface;
import oracle.bpm.components.Role;
import oracle.bpm.components.RoleInterface;
import oracle.bpm.components.Server;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.util.ExecutionContext;
import oracle.bpm.util.ExecutionContextAccessor;

@Component(module="Fuego.Lib", runsOnClient=false)
public class Participant
implements Serializable {
    transient Role[] roles_d;
    private boolean automatic;
    private transient ParticipantInterface participant_d;
    private transient ProcessInstanceInterface pdata;
    private String uid;
    static final long serialVersionUID = -8376900198944127416L;
    static transient Participant auto_sd;
    public static final Participant Unselect;
    static final long serialCheck = -2511383023847152196L;

    public Participant() {
    }

    @Exclude
    public Participant(ParticipantInterface participant) {
        this.setParticipant(participant);
        this.initMembers();
    }

    public Participant(String name) throws NoSuchParticipantException {
        this.setParticipant(Participant.findInterface(name));
        this.initMembers();
    }

    @Hidden
    public static Participant getAutomaticParticipant() {
        if (auto_sd == null) {
            auto_sd = Participant.find(null);
        }
        return auto_sd;
    }

    public static Participant find(String name) {
        ParticipantInterface p = Participant.findInterface(name);
        return p == null ? null : new Participant(p);
    }

    @Exclude
    public static void find(String name, Holder participant) {
        ParticipantInterface p = Participant.findInterface(name);
        participant.value = p == null ? null : new Participant(p);
    }

    public static Participant findByEmail(String email) {
        ParticipantInterface p = Participant.findInterfaceByEmail(email);
        return p == null ? null : new Participant(p);
    }

    @Hidden
    public static boolean create(String url, String user, String password, String name, String sn, String id, String userPassword) {
        return Participant.createParticipant(url, user, password, null, id, name, sn, sn + ", " + name, null, null, null, userPassword);
    }

    public final Attachment[] getAttachments() throws ComponentExecutionException {
        ParticipantInterface p = this.participantInterface();
        if (p == null) {
            return new Attachment[0];
        }
        return ProcessInstance.getCurrent().getBean().getParticipantAttachmentsComponents(p.getId());
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public String getEmail() {
        return this.getMailAddress();
    }

    public boolean isEnabled() {
        ParticipantInterface p = this.participantInterface();
        return p != null && p.isEnabled();
    }

    public String getId() {
        this.getParticipant();
        return this.uid;
    }

    @ReplacementFor(value="inAttr")
    public int getIdNumber() {
        ParticipantInterface p = this.participantInterface();
        return p == null ? 0 : p.getIn();
    }

    @Exclude
    public int getIn() {
        return this.getIdNumber();
    }

    @Hidden
    public String getMailAddress() {
        ParticipantInterface p = this.participantInterface();
        return p == null ? "" : p.getMailAddress();
    }

    public String getTelephone() {
        ParticipantInterface p = this.participantInterface();
        return p == null ? "" : p.getTelephone();
    }

    public String getFirstName() {
        ParticipantInterface p = this.participantInterface();
        return p == null ? "" : p.getFirstName();
    }

    public String getLastName() {
        ParticipantInterface p = this.participantInterface();
        return p == null ? "" : p.getLastName();
    }

    public String getName() {
        ParticipantInterface p = this.participantInterface();
        return p == null ? "" : p.getName();
    }

    public void setNext(Participant participant) {
        if (this.pdata != null) {
            this.pdata.setNextParticipant(participant != null ? participant.participantInterface() : null);
        }
    }

    public boolean isOnline() {
        if (this.isValid()) {
            return ProcessInstance.getCurrent().isOnline(this.participantInterface());
        }
        return false;
    }

    public String getOrganization() {
        ParticipantInterface p = this.participantInterface();
        return p == null ? "" : p.getOrganization();
    }

    public String getOrganizationalUnit() {
        ParticipantInterface p = this.participantInterface();
        return p == null ? "" : p.getOrganizationalUnit();
    }

    @Exclude
    public ParticipantInterface getParticipant() {
        if (this.participant_d == null) {
            if (this.uid == null) {
                ExecutionContext ctx = ExecutionContextAccessor.getContext();
                if (ctx == null) {
                    throw new IllegalStateException(LibMsg.MUST_RUN_SERVER_SIDE.getString());
                }
                ProcessBeanInterface processBean = (ProcessBeanInterface)ctx.getProperty("oracle.bpm.components.ProcessInstance.currentProcessBean");
                if (processBean == null) {
                    throw new RuntimeException(CoreMsg.SERVER_METHOD_INSIDE_CLIENT.toString());
                }
                this.participant_d = processBean.getParticipantInterface();
            } else {
                this.participant_d = Participant.findInterface(this.uid);
            }
            this.initMembers();
        }
        return this.participant_d;
    }

    @Exclude
    public String getPassword() {
        ParticipantInterface p = this.participantInterface();
        return p == null ? "" : p.getPassword();
    }

    public boolean isPresent() {
        ParticipantInterface p = this.participantInterface();
        return p != null && p.isPresent();
    }

    public Role[] getRoles() {
        if (this.roles_d == null) {
            ParticipantInterface p = this.participantInterface();
            if (p == null) {
                this.roles_d = new Role[0];
            } else {
                List<RoleInterface> rolesList = p.getRoles();
                this.roles_d = new Role[rolesList == null ? 0 : rolesList.size()];
                int index = 0;
                if (rolesList != null) {
                    Iterator<RoleInterface> rolesIt = rolesList.iterator();
                    while (rolesIt.hasNext()) {
                        this.roles_d[index++] = new Role(rolesIt.next());
                    }
                }
            }
        }
        return this.roles_d;
    }

    public void setSticky(boolean sticky) {
        if (this.pdata != null) {
            this.pdata.setStickyParticipant(sticky);
        }
    }

    public boolean getSticky() {
        return this.pdata == null ? false : this.pdata.hasStickyParticipant();
    }

    @Hidden
    public boolean isValid() {
        ParticipantInterface p = this.participantInterface();
        return p != null;
    }

    public final boolean releaseAttachment(Attachment attach) {
        boolean result = true;
        ParticipantInterface p = this.participantInterface();
        try {
            attach.release(this);
        }
        catch (Exception e) {
            Log.logWarning(e);
            result = false;
        }
        return result;
    }

    public final boolean editAttachment(Attachment attach) {
        boolean result = true;
        ParticipantInterface p = this.participantInterface();
        try {
            attach.edit(this);
        }
        catch (Exception e) {
            Log.logWarning(e);
            result = false;
        }
        return result;
    }

    public Locale getLocale() {
        return this.getParticipant().getLocale();
    }

    public TimeZone getTimeZone() {
        return this.getParticipant().getTimeZone();
    }

    public Participant getNext() {
        return this.pdata == null ? null : this.pdata.getNextParticipantComponent();
    }

    @Exclude
    public void setParticipant(ParticipantInterface participant_d) {
        this.participant_d = participant_d;
    }

    public boolean commitAttachment(String remarks, byte[] localAttachmentContent, Attachment attach) {
        boolean result = true;
        try {
            attach.commit(localAttachmentContent, remarks, this);
        }
        catch (Exception e) {
            LibMsg.ERROR_COMMIT_ATTACHMENT(attach.getId(), e).logWarning();
            result = false;
        }
        return result;
    }

    @Exclude
    public boolean equals(Object obj) {
        if (this.getParticipant() == null) {
            return false;
        }
        if (!(obj instanceof Participant)) {
            return false;
        }
        return this.getParticipant().equals(((Participant)obj).getParticipant());
    }

    public int hashCode() {
        return System.identityHashCode(this.getParticipant());
    }

    @Exclude
    public ParticipantInterface participantInterface() {
        if (this.getParticipant() == null) {
            if (this.automatic) {
                this.setParticipant(Participant.findInterface(null));
            } else if (this.uid == null) {
                this.setParticipant(ProcessInstance.getCurrent().getParticipantInterface());
            } else {
                this.setParticipant(Participant.findInterface(this.uid));
            }
            this.initMembers();
        }
        return this.getParticipant();
    }

    public String retrieveEncryptedPropertyFor(String name, String keyword) throws DirectoryException {
        return this.retrieveEncryptedPropertyFor(null, name, keyword);
    }

    public String retrieveEncryptedPropertyFor(String application, String name, String keyword) throws DirectoryException {
        if (this.getParticipant() == null) {
            return null;
        }
        try {
            return this.getParticipant().retrieveEncryptedPropertyFor(application, name, keyword);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Hidden
    public Object retrieveObjectPropertyFor(String name) throws DirectoryException {
        return this.retrieveObjectPropertyFor(null, name);
    }

    public Object retrieveObjectPropertyFor(String application, String name) throws DirectoryException {
        if (this.getParticipant() == null) {
            return null;
        }
        try {
            return this.getParticipant().retrieveObjectPropertyFor(application, name);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Hidden
    public String retrievePropertyFor(String name) throws DirectoryException {
        return this.retrievePropertyFor(null, name);
    }

    public String retrievePropertyFor(String application, String name) throws DirectoryException {
        if (this.getParticipant() == null) {
            return null;
        }
        try {
            return this.getParticipant().retrievePropertyFor(application, name);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    public void storeEncryptedPropertyFor(String name, String value, String keyword) throws DirectoryException {
        this.storeEncryptedPropertyFor(null, name, value, keyword);
    }

    public void storeEncryptedPropertyFor(String application, String name, String value, String keyword) throws DirectoryException {
        if (this.getParticipant() == null) {
            return;
        }
        try {
            this.getParticipant().storeEncryptedPropertyFor(application, name, value, keyword);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Hidden
    public void storeObjectPropertyFor(String name, Object value) throws Exception {
        this.storeObjectPropertyFor(null, name, value);
    }

    public void storeObjectPropertyFor(String application, String name, Object value) throws Exception {
        if (this.getParticipant() == null) {
            return;
        }
        this.getParticipant().storeObjectPropertyFor(application, name, value);
    }

    @Hidden
    public void storePropertyFor(String name, String value) throws DirectoryException {
        this.storePropertyFor(null, name, value);
    }

    public void storePropertyFor(String application, String name, String value) throws DirectoryException {
        if (this.getParticipant() == null) {
            return;
        }
        try {
            this.getParticipant().storePropertyFor(application, name, value);
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Exclude
    public String toString() {
        return "Participant(" + (this.isAutomatic() ? "automatic" : this.getId()) + ")";
    }

    @Hidden
    protected DirHumanParticipant getDirectoryServiceParticipant() throws DirectoryException {
        try {
            return DirHumanParticipant.fetch(this.getDirectorySession(), this.getId());
        }
        catch (fuego.directory.DirectoryException e) {
            throw new DirectoryException(e.getLocalizedMessage());
        }
    }

    @Hidden
    protected DirectorySession getDirectorySession() throws DirectoryException {
        return ProcessInstance.getDirectorySession();
    }

    void setProcessInterface(ProcessInstanceInterface pdata) {
        this.pdata = pdata;
    }

    private static boolean createParticipant(String url, String user, String password, String ou, String id, String name, String sn, String displayName, String mail, String telephone, String fax, String userPassword) {
        try {
            DirectoryPassport passport = DirectoryPassport.createWithID(url, user);
            passport.setPassword(password);
            DirectorySession session = Directory.startSession(passport);
            DirOrganizationalUnit unit = ou == null ? DirOrganizationalUnit.fetchRoot(session) : DirOrganizationalUnit.fetch(session, ou);
            DirHumanParticipant newParticipant = DirHumanParticipant.create(session, id, name, sn, displayName, mail, telephone, fax, userPassword, unit, new DirHumanParticipant.RoleAssignment[0], true);
            newParticipant.storeProperty("prefs", "mail", (Serializable)((Object)Boolean.FALSE.toString()));
        }
        catch (fuego.directory.DirectoryException dex) {
            throw new ComponentRuntimeException(LibMsg.COULD_NOT_CREATE_PARTICIPANT);
        }
        return true;
    }

    private static ParticipantInterface findInterface(String name) {
        return Server.getServerInterface().getParticipantInterface(name);
    }

    private static ParticipantInterface findInterfaceByEmail(String email) {
        return Server.getServerInterface().getParticipantInterfaceByEmail(email);
    }

    private void initMembers() {
        if (this.getParticipant() != null) {
            this.uid = this.getParticipant().getId();
            this.automatic = this.getParticipant().isAutomatic();
        }
    }

    static {
        Unselect = new Participant(new UnselectParticipant());
    }

    @Exclude
    private static final class UnselectParticipant
    implements ParticipantInterface {
        private UnselectParticipant() {
        }

        @Override
        public String getActualId() {
            return "";
        }

        @Override
        public boolean isAutomatic() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return "Fuego Unselect Participant";
        }

        @Override
        public void setEnabled(boolean enabled) {
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public String getId() {
            return "FuegoUnselectParticipant";
        }

        @Override
        public int getIn() {
            return -5;
        }

        @Override
        public Locale getLocale() {
            return new Locale();
        }

        @Override
        public String getMailAddress() {
            return "";
        }

        @Override
        public String getTelephone() {
            return "";
        }

        @Override
        public String getFirstName() {
            return "";
        }

        @Override
        public String getLastName() {
            return "";
        }

        @Override
        public String getName() {
            return this.getId();
        }

        @Override
        public String getOrganization() {
            return "";
        }

        @Override
        public String getOrganizationalUnit() {
            return "";
        }

        @Override
        public String getPassword() {
            return "";
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public List<RoleInterface> getRoles() {
            return new ArrayList<RoleInterface>();
        }

        @Override
        public String retrieveEncryptedPropertyFor(String application, String name, String keyword) {
            return null;
        }

        @Override
        public Object retrieveObjectPropertyFor(String application, String name) {
            return null;
        }

        @Override
        public String retrievePropertyFor(String application, String name) {
            return null;
        }

        @Override
        public void storeEncryptedPropertyFor(String application, String name, String value, String keyword) {
        }

        @Override
        public void storeObjectPropertyFor(String application, String name, Object value) throws Exception {
        }

        @Override
        public void storePropertyFor(String application, String name, String value) {
        }

        @Override
        public TimeZone getTimeZone() {
            return null;
        }
    }

    @Exclude
    public static class Holder {
        public Participant value;

        public Holder() {
        }

        public Holder(Participant participant) {
            this.value = participant;
        }
    }
}

