/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.FileTypeMap;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeUtility;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Method;
import oracle.bpm.components.ByteArrayDataSource;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;

@Component(module="Fuego.Net")
public class MailAttachment
implements Serializable,
DynamicObject.Dynamizable {
    private String contentType;
    private SerializableAttachment data;
    private transient BodyPart mbp;
    static final long serialVersionUID = -1755051126170979056L;
    static final long serialCheck = 2173846833068341761L;

    @Exclude
    public MailAttachment(BodyPart mimebp) {
        this.mbp = mimebp;
        try {
            this.contentType = this.mbp.getContentType();
        }
        catch (MessagingException e) {
            throw new RuntimeExceptionShell(e);
        }
    }

    public MailAttachment(String fileName) {
        this(fileName, null);
    }

    public MailAttachment(String fileName, final String contentType) {
        FileDataSource fds = new FileDataSource(fileName);
        if (contentType != null) {
            fds.setFileTypeMap(new FileTypeMap(){

                public String getContentType(File file) {
                    return contentType;
                }

                public String getContentType(String s) {
                    return contentType;
                }
            });
        }
        DataHandler dh = new DataHandler((DataSource)fds);
        this.mbp = new MimeBodyPart();
        this.setDataHandler(dh);
        this.contentType = contentType;
        this.assignFileName(fds.getName());
    }

    public MailAttachment(byte[] source, String fileName) throws IOException {
        this(source, "application/octet-stream", fileName);
    }

    @Exclude
    public MailAttachment(byte[] source, String type, String fileName) throws IOException {
        this.createMimeBodyPart(source, type, fileName);
    }

    @Method(result="contenttype")
    public String getContentType() {
        String result = this.contentType;
        if (this.contentType == null) {
            result = "text/plain";
        }
        return result;
    }

    public byte[] getData() {
        byte[] data = null;
        try {
            if (this.mbp != null) {
                int size = this.mbp.getInputStream().available();
                if (size < 0) {
                    return null;
                }
                data = new byte[size];
                this.mbp.getInputStream().read(data);
            }
        }
        catch (MessagingException me) {
            if (Log.isDebugging()) {
                Log.logDebug(me);
            }
            data = null;
        }
        catch (IOException ioe) {
            if (Log.isDebugging()) {
                Log.logDebug(ioe);
            }
            data = null;
        }
        return data;
    }

    @Exclude
    public BodyPart getMimeBodyPart() {
        return this.mbp;
    }

    public String getName() {
        String fileName = null;
        try {
            fileName = this.mbp.getFileName();
            fileName = MimeUtility.decodeText((String)fileName);
        }
        catch (UnsupportedEncodingException e) {
            Log.logWarning(LibMsg.FILE_NAME_UNSUPPORTED_ENCODING);
        }
        catch (MessagingException e) {
            fileName = "";
        }
        return fileName;
    }

    private static Object readDynamicObject(DynamicObject dynamicObject) {
        try {
            byte[] source = (byte[])dynamicObject.getField("source").objectValue();
            String mimeType = dynamicObject.getField("mimeType").toString();
            String fileName = dynamicObject.getField("fileName").toString();
            return new MailAttachment(source, mimeType, fileName);
        }
        catch (IOException e) {
            throw new RuntimeExceptionShell(e);
        }
    }

    private void createMimeBodyPart(byte[] source, String contentType, String fileName) {
        ByteArrayDataSource dataSource = new ByteArrayDataSource(source, contentType);
        DataHandler dataHandler = new DataHandler((DataSource)dataSource);
        this.mbp = new MimeBodyPart();
        this.setDataHandler(dataHandler);
        this.contentType = contentType;
        if (fileName != null) {
            this.assignFileName(fileName);
        } else {
            this.assignFileName("NoName");
        }
    }

    private void assignFileName(String fileName) {
        try {
            this.mbp.setFileName(MimeUtility.encodeText((String)fileName, (String)Literals.DEFAULT_ENCODING, null));
        }
        catch (MessagingException e) {
            throw new RuntimeExceptionShell(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeExceptionShell(e);
        }
    }

    private void setDataHandler(DataHandler dataHandler) {
        try {
            this.mbp.setDataHandler(dataHandler);
        }
        catch (MessagingException e) {
            throw new RuntimeExceptionShell(e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, MessagingException {
        in.defaultReadObject();
        this.createMimeBodyPart(this.data.source, this.data.mimeType, this.data.fileName);
    }

    private DynamicObject writeDynamicObject() {
        DynamicObject dynamicObject = DynamicObject.create();
        dynamicObject.setField("fileName", this.getName());
        dynamicObject.setField("mimeType", this.getContentType());
        dynamicObject.setField("source", this.getData());
        return dynamicObject;
    }

    private void writeObject(ObjectOutputStream out) throws IOException, MessagingException {
        this.data = this.data == null ? new SerializableAttachment(this.getData(), this.getContentType(), this.getName()) : this.data;
        out.defaultWriteObject();
    }

    private static class SerializableAttachment
    implements Serializable {
        String fileName;
        String mimeType;
        byte[] source;
        static final long serialVersionUID = 665458396307929979L;
        static final long serialCheck = -8178735747454460355L;

        SerializableAttachment(byte[] source, String mimeType, String fileName) {
            this.source = source;
            this.mimeType = mimeType;
            this.fileName = fileName;
        }
    }
}

