/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.lang.reflect.Method;
import oracle.bpm.components.FuegoParameterDescriptor;

public class FuegoMethodDescriptor
extends MethodDescriptor {
    protected String template_d;
    private int current = 0;
    private Method method_d;
    private ParameterDescriptor[] params_d;
    public static String TEMPLATE_TAG = "\n@template ";

    public FuegoMethodDescriptor(Method method) {
        super(method, new ParameterDescriptor[method.getParameterTypes().length]);
        this.method_d = method;
        this.params_d = super.getParameterDescriptors();
    }

    @Override
    public ParameterDescriptor[] getParameterDescriptors() {
        return this.params_d;
    }

    public void setTemplate(String template) {
        this.template_d = template;
        String description = this.getShortDescription();
        if (description != null) {
            int index = description.lastIndexOf(TEMPLATE_TAG);
            if (index != -1) {
                description = description.substring(0, index);
            }
        } else {
            description = "";
        }
        this.setShortDescription(description + TEMPLATE_TAG + template);
    }

    public String getTemplate() {
        return this.template_d;
    }

    public FuegoParameterDescriptor addParameter(String name, String descrip) {
        assert (this.method_d.getParameterTypes().length > this.current);
        FuegoParameterDescriptor param = new FuegoParameterDescriptor();
        param.setName(name);
        param.setShortDescription(descrip);
        this.params_d[this.current++] = param;
        return param;
    }

    public void addParameter(ParameterDescriptor descrip) {
        assert (this.method_d.getParameterTypes().length > this.current);
        this.params_d[this.current++] = descrip;
    }

    public void addParameters(ParameterDescriptor[] descrips) {
        int length;
        int n = length = descrips != null ? descrips.length : 0;
        assert (length == this.method_d.getParameterTypes().length);
        if (descrips != null) {
            for (int i = 0; i < length; ++i) {
                this.addParameter(descrips[i]);
            }
        }
    }

    @Override
    public String toString() {
        String params = "";
        ParameterDescriptor[] descrips = this.getParameterDescriptors();
        int length = descrips.length;
        for (int i = 0; i < length; ++i) {
            params = params + descrips[i].getName();
            if (i + 1 >= length) continue;
            params = params + ", ";
        }
        return "FuegoMethodDescriptor[" + this.method_d.getName() + "(" + params + ")]";
    }
}

