/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import oracle.bpm.io.StreamUtils;

public class ByteArrayDataSource
implements DataSource {
    private byte[] data;
    private String type;

    public ByteArrayDataSource(InputStream is, String type) {
        this.type = type;
        try {
            this.data = StreamUtils.readBytes(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ByteArrayDataSource(byte[] data, String type) {
        this.data = data;
        this.type = type;
    }

    public String getContentType() {
        return this.type;
    }

    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("no data");
        }
        return new ByteArrayInputStream(this.data);
    }

    public String getName() {
        return "dummy";
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("cannot do this");
    }
}

