/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import fuego.papi.AttachmentInterface;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.components.Activity;
import oracle.bpm.components.AttachmentVersion;
import oracle.bpm.components.ComponentRuntimeException;
import oracle.bpm.components.InstanceComponent;
import oracle.bpm.components.Participant;
import oracle.bpm.components.ProcessBeanInterface;
import oracle.bpm.components.ProcessInstance;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Time;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.util.ExecutionContext;
import oracle.bpm.util.ExecutionContextAccessor;

@Component(module="Fuego.Lib")
public class Attachment
implements Serializable {
    private transient AttachmentInterface interface_d = null;
    private String uid;
    static final long serialCheck = 1913111175498733454L;
    static final long serialVersionUID = 7231464275556690822L;

    @Hidden
    public Attachment() {
    }

    @Exclude
    public Attachment(AttachmentInterface attachment) {
        this.interface_d = attachment;
        this.initMembers(attachment);
    }

    public static void create(byte[] contents, String name, String description) throws ComponentExecutionException {
        Attachment.create(contents, name, description, "");
    }

    public static void create(byte[] contents, String name, String description, String remarks) throws ComponentExecutionException {
        ProcessInstance instance = ProcessInstance.getCurrent();
        Attachment.create(instance, contents, name, description, remarks);
    }

    public static void create(byte[] contents, String contentType, String name, String description, String remarks) throws ComponentExecutionException {
        ProcessInstance instance = ProcessInstance.getCurrent();
        Participant participant = instance.getParticipant();
        Attachment.create(instance, contents, name, description, remarks, contentType, participant.getId(), participant.getName());
    }

    public static void create(byte[] contents, String contentType, String name, String description, String remarks, Participant participant) throws ComponentExecutionException {
        ProcessInstance instance = ProcessInstance.getCurrent();
        Attachment.create(instance, contents, name, description, remarks, contentType, participant.getId(), participant.getName());
    }

    @Hidden
    public static void create(InstanceComponent instance, byte[] contents, String name, String description) throws ComponentExecutionException {
        Attachment.create(instance, contents, name, description, "");
    }

    @Hidden
    public static void create(InstanceComponent instance, byte[] contents, String name, String description, String remarks) throws ComponentExecutionException {
        if (name == null) {
            throw new RuntimeException("Null Attachment Name");
        }
        Activity a = ProcessInstance.getCurrent().getActivity();
        Attachment.validateNotInGlobal(a);
        Participant participant = ProcessInstance.getCurrent().getParticipant();
        ProcessInstance.getCurrent().getBean().createComponentAttachment(instance.getId().getNumber(), contents, name, description, remarks, participant.getId(), participant.getName());
    }

    @Hidden
    public static void create(InstanceComponent instance, byte[] contents, String name, String description, String remarks, String contentType, String participantId, String participantName) throws ComponentExecutionException {
        if (name == null) {
            throw new RuntimeException("Null Attachment Name");
        }
        Activity a = ProcessInstance.getCurrent().getActivity();
        Attachment.validateNotInGlobal(a);
        ProcessInstance.getCurrent().getBean().createComponentAttachment(instance.getId().getNumber(), contents, contentType, name, description, remarks, participantId, participantName);
    }

    @Hidden
    public static void createWithContentType(InstanceComponent instance, byte[] contents, String contentType, String name, String description) throws ComponentExecutionException {
        Attachment.createWithContentType(instance, contents, contentType, name, description, "");
    }

    @Hidden
    public static void createWithContentType(InstanceComponent instance, byte[] contents, String contentType, String name, String description, String remarks) throws ComponentExecutionException {
        if (name == null) {
            throw new RuntimeException("Null Attachment Name");
        }
        Activity a = ProcessInstance.getCurrent().getActivity();
        Attachment.validateNotInGlobal(a);
        Participant participant = ProcessInstance.getCurrent().getParticipant();
        ProcessInstance.getCurrent().getBean().createComponentAttachment(instance.getId().getNumber(), contents, contentType, name, description, remarks, participant.getId(), participant.getName());
    }

    public void commit(byte[] contents, String remarks, Participant participant) throws ComponentExecutionException {
        Activity a = ProcessInstance.getCurrent().getActivity();
        Attachment.validateNotInGlobal(a);
        ProcessInstance.getCurrent().getBean().checkInComponentAttachment(this.getId(), participant.getId(), participant.getName(), remarks, contents);
    }

    public void commit(byte[] contents, String remarks) throws ComponentExecutionException {
        this.commit(contents, remarks, ProcessInstance.getCurrent().getParticipant());
    }

    public void edit() throws ComponentExecutionException {
        this.edit(ProcessInstance.getCurrent().getParticipant());
    }

    public void edit(Participant participant) throws ComponentExecutionException {
        Activity a = ProcessInstance.getCurrent().getActivity();
        Attachment.validateNotInGlobal(a);
        ProcessInstance.getCurrent().getBean().editComponentAttachment(this.getId(), participant.getId(), participant.getName());
    }

    public void release() throws ComponentExecutionException {
        this.release(ProcessInstance.getCurrent().getParticipant());
    }

    public void release(Participant participant) throws ComponentExecutionException {
        Activity a = ProcessInstance.getCurrent().getActivity();
        Attachment.validateNotInGlobal(a);
        ProcessInstance.getCurrent().getBean().releaseComponentAttachment(this.getId(), participant.getId(), participant.getName());
    }

    public long getContentSize() {
        return this.getInterface().getContentSize();
    }

    public String getContentType() {
        return this.getInterface().getContentType();
    }

    public byte[] getContents() throws ComponentExecutionException {
        ByteArrayOutputStream output = new ByteArrayOutputStream((int)this.getInterface().getContentSize());
        ProcessInstance.getCurrent().getBean().checkOutToStreamForComponent(this.getInterface().getId(), output);
        return output.toByteArray();
    }

    public Time getCreationTime() {
        return this.getInterface().getCreationTime();
    }

    public String getCreatorName() {
        return this.getInterface().getCreatorName();
    }

    public String getDescription() {
        return this.getInterface().getDescription();
    }

    public Time getEditionTime() {
        return this.getInterface().getEditionTime();
    }

    public String getEditorName() {
        return this.getInterface().getLockerName();
    }

    public String getFileName() {
        return this.getInterface().getName();
    }

    public String getId() {
        return this.getInterface().getId();
    }

    public String getRemarks() {
        return this.getInterface().getRemarks();
    }

    public int getVersion() {
        return this.getInterface().getVersion();
    }

    public AttachmentVersion[] getVersions() throws ComponentExecutionException {
        if (this.getInterface() == null) {
            return new AttachmentVersion[0];
        }
        AttachmentInterface[] versions = ProcessInstance.getCurrent().getBean().getAttachmentVersionsForComponent(this.interface_d.getId());
        AttachmentVersion[] attComp = new AttachmentVersion[versions.length];
        for (int i = 0; i < versions.length; ++i) {
            attComp[i] = new AttachmentVersion(versions[i]);
        }
        return attComp;
    }

    @Exclude
    public String toString() {
        return "Attachment(" + this.getDescription() + ", version : " + this.getVersion() + ", creation time : " + this.getCreationTime() + " )";
    }

    private static void validateNotInGlobal(Activity a) throws ComponentExecutionException {
    }

    private void initMembers(AttachmentInterface attachment) {
        this.uid = attachment.getId();
    }

    private AttachmentInterface getInterface() {
        if (this.interface_d == null) {
            if (this.isInitiated()) {
                ExecutionContext ctx = ExecutionContextAccessor.getContext();
                if (ctx == null) {
                    throw new IllegalStateException(LibMsg.MUST_RUN_SERVER_SIDE.getString());
                }
                ProcessBeanInterface processBean = (ProcessBeanInterface)ctx.getProperty("oracle.bpm.components.ProcessInstance.currentProcessBean");
                if (processBean == null) {
                    throw new RuntimeException(CoreMsg.SERVER_METHOD_INSIDE_CLIENT.toString());
                }
                try {
                    Attachment component = processBean.getInstanceAttachmentComponent(this.uid);
                    this.interface_d = component.getInterface();
                }
                catch (ComponentExecutionException e) {
                    throw new ComponentRuntimeException(e.getKey(), (Throwable)e);
                }
                if (this.interface_d == null) {
                    throw new IllegalStateException(LibMsg.ATTACHMENT_ILLEGAL_STATE.getString());
                }
                this.initMembers(this.interface_d);
            } else {
                throw new IllegalStateException(LibMsg.ATTACHMENT_ILLEGAL_STATE.getString());
            }
        }
        return this.interface_d;
    }

    private boolean isInitiated() {
        return this.uid != null;
    }
}

