/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

import oracle.bpm.component.ExecutionThread;
import oracle.bpm.component.FullQueueException;
import oracle.bpm.component.QueueInfo;
import oracle.bpm.component.Request;
import oracle.bpm.log.Log;
import oracle.bpm.util.LifecycleLock;
import oracle.bpm.util.ObjectWatch;
import oracle.bpm.util.Rendezvous;

class RequestDispatcher {
    private long[] birth;
    private LifecycleLock control;
    private DispatcherThread dispatcher;
    private int head;
    private long latency;
    private Request[] queue;
    private final Object queueLock = new Object();
    private volatile boolean running;
    private Rendezvous shutdownComplete;
    private int tail;

    RequestDispatcher(int size, long latency) {
        this.latency = latency;
        this.queue = new Request[size + 1];
        this.birth = new long[size + 1];
        this.dispatcher = new DispatcherThread();
        this.control = new LifecycleLock();
        this.shutdownComplete = new Rendezvous(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void configure(int size, long latency) {
        Object object = this.queueLock;
        synchronized (object) {
            int used;
            this.latency = latency;
            int length = size + 1;
            if (length == this.queue.length) {
                return;
            }
            int n = used = this.tail <= this.head ? this.head - this.tail : this.head + (this.queue.length - this.tail);
            if (size < used) {
                size = used;
                length = size + 1;
            }
            Request[] tmpQ = new Request[length];
            long[] tmpBirth = new long[length];
            if (this.tail <= this.head) {
                System.arraycopy(this.queue, this.tail, tmpQ, 0, used);
                System.arraycopy(this.birth, this.tail, tmpBirth, 0, used);
                this.tail = 0;
                this.head = used;
            } else {
                int trailing = this.queue.length - this.tail;
                int t = length - trailing;
                System.arraycopy(this.queue, 0, tmpQ, 0, this.head);
                System.arraycopy(this.queue, this.tail, tmpQ, t, trailing);
                System.arraycopy(this.birth, 0, tmpBirth, 0, this.head);
                System.arraycopy(this.birth, this.tail, tmpBirth, t, trailing);
                this.tail = t;
            }
            this.queue = tmpQ;
            this.birth = tmpBirth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QueueInfo createQueueInfo() {
        long latency;
        long median;
        long youngest;
        long oldest;
        int used;
        int l;
        Object object = this.queueLock;
        synchronized (object) {
            l = this.queue.length;
            int h = this.head;
            int t = this.tail;
            used = t <= h ? h - t : h + (l - t);
            oldest = this.birth[t];
            youngest = this.birth[h == 0 ? l - 1 : h - 1];
            median = this.birth[(t + (used >> 1)) % l];
            latency = this.latency;
        }
        int size = l - 1;
        return new QueueInfo(size, used, oldest, youngest, median, latency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(Request req) throws FullQueueException {
        this.control.beginWork();
        try {
            assert (req.getResponse() != null) : "Response object cannot be null";
            Object object = this.queueLock;
            synchronized (object) {
                if (this.tail == 0 && this.head == this.queue.length - 1 || this.tail != 0 && this.head == this.tail - 1) {
                    throw new FullQueueException(this.queue.length - 1);
                }
                this.queue[this.head] = req;
                this.birth[this.head] = System.currentTimeMillis();
                this.head = (this.head + 1) % this.queue.length;
                this.queueLock.notify();
            }
        }
        finally {
            this.control.endWork();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        this.control.beginStartup();
        try {
            this.running = true;
            this.dispatcher.start();
            ObjectWatch.register("Execution Framework", "queue", "Request Queue", this);
        }
        finally {
            this.control.endStartup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        this.control.beginShutdown();
        try {
            this.running = false;
            Object object = this.queueLock;
            synchronized (object) {
                this.queueLock.notifyAll();
            }
            try {
                this.shutdownComplete.meet();
            }
            catch (InterruptedException e) {
                Log.logSevere(e);
            }
        }
        finally {
            this.control.endShutdown();
        }
    }

    private class DispatcherThread
    extends Thread {
        DispatcherThread() {
            super("Request Dispatcher Thread");
            this.setDaemon(true);
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: while (RequestDispatcher.this.running) {
                long birthdate;
                Request item;
                Object object = RequestDispatcher.this.queueLock;
                synchronized (object) {
                    while (RequestDispatcher.this.head == RequestDispatcher.this.tail) {
                        try {
                            RequestDispatcher.this.queueLock.wait();
                        }
                        catch (InterruptedException e) {
                            Log.logSevere(e);
                        }
                        if (RequestDispatcher.this.running) continue;
                        break block7;
                    }
                    item = RequestDispatcher.this.queue[RequestDispatcher.this.tail];
                    birthdate = RequestDispatcher.this.birth[RequestDispatcher.this.tail];
                    ((RequestDispatcher)RequestDispatcher.this).queue[((RequestDispatcher)RequestDispatcher.this).tail] = null;
                    ((RequestDispatcher)RequestDispatcher.this).birth[((RequestDispatcher)RequestDispatcher.this).tail] = 0L;
                    RequestDispatcher.this.tail = (RequestDispatcher.this.tail + 1) % RequestDispatcher.this.queue.length;
                }
                long now = System.currentTimeMillis();
                long age = now - birthdate;
                long ttl = RequestDispatcher.this.latency - age;
                if (ttl > 0L && ExecutionThread.processRequest(item, ttl)) continue;
                item.getResponse().operationTimeout(RequestDispatcher.this.latency);
            }
            try {
                RequestDispatcher.this.shutdownComplete.meet();
            }
            catch (InterruptedException e) {
                Log.logSevere(e);
            }
        }
    }
}

