/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DefaultDirectoryConfiguration;
import fuego.directory.DirectoryLDAPConfigurationLoader;
import java.io.InputStream;
import oracle.bpm.configuration.ConfigurationLoader;
import oracle.bpm.configuration.ConfigurationSet;
import oracle.bpm.configuration.util.ValidationUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DirectoryConfigurationLoader
extends ConfigurationLoader {
    private String characters = "";
    private DefaultDirectoryConfiguration configuration = DefaultDirectoryConfiguration.createDirectoryConfiguration();
    private String currentPreset;
    private boolean insidePresetsContext = false;
    private DirectoryLDAPConfigurationLoader ldapConfiurationLoader;
    private boolean parsingConfiguration;

    DirectoryConfigurationLoader(InputStream is) {
        super(ConfigurationSet.create(), is, false);
        this.configuration.setConnectorsConfigurations(this.getContainer());
        this.ldapConfiurationLoader = new DirectoryLDAPConfigurationLoader();
    }

    public DefaultDirectoryConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.parsingConfiguration) {
            super.endElement(uri, localName, qName);
        }
        if ("configuration".equalsIgnoreCase(qName)) {
            this.parsingConfiguration = false;
        } else if ("id".equalsIgnoreCase(qName)) {
            this.configuration.setId(this.characters);
        } else if ("description".equalsIgnoreCase(qName)) {
            this.configuration.setDescription(this.characters);
        } else if ("admin".equalsIgnoreCase(qName)) {
            this.configuration.setAdmin(this.characters);
        } else if ("adminPass".equalsIgnoreCase(qName)) {
            this.configuration.setAdminPassword(ValidationUtilities.unscrambleText(this.characters));
        } else if ("preset".equalsIgnoreCase(qName)) {
            this.currentPreset = null;
        }
        if ("presets".equalsIgnoreCase(qName)) {
            this.insidePresetsContext = false;
        }
        this.ldapConfiurationLoader.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters = this.characters + new String(ch, start, length);
        this.ldapConfiurationLoader.characters(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("configuration".equalsIgnoreCase(qName)) {
            this.parsingConfiguration = true;
        }
        if (this.parsingConfiguration) {
            super.startElement(uri, localName, qName, attributes);
        } else if ("presets".equalsIgnoreCase(qName)) {
            this.insidePresetsContext = true;
        } else if ("preset".equalsIgnoreCase(qName)) {
            if (!this.insidePresetsContext) {
                throw new SAXException("'preset' tag must be contained by a 'presets' tag.");
            }
            this.currentPreset = attributes.getValue("name");
        } else if ("property".equalsIgnoreCase(qName)) {
            this.configuration.setPresetValue(this.currentPreset, attributes.getValue("name"), attributes.getValue("value"));
        }
        this.characters = "";
        this.ldapConfiurationLoader.startElement(uri, localName, qName, attributes);
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.ldapConfiurationLoader.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        this.ldapConfiurationLoader.endDocument();
        this.configuration.setLdapConfiguration(this.ldapConfiurationLoader.buildLdapConfiguration());
    }
}

