/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.importer.wfmc.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import oracle.bpm.project.importer.wfmc.parser.Activities;
import oracle.bpm.project.importer.wfmc.parser.Activity;
import oracle.bpm.project.importer.wfmc.parser.ActivitySet;
import oracle.bpm.project.importer.wfmc.parser.Application;
import oracle.bpm.project.importer.wfmc.parser.DataField;
import oracle.bpm.project.importer.wfmc.parser.ElementType;
import oracle.bpm.project.importer.wfmc.parser.FormalParameter;
import oracle.bpm.project.importer.wfmc.parser.Transition;
import oracle.bpm.project.importer.wfmc.parser.Transitions;
import oracle.bpm.project.importer.wfmc.parser.XPDLElement;

public class WorkflowProcess
extends XPDLElement {
    private Activities activities;
    private XPDLElement activitySets;
    private XPDLElement applications;
    private XPDLElement dataFields;
    private XPDLElement parameters;
    private XPDLElement transitions;
    private static final String ID = "Id";
    private static final String NAME = "Name";

    public WorkflowProcess() {
        this.setTagName("WorkflowProcess");
    }

    public Activity[] getActivities() {
        if (this.activities == null) {
            this.activities = (Activities)this.findChildByClass(Activities.class);
        }
        return this.activities.getActivities();
    }

    public ActivitySet[] getActivitySets() {
        if (this.activitySets == null) {
            this.activitySets = (XPDLElement)this.findChildByName("ActivitySets");
        }
        if (this.activitySets != null) {
            return (ActivitySet[])this.activitySets.findChildrenByClass(ActivitySet.class);
        }
        return new ActivitySet[0];
    }

    public Application[] getApplications() {
        if (this.applications == null) {
            this.applications = (XPDLElement)this.findChildByName("Applications");
        }
        if (this.applications != null) {
            return (Application[])this.applications.findChildrenByClass(Application.class);
        }
        return new Application[0];
    }

    public DataField[] getDataFields() {
        if (this.dataFields == null) {
            this.dataFields = (XPDLElement)this.findChildByName("DataFields");
        }
        if (this.dataFields != null) {
            return (DataField[])this.dataFields.findChildrenByClass(DataField.class);
        }
        return new DataField[0];
    }

    @Override
    public String getId() {
        return this.getAttribute(ID);
    }

    public FormalParameter[] getInParameters() {
        FormalParameter[] parameters;
        ArrayList<FormalParameter> l = new ArrayList<FormalParameter>();
        this.loadParameters();
        for (FormalParameter parameter : parameters = this.getParameters()) {
            if (!parameter.isIn()) continue;
            l.add(parameter);
        }
        parameters = new FormalParameter[l.size()];
        l.toArray(parameters);
        return parameters;
    }

    public String getName() {
        return this.getAttribute(NAME);
    }

    public FormalParameter[] getOutParameters() {
        FormalParameter[] parameters;
        ArrayList<FormalParameter> l = new ArrayList<FormalParameter>();
        this.loadParameters();
        for (FormalParameter parameter : parameters = this.getParameters()) {
            if (!parameter.isOut()) continue;
            l.add(parameter);
        }
        parameters = new FormalParameter[l.size()];
        l.toArray(parameters);
        return parameters;
    }

    public FormalParameter[] getParameters() {
        this.loadParameters();
        if (this.parameters != null) {
            return (FormalParameter[])this.parameters.findChildrenByClass(FormalParameter.class);
        }
        return new FormalParameter[0];
    }

    public String[] getParticipantReferences() {
        ActivitySet[] activitySets;
        HashSet<String> set = new HashSet<String>();
        for (ActivitySet activitySet : activitySets = this.getActivitySets()) {
            Activity[] activities = activitySet.getActivities();
            this.buildParticipantSet(activities, set);
        }
        Activity[] activities = this.getActivities();
        this.buildParticipantSet(activities, set);
        String[] strings = new String[set.size()];
        set.toArray(strings);
        return strings;
    }

    public Transition[] getTransitions() {
        if (this.transitions == null) {
            this.transitions = (XPDLElement)this.findChildByClass(Transitions.class);
        }
        if (this.transitions != null) {
            return (Transition[])this.transitions.findChildrenByClass(Transition.class);
        }
        return new Transition[0];
    }

    private void buildParticipantSet(Activity[] activities, Set<String> set) {
        for (Activity activity : activities) {
            String participant = activity.getParticipant();
            if (participant == null || participant.length() == 0 || set.contains(participant)) continue;
            set.add(participant);
        }
    }

    private void loadParameters() {
        if (this.parameters == null) {
            this.parameters = (XPDLElement)this.findChildByName(ElementType.findByType(18));
        }
    }
}

