/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.debug.components;

import fuego.directory.DirBusinessParameter;
import fuego.directory.DirOrganizationalUnit;
import fuego.directory.DirectoryException;
import fuego.directory.DirectoryRuntimeException;
import fuego.directory.DirectorySession;
import fuego.directory.provider.DirectorySessionImpl;
import fuego.directory.util.DirectoryEnvironment;
import fuego.prefs.engine.EngineType;
import fuego.prefs.engine.standalone.StandaloneEnginePreferences;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.collections.Sequence;
import oracle.bpm.compiler.debug.components.ParticipantDebug;
import oracle.bpm.compiler.debug.components.RoleDebug;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.components.BusinessParameterDebug;
import oracle.bpm.components.ComponentRuntimeException;
import oracle.bpm.components.ParticipantInterface;
import oracle.bpm.components.ProcessInterface;
import oracle.bpm.components.RoleInterface;
import oracle.bpm.components.ServerInterface;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Literals;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.util.Base64;

public class ServerDebug
implements ServerInterface {
    private Project project;
    private Map<String, Map<Object, Object>> propertiesByApplication = new HashMap<String, Map<Object, Object>>();
    private DirectorySession session;

    public ServerDebug(DirectorySession session) {
        this.session = session;
        assert (session instanceof DirectorySessionImpl) : "Session is not instance of DirectorySessionImpl," + session.getClass();
        this.project = (Project)((DirectorySessionImpl)session).getSessionProperties().get("fuego-project");
        assert (this.project != null) : "Cannot find project property in session";
    }

    @Override
    public String getAdministratorMail() {
        return this.getEnginePreferences().getNetworking().getAdministratorMail().getValue();
    }

    @Override
    public int getAutomaticItemsCount() {
        return 0;
    }

    @Override
    public int getAutomaticItemsQueueSize() {
        return 0;
    }

    @Override
    public int getAutomaticThreadsPoolSize() {
        return this.getEnginePreferences().getExecution().getAutomaticExecutionThreadsPoolSize().getValue();
    }

    @Override
    public Object getBusinessParameterValue(String organizationalUnit, String businessParameterName) {
        DirBusinessParameter businessParameter;
        try {
            businessParameter = DirBusinessParameter.fetch((DirectorySession)this.getDirectorySession(), (String)businessParameterName);
        }
        catch (DirectoryException e) {
            throw new ComponentRuntimeException(LibMsg.DIRECTORY_EXCEPTION, (Throwable)e);
        }
        if (businessParameter == null) {
            throw new ComponentRuntimeException(LibMsg.BUSINESS_PARAMETER_NOT_FOUND(businessParameterName));
        }
        BusinessParameterDebug businessParameterDebug = new BusinessParameterDebug(businessParameter);
        return businessParameterDebug.getValue(organizationalUnit);
    }

    @Override
    public Object getBusinessParameterValue(String businessParameterName) {
        return this.getBusinessParameterValue(DirOrganizationalUnit.getRootId(), businessParameterName);
    }

    @Override
    public DirectorySession getDirectorySession() {
        return this.session;
    }

    @Override
    public String getDirectoryURL() {
        return this.session.getDirectoryId();
    }

    @Override
    public int getExpiredAutomaticItemsCount() {
        return 0;
    }

    @Override
    public String getHomeDir() {
        return this.getEnginePreferences().getLocations()[0].getHomeDir().getValue();
    }

    @Override
    public String getHost() {
        return this.getEnginePreferences().getLocations()[0].getHost().getValue();
    }

    @Override
    public int getInstanceCacheSize() {
        return this.getEnginePreferences().getMemory().getInstancesCacheSize().getValue();
    }

    @Override
    public int getJvmHeapMax() {
        return this.getEnginePreferences().getMemory().getMaxJvmHeapSize().getValue();
    }

    @Override
    public String getMailServerName() {
        return this.getEnginePreferences().getNetworking().getMailServerName().getValue();
    }

    @Override
    public int getMaximumBPMethodsTimeout() {
        return this.getEnginePreferences().getTimeouts().getMaxMethodTimeout().getValue();
    }

    @Override
    public String getName() {
        return this.getEnginePreferences().getServerId().getValue();
    }

    @Override
    public Interval getRetryInterval() {
        return Interval.valueOf(this.getEnginePreferences().getExecution().getRetryInterval().getValue() + "s");
    }

    @Override
    public int getRetryTimes() {
        return this.getEnginePreferences().getExecution().getRetryTimes().getValue();
    }

    @Override
    public String getWebBUIServer() {
        return this.getEnginePreferences().getNetworking().getPortalUrl().getValue();
    }

    @Override
    public ParticipantInterface getParticipantInterface(String name) {
        Participant participant = this.project.getOrganization().findParticipant(name);
        if (participant != null) {
            return ParticipantDebug.create(participant);
        }
        return null;
    }

    @Override
    public ParticipantInterface getParticipantInterfaceByEmail(String email) {
        if (email == null) {
            return null;
        }
        Sequence participants = this.project.getOrganization().getParticipants();
        for (Participant participant : participants) {
            if (!email.equals(participant.getMail())) continue;
            return ParticipantDebug.create(participant);
        }
        return null;
    }

    @Override
    public int getPendingExpiredAutomaticItemsCount() {
        return 0;
    }

    @Override
    public RoleInterface getRoleInterface(String roleName) {
        Role role = this.project.getOrganization().findRoleById(roleName);
        if (role != null) {
            return new RoleDebug(role);
        }
        return null;
    }

    @Override
    public long getWebServiceSessionTimeout() {
        int secs = this.getEnginePreferences().getTimeouts().getMaxWebServiceSessionTimeout().getValue();
        return secs * 1000;
    }

    @Override
    public ProcessInterface findProcessInCache(String id) {
        return null;
    }

    @Override
    public String retrieveEncryptedPropertyFor(String application, String name, String key) throws DirectoryException {
        String encryptedValue = (String)this.retrievePropertyInternal(application, name);
        String value = DirectoryEnvironment.encryptValue(key, Base64.decode(encryptedValue));
        if (!value.startsWith(key)) {
            if (Log.isDebugging()) {
                Log.logDebug("Invalid encryption key " + key + " for value " + value);
            }
            return null;
        }
        return value.substring(key.length());
    }

    @Override
    public Object retrieveObjectPropertyFor(String application, String name) throws DirectoryException {
        return this.retrievePropertyInternal(application, name);
    }

    @Override
    public String retrievePropertyFor(String application, String name) throws DirectoryException {
        return (String)this.retrievePropertyInternal(application, name);
    }

    @Override
    public void storeEncryptedPropertyFor(String application, String name, String value, String key) throws DirectoryException {
        String encryptedValue = DirectoryEnvironment.encryptValue(key, key + value);
        try {
            encryptedValue = Base64.encode(encryptedValue.getBytes(Literals.DEFAULT_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw DirectoryRuntimeException.wrapException((Throwable)e);
        }
        this.storePropertyInternal(application, name, encryptedValue);
    }

    @Override
    public void storeObjectPropertyFor(String application, String name, Object value) throws Exception {
        this.storePropertyInternal(application, name, value);
    }

    @Override
    public void storePropertyFor(String application, String name, String value) throws DirectoryException {
        this.storePropertyInternal(application, name, value);
    }

    @Override
    public void updateBusinessParameter(String businessParameterName, Object value) throws DirectoryException {
        this.updateBusinessParameter(DirOrganizationalUnit.getRootId(), businessParameterName, value);
    }

    @Override
    public void updateBusinessParameter(String organizationalUnit, String businessParameterName, Object value) throws DirectoryException {
        DirBusinessParameter businessParameter;
        try {
            businessParameter = DirBusinessParameter.fetch((DirectorySession)this.getDirectorySession(), (String)businessParameterName);
        }
        catch (DirectoryException e) {
            throw new ComponentRuntimeException(LibMsg.DIRECTORY_EXCEPTION, (Throwable)e);
        }
        if (businessParameter == null) {
            throw new ComponentRuntimeException(LibMsg.BUSINESS_PARAMETER_NOT_FOUND(businessParameterName));
        }
        BusinessParameterDebug businessParameterDebug = new BusinessParameterDebug(businessParameter);
        businessParameterDebug.setValue(organizationalUnit, value);
    }

    @Override
    @Exclude
    public InputStream getRuntimeResource(String path) throws IOException {
        return null;
    }

    @Override
    @Exclude
    public EngineType getEngineType() {
        return EngineType.STUDIO;
    }

    private StandaloneEnginePreferences getEnginePreferences() {
        return this.project.getDeployment().getEngine().getEnginePreferences();
    }

    private Object retrievePropertyInternal(String application, String name) {
        Map<Object, Object> propertiesByName = this.propertiesByApplication.get(application);
        if (propertiesByName != null) {
            return propertiesByName.get(name);
        }
        return null;
    }

    private void storePropertyInternal(String application, String name, Object value) {
        Map<Object, Object> propertiesByName = this.propertiesByApplication.get(application);
        if (propertiesByName == null) {
            propertiesByName = new HashMap<Object, Object>();
            this.propertiesByApplication.put(application, propertiesByName);
        }
        propertiesByName.put(name, value);
    }
}

