
$ontext
         Benders decomposition applied to a two-stage
         stochastic linear programming problem.
         Erwin Kalvelagen, januari 2003
$offtext

sets
         i 'factories' /f1*f3/
         j 'distribution centers' /d1*d5/
         s 'scenarios' /lo,mid,hi/
;

parameter capacity(i) /f1 500, f2 450, f3 650/;

table demand(j,s) 'possible outcomes for demand'
             lo mid  hi
         d1 150 160 170
         d2 100 120 135
         d3 250 270 300
         d4 300 325 350
         d5 600 700 800
;

parameter prob(s) 'probabilities' /
         lo 0.25
         mid 0.5
         hi 0.25
         /;

table transcost(i,j) 'unit transportation cost'
              d1   d2   d3   d4   d5
         f1 2.49 5.21 3.76 4.85 2.07
         f2 1.46 2.54 1.83 1.86 4.76
         f3 3.26 3.08 2.60 3.76 4.45
;

scalar prodcost 'unit production cost' /14/;
scalar price 'sales price' /24/;
scalar wastecost 'cost of removal of overstocked products' /4/;



*-----------------------------------------------------------------------
* Form the Benders master problem
*-----------------------------------------------------------------------

set
         iter 'max Benders iterations' /iter1*iter25/
         dyniter(iter) 'dynamic subset'
;

positive variables
         ship(i,j) 'shipments'
         product(i) 'production'
         slackproduct(i) 'slack'
         received(j) 'quantity sent to market'
;


free variables
         zmaster 'objective variable of master problem'
         theta 'extra term in master obj'
;

equations
         masterobj 'master objective function'
         production(i) 'calculate production in each factory'
         receive(j) 'calculate quantity to be send to markets'
         prodcap(i) 'production capacity'
         optcut(iter) 'Benders optimality cuts'
;



parameter
         cutconst(iter) 'constants in optimality cuts'
         cutcoeff(iter,j) 'coefficients in optimality cuts'
;
masterobj..      zmaster =e= sum((i,j), transcost(i,j)*ship(i,j))
                             + sum(i,prodcost*product(i)) + theta;

receive(j)..     received(j) =e= sum(i, ship(i,j));

production(i)..  product(i) =e= sum(j, ship(i,j));

prodcap(i)..     product(i) + slackproduct(i) =e= capacity(i);

optcut(dyniter).. theta =g= cutconst(dyniter) +
                            sum(j, cutcoeff(dyniter,j)*received(j));


model masterproblem /masterobj, receive, production, prodcap, optcut/;



*-------------------------------------------------------------------
* Dual subproblem
*-------------------------------------------------------------------
variables
         zsub          'dual objective funcition'
         pi_selling(j) 'dual of equation selling'
         pi_selmax(j) 'dual of equation selmax'
;

equations
         dualobj
         dualcon(j)
;

parameter demnd(j) 'demand';

dualobj..        zsub =e= sum(j, received.l(j)*pi_selling(j)) + sum(j, demnd(j)*pi_selmax(j));

dualcon(j)..     pi_selling(j) + pi_selmax(j) =l= -price;

pi_selling.up(j) = wastecost;
pi_selmax.up(j) = 0;

model dualsubproblem /dualobj,dualcon/;

*-------------------------------------------------------------------
* solver options
*-------------------------------------------------------------------


option limrow = 0;
option limcol = 0;
dualsubproblem.solprint = 2;
masterproblem.solprint = 2;
dualsubproblem.solvelink = 2;
masterproblem.solvelink = 2;


*-------------------------------------------------------------------
* Benders algorithm
*-------------------------------------------------------------------
*
* step 1: solve master without cuts
*

display  "-----------------------------------------------------------------",
         "Master without cuts",
         "-----------------------------------------------------------------";

*Comienzo sin planos cortantes
*y con la variable theta en 0

dyniter(iter) = NO;
cutconst(iter) = 0;
cutcoeff(iter,j) = 0;
theta.fx = 0;

solve masterproblem minimizing zmaster using lp;

display zmaster.l;

*
* repair bounds
*

theta.lo = -INF;
theta.up = INF;

scalar lowerbound /-INF/;
scalar upperbound /INF/;

*En este parmetro voy a guardar los valores de la funcin objetivo de
*cada subproblema
parameter objsub(s);

*En este parmetro voy a guardar el valor de la funcin objetivo
*del problema maestro.
scalar objmaster;

objmaster = zmaster.l;

*Defino el nmero de iteracin del algoritmo
scalar iteration;
scalar done /0/;

loop(iter$(not done),
*Actualizo el nmero de Iteracin
         iteration = ord(iter);
         display "-----------------------------------------------------------------",
                 iteration,
                 "-----------------------------------------------------------------";

*
* solve subproblems
*

*Agrego un elemento al conjunto de iteraciones

         dyniter(iter) = yes;

*Para cada subproblema, resuelvo el problema asociado, guardo el valor de la funcin objetivo,
*y calculo los parmetros del plano cortante

         dyniter(iter) = yes;
         loop(s,
                 demnd(j) = demand(j,s);
                 solve dualsubproblem maximizing zsub using lp;
                 objsub(s) = zsub.l;
                 cutconst(iter) = cutconst(iter) - prob(s)*sum(j,(-pi_selmax.l(j))*demand(j,s));
                 cutcoeff(iter,j) = cutcoeff(iter,j) - prob(s)*(-pi_selling.l(j));
         );

*Actualizo la cota superior de la funcin objetivo del problema.

         upperbound = min(upperbound, objmaster + sum(s, prob(s)*objsub(s)));


*
* convergence test
*

*Si la cota superior e inferior estn mas cercanas que un epsilon,
*el algoritmo termina.
         display lowerbound,upperbound;
         if( (upperbound-lowerbound) < 0.001*(1+abs(lowerbound)),
                 display "Converged";
                 done = 1;
         else

*
* solve masterproblem
*

*DE lo contrario se debe resolver el problema maestro, pero agregando el corte
*encontrado al resolver los subproblemas...

                 solve masterproblem minimizing zmaster using lp;
                 display ship.l;
                 lowerbound = zmaster.l;
                 objmaster = zmaster.l-theta.l;
         );
);

*CUando se sobrepasa el lmite de iteraciones, entonces se termina el algoritmo,
*y se entrega la mejor solucin encontrada.

abort$(not done) "Too many iterations";
         display "-----------------------------------------------------------------",
                 "Optimal stage one solution",
                 "-----------------------------------------------------------------",

ship.l;