
*defino los indices que voy a utilizar

Set i plantas /p1,p2/

Set j mercados /m1*m3/;

*En esta parte se definen los parmetros del problema (los parmetros dependen de
*los ndices.

Parameters

         a(i) Capacidad de la planta i
         / p1    350
           p2    600 /

         b(j) Demanda del mercado j
         / m1    325
           m2    300
           m3    275/ ;

*Para el caso en que los parmetros tengan mas de un ndice, se pueden utilizar
*las tablas.

table d(i,j) Distancia entre la planta i y el mercado j en miles de millas
                 m1      m2      m3
         p1      2.5     1.7     1.8
         p2      2.5     1.8     1.4 ;

*Defino un valor fijo que no depende de ningun ndice como un escalar

Scalar f  Costro de transporte por unidad por miles de millas /90/;

*Se definen las variables del problema. Es importante definir una variable
*que represente el valor de la funcin objetivo del problema (en este caso
*la variable z), que ser la variable que se va a minimizar.

Variables

         x(i,j)  Cantidad enviada desde la planta i al mercado j
         z       Costo total de transporte;

*Se definen los rangos de las variables

Positive variable        x;
Free variable            z;

*A continuacin se define la funcin objetivo y las restricciones del problema
*Es importante definir las restricciones con el ndice correspondiente. Por ejemplo
*en el caso de la restriccion de satisfacer la demanda, es una restriccion por
*mercado, por lo que se define en funcin de ese ndice.

Equations
         costo           define el costo total de transporte
         oferta(i)       no producir mas de la capacidad de la planta
         demanda(j)      enviar la cantidad demandada por el mercado j;

costo ..         sum((i,j), f * d(i,j) * x(i,j)) =e= z;
oferta(i) ..     sum(j, x(i,j) ) =l= a(i);
demanda(j) ..    sum(i, x(i,j) ) =e= b(j);

*Aqu se define el modelo. Si un modelo consta de todas las restricciones definidas
*anteriormente, se utiliza /all/. Si el modelo considera un subconjunto de restricciones
*es necesario listar cuales son las restricciones una por una

*En Gams, se puede definir mas de un modelo a la vez.

model transporte /costo,oferta,demanda/;

*Con el comando solve se resuelve el modelo especificado por su nombre. Ademas
*es necesario incluir el tipo de problema que es. En este caso se una lp
*por que es un problema lineal, pero si es un problema entero se debera definir
*como using mip
*Luego se le agrega la informacon de si se quiere maximizar o minimizar y el nombre
*de la variable a optimizar, en este caso z.

solve transporte using lp minimizing z;

*Podemos pedirle que nos muestre los resultados para las variables x (x.l donde
*el .l se utiliza para pedirle el valor (level), y el valor del costo reducido x.l asociado
*a esa variable ( .m por marginal)

*Notemos que si utilizamos .m para una restriccion lo que se entrega es el valor
*de la variable dual asociada a esa restriccin. Cuando en display aparezca EPS
*se entiende que el valor es epsilon, un valor muy cercano a 0. Si los resultados
*no aparecen en el display significa que son cero.

display x.l, x.m, oferta.m ;

*Cuando se corre este programa, aparece una pestaa llamada Transporte.lst
*donde se listan los parmetros, las ecuaciones, la forma de la funcin objetivo
*el valor de la funcin objetivo en el ptimo, junto con los valores de las variables
*en el ptimo, ademas de los displays que le pidamos al programa.