% Anomalia magnetica de campo total para esfera de radio R
% con su centro a profundidad h.
%
% La esfera se considera magnetizada por un campo inductor de magnitud B0,
% declinacion D e inclinacion I, a traves de una suceptibilidad
% magnetica: xemu en sistema emu o cgs.
%
% La anomalia de campo total se calcula con respecto a un campo de
% referencia diferente del campo inductor, cuya declinacion es Dr, e
% inclinacion es Ir.  Si Ir=I, Dr=D, se esta en el caso normal donde
% el campo inductor y de refenercia son iguales; esta es la situacion
% de los valores por defecto (default).
%
% Calculo se lleva a cabo en una malla de puntos en la superficie.
% 
% Como default para el campo inductor se usa el campo en Stgo. en 2009.5
% segun IGRF.
% 
help ACTesfsurf
%
clear all
%
%
B0 = input('Intensidad de campo magnetico inductor (nTesla o gammas) [24316] ?? ');
if(isempty(B0));B0=24316; end;

I = input('Inclinacion campo magnetico inductor (Grados) [-33.48] ?? ');
if(isempty(I));I=-33.48; end;

D = input('Declinacion campo magnetico inductor (Grados) [2.98] ?? ');
if(isempty(D));D=2.98; end;

Ir = input('Inclinacion campo magnetico de referencia (Grados) [-33.48] ?? ');
if(isempty(Ir));Ir=-33.48; end;

Dr = input('Declinacion campo magnetico de referencia (Grados) [2.98] ?? ');
if(isempty(Dr));Dr=2.98; end;

h = input('Profundidad centro de esfera (m) [1000] ?? ');
if(isempty(h));h=1000; end;

R = input('Radio de esfera (m) [500] ?? ');
if(isempty(R));R=500; end;

xemu = input('Suceptibilidad magnetica de esfera (Sistema emu o cgs) [0.001] ?? ');
if(isempty(xemu));xemu=0.001; end;

nh  = input('Area de calculo en terminos de profundidad de centro de esfera [4] ?? ');
if(isempty(nh));nh=4; end;

ds = input('Distancia entre puntos de malla (m) [50] ?? ');
if(isempty(ds)); ds=50; end;

%
gr2rad = pi / 180;
ax     = cos(gr2rad*I) * cos(gr2rad*D);
ay     = cos(gr2rad*I) * sin(gr2rad*D);
az     = sin(gr2rad*I);
%
bx     = cos(gr2rad*Ir) * cos(gr2rad*Dr);
by     = cos(gr2rad*Ir) * sin(gr2rad*Dr);
bz     = sin(gr2rad*Ir);
%
dotab  = ax*bx + ay*by + az*bz;
%
h2     = h^2;
c1     = xemu * B0 * 4 * pi / 3;
%
x      = -nh*h:ds:nh*h;
y      = x;
%y      = -(nh+1)*h:ds:(nh+1)*h;
nx     = length(x);
ny     = length(y);
% Calcula anomalia de campo total (act)
%
for j=1:nx,
for i=1:ny,
    r        = sqrt(x(j)^2 + y(i)^2 + h2);
    dotar    = (ax * x(j) + ay * y(i) - az * h ) / r;
    dotbr    = (bx * x(j) + by * y(i) - bz * h ) / r;
    act(i,j) = c1 * (R/r)^3 * (3 * dotar * dotbr - dotab);
end
end
%
figure;
surfc(x,y,act);
view(90,-90);
ylabel('y(m), Crece hacia el E','FontSize',12);
%surfc(x,-y,act);
%view(-90,90);
%ylabel('-y(m), Crece hacia el W','FontSize',12);
shading interp;
colormap(jet);
xlabel('x(m), Crece hacia el N','FontSize',12);
texto = sprintf('B0, I, D, Xemu, R, h =%7.0f%7.1f%7.1f%10.4f%7.1f%7.1f',B0,I,D,xemu,R,h);
title(texto,'FontSize',12);
colorbar('vert');