function[grav]=ribbon_g(x0,z0,x1,z1,x2,z2);

xtn2 = x2-x0;
xtn1 = x1-x0;
ztn2 = z2-z0;
ztn1 = z1-z0;

rtn2 = sqrt(xtn2^2 + ztn2^2);
rtn1 = sqrt(xtn1^2 + ztn1^2);

thetn2 = sign(ztn2)*pi/2;
if xtn2~=0,
   thetn2 = atan2(ztn2,xtn2);
end

thetn1 = sign(ztn1)*pi/2;
if xtn1~=0,
   thetn1 = atan2(ztn1,xtn1);
end

an   = (x2-x1)/(z2-z1+0.00001);
bn   = xtn1 - an * ztn1;

dang = thetn2 - thetn1;
if abs(dang) > pi
	dang = dang - sign(dang) * 2*pi;
end

grav = (bn/(1+an^2))*(log(rtn2/rtn1)-an*dang);