%% SOLUCIN NUMRICA DE LA ECUACIN DE MOVIMIENTO DE SISTEMA DE MLTIPLES GDL
%  Jos Luis Caroca Gaete
%  09 de Noviembre de 2010
close all, clear all, clc

%%  1. ANTECEDENTES GENERALES
m1=2;     m2=4;  m3=1;
EI=3000;  h=4;   L=3;
beta=[0.05,0.05,0.05];
Fs=200;  t=0:1/Fs:30;
Vg=10*sin(2*pi*t);  % vector fila.

%%  2. MATRIZ DE MASA Y RIGIDEZ
%   q1,q2,q3: Grados de libertad activos.
M=diag([m1+m2+m3,m3,m1]);
Kaa=[12*EI/h^3, 0, 0;
     0,  3*EI/L^3, 0;
     0,  0,  3*EI/L^3];
Kap=[6*EI/h^2;-3*EI/L^2;3*EI/L^2];
Kpp=6*EI/L+4*EI/h;
K=Kaa-Kap*inv(Kpp)*Kap';

%%  3. CARGA EFECTIVA INDUCIDA POR LA ACELERACIN BASAL
%   r : Vector de influencia.
%   P : Matriz de cargas externas (3 x length(t)).
r=[1;0;0];  P=-M*r*Vg;

%%  4. RESPUESTA DEL SISTEMA
%   Slo considera los grados de libertad activos.
%   Condiciones iniciales nulas para el desplazamiento y la velocidad.
u0=zeros(3,1);       v0=zeros(3,1);
[u,v,a]=respMGDL(M,K,beta,P,Fs,u0,v0);

%%  5. RESPUESTA TOTAL DEL SISTEMA
%   u=[q1;q2;q3] - U=[q1;q2;q3;q4]
T=[eye(3,3);-inv(Kpp)*Kap'];    U=T*u;
M=(6*EI/h^2)*U(1,:)+(2*EI/h)*U(4,:);