/* $Id: AbstractPropPanelState.java 17894 2010-01-12 21:29:01Z linus $
 *****************************************************************************
 * Copyright (c) 2009 Contributors - see below
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    tfmorris
 *****************************************************************************
 *
 * Some portions of this file was previously release using the BSD License:
 */

// Copyright (c) 1996-2007 The Regents of the University of California. All
// Rights Reserved. Permission to use, copy, modify, and distribute this
// software and its documentation without fee, and without a written
// agreement is hereby granted, provided that the above copyright notice
// and this paragraph appear in all copies.  This software program and
// documentation are copyrighted by The Regents of the University of
// California. The software program and documentation are supplied "AS
// IS", without any accompanying services from The Regents. The Regents
// does not warrant that the operation of the program will be
// uninterrupted or error-free. The end-user understands that the program
// was developed for research purposes and is advised not to rely
// exclusively on the program for any reason.  IN NO EVENT SHALL THE
// UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
// SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
// ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
// THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY
// WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
// PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
// CALIFORNIA HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,
// UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

package org.argouml.uml.ui.behavior.state_machines;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JScrollPane;

import org.argouml.application.helpers.ResourceLoaderWrapper;
import org.argouml.i18n.Translator;
import org.argouml.uml.ui.ScrollList;
import org.argouml.uml.ui.UMLMutableLinkedList;

/**
 * The abstract properties panel for a State.
 *
 */
public abstract class AbstractPropPanelState extends PropPanelStateVertex {

    private JScrollPane entryScroll;
    private JScrollPane exitScroll;
    private JScrollPane doScroll;
    private JScrollPane internalTransitionsScroll;
    private ScrollList deferrableEventsScroll;


    /**
     * Construct a property panel for a State. Since State is abstract, this
     * will never be instantiated directly, but rather as part of the
     * instantiation of one of its concrete subclasses.
     * 
     * @param name the name of the properties panel, to be shown at the top
     * @param icon the icon to be shown next to the name
     */
    public AbstractPropPanelState(String name, ImageIcon icon) {
        super(name, icon);

        deferrableEventsScroll =
            new ScrollList(new UMLStateDeferrableEventListModel());

        JList entryList = new UMLStateEntryList(new UMLStateEntryListModel());
        entryList.setVisibleRowCount(2);
        entryScroll = new JScrollPane(entryList);
        JList exitList = new UMLStateExitList(new UMLStateExitListModel());
        exitList.setVisibleRowCount(2);
        exitScroll = new JScrollPane(exitList);
        JList internalTransitionList = new UMLMutableLinkedList(
                new UMLStateInternalTransition(), null,
                new ActionNewTransition());
        internalTransitionsScroll = new JScrollPane(internalTransitionList);
        JList doList = new UMLStateDoActivityList(
                new UMLStateDoActivityListModel());
        doList.setVisibleRowCount(2);
        doScroll = new JScrollPane(doList);
    }

    /*
     * @see org.argouml.uml.ui.behavior.state_machines.PropPanelStateVertex#addExtraButtons()
     */
    @Override
    protected void addExtraButtons() {
        super.addExtraButtons();
        
        Action a = new ActionNewTransition(); 
        a.putValue(Action.SHORT_DESCRIPTION, 
                Translator.localize("button.new-internal-transition"));
        Icon icon = ResourceLoaderWrapper.lookupIcon("Transition");
        a.putValue(Action.SMALL_ICON, icon);
        addAction(a);
    }

    /**
     * @return Returns the entryScroll.
     */
    protected JScrollPane getEntryScroll() {
        return entryScroll;
    }

    /**
     * @return Returns the exitScroll.
     */
    protected JScrollPane getExitScroll() {
        return exitScroll;
    }

    /**
     * @return Returns the doScroll.
     */
    protected JScrollPane getDoScroll() {
        return doScroll;
    }

    /**
     * @return Returns the internalTransitionsScroll.
     */
    protected JScrollPane getInternalTransitionsScroll() {
        return internalTransitionsScroll;
    }

    /**
     * @return Returns the deferrableEventsScroll.
     */
    protected JScrollPane getDeferrableEventsScroll() {
        return deferrableEventsScroll;
    }

}



