/* $Id: Section.java 370 2010-01-12 18:02:40Z linus $
 *****************************************************************************
 * Copyright (c) 2009 Contributors - see below
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    euluis
 *****************************************************************************
 *
 * Some portions of this file was previously release using the BSD License:
 */

// Copyright (c) 2003-2006 The Regents of the University of California. All
// Rights Reserved. Permission to use, copy, modify, and distribute this
// software and its documentation without fee, and without a written
// agreement is hereby granted, provided that the above copyright notice
// and this paragraph appear in all copies.  This software program and
// documentation are copyrighted by The Regents of the University of
// California. The software program and documentation are supplied "AS
// IS", without any accompanying services from The Regents. The Regents
// does not warrant that the operation of the program will be
// uninterrupted or error-free. The end-user understands that the program
// was developed for research purposes and is advised not to rely
// exclusively on the program for any reason.  IN NO EVENT SHALL THE
// UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
// SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
// ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
// THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY
// WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
// PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
// CALIFORNIA HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,
// UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

package org.argouml.language.cpp.generator;

import org.argouml.uml.generator.AbstractSection;

/**
 * Reading and writing preserved sections from the code.
 *
 * @since 24. Februar 2002, 15:30
 */
public class Section extends AbstractSection {

	/** No section. */
    public static final int SECT_NONE = 0;
	/** Normal section. */
    public static final int SECT_NORMAL = 1;
	/** Brief section. */
    public static final int SECT_BRIEF = 2;
	/** The section to use according to user settings. */
    private static int useSections = SECT_NORMAL;

    static void setUseSect(int use) {
	useSections = use;
    }
    static int getUseSect() {
        return useSections;
    }

    /**
     * System newline separator.
     */
    private static final String LINE_SEPARATOR =
	System.getProperty("line.separator");

    /*
     * @see org.argouml.uml.generator.AbstractSection#generate(
     *      java.lang.String, java.lang.String)
     */
    public static String generate(String id, String indent) {
        return (generateTop(id, indent) + generateBottom(id, indent));
    }

    /**
     * Variant of generate( String id, String indent ) which allows
     * parted generation of Top and Bottom, so that GeneratorXX.java
     * can place an initial body within the both identifying lines.
     *
     * @param id the section id
     * @param indent the current indentation
     * @return the generated string
     */
    public static String generateTop(String id, String indent) {
	if (useSections == SECT_NONE) return "";
        String s = indent;
	if (useSections != SECT_BRIEF) {
	    s += "// don't delete the following line as ";
	    s += "it's needed to preserve source code of this ";
	    s += "autogenerated element" + LINE_SEPARATOR + indent;
	}
        s += "// section " + id + " begin" + LINE_SEPARATOR;
        return s;
    }

    /**
     * Variant of generate( String id, String indent ) which allows
     * parted generation of Top and Bottom, so that GeneratorXX.java
     * can place an initial body within the both identifying lines.
     *
     * @param id the section id
     * @param indent the current indentation
     * @return the generated string
     */
    public static String generateBottom(String id, String indent) {
	if (useSections == SECT_NONE) return "";
        String s = indent + "// section " + id + " end" + LINE_SEPARATOR;
	if (useSections != SECT_BRIEF) {
	    s += indent + "// don't delete the previous line as ";
	    s += "it's needed to preserve source code of this ";
	    s += "autogenerated element" + LINE_SEPARATOR;
	}
        return s;
    }
}
