#lang scheme

;; Soluciones Auxiliar 1

(define test equal?)

;; 1
;; fibs : int -> int
;; Obtiene el k-ésimo número de Fibonacci
(define (fibs k)
  (cond
    ((equal? k 1) 0)
    ((equal? k 2) 1)
    (else (+ (fibs (- k 1)) (fibs (- k 2))))))

;; Tests
(test (fibs 1) 0)
(test (fibs 2) 1)
(test (fibs 3) (+ (fibs 1) (fibs 2)))
(test (fibs 10) (+ (fibs 9) (fibs 8)))


;; 2
;; rango : int x int -> list<int>
;; Genera una lista con enteros desde ini hasta fin
(define (rango ini fin)
  (cond
    ((> ini fin) '())
    (else (cons ini (rango (+ ini 1) fin)))))

;; Tests
(test (rango 3 2) '())
(test (rango 3 3) '(3))
(test (rango -3 -3) '(-3))
(test (rango 0 10) '(0 1 2 3 4 5 6 7 8 9 10))
(test (rango -5 5) '(-5 -4 -3 -2 -1 0 1 2 3 4 5))


;; 3
;; lista-fibs

;; lista-fibs-1: int -> list<int>
;; Retorna una lista con los primeros k números de Fibonacci
;; Esta versión no utiliza map
(define (lista-fibs-1 k)
  (if (<= k 0)
      '()
      (letrec ((fibolist
                (lambda(i)
                  (if (> i k)
                      '()
                      (cons (fibs i) (fibolist (+ i 1)))))))
        (fibolist 1))))


;; Tests
(test (lista-fibs-1 0) '())
(test (lista-fibs-1 -1) '())
(test (lista-fibs-1 1) '(0))
(test (lista-fibs-1 2) '(0 1))
(test (lista-fibs-1 5) (list (fibs 1) (fibs 2) (fibs 3) (fibs 4) (fibs 5)))


;; 4
;;Versión utilizando map y rango
(define (lista-fibs-2 k)
  (map fibs (rango 1 k)))

;; Tests
(test (lista-fibs-2 0) '())
(test (lista-fibs-2 -1) '())
(test (lista-fibs-2 1) '(0))
(test (lista-fibs-2 2) '(0 1))
(test (lista-fibs-2 5) (list (fibs 1) (fibs 2) (fibs 3) (fibs 4) (fibs 5))) 


;; 5
;; intercalar : list1 x list2 -> list
;; Retorna los elementos intercalados de list1 y list2, comenzando con list1
(define (intercalar lista1 lista2)
  (cond
    ((null? lista1) '())
    ((null? lista2) '())
    (else (cons (car lista1) (cons (car lista2) (intercalar (cdr lista1) (cdr lista2)))))))

;; Tests
(test (intercalar '() '()) '())
(test (intercalar '(1) '()) '())
(test (intercalar '(1 2 3) '()) '())
(test (intercalar '(1 2 3) '()) '())
(test (intercalar '() '(1)) '())
(test (intercalar '(1 2 3) '(a b c)) '(1 a 2 b 3 c))
(test (intercalar '(1) '(2)) '(1 2))
(test (intercalar '(1 2) '(a b c d)) '(1 a 2 b))


;; 6
;; suma-lista: list<num> -> num
;; Retorna la suma de los elementos de la lista. Se asume que son números
;; En caso de lista vacía, la suma es cero
(define (suma-lista l)
  (cond
    ((null? l) 0)
    (else (+ (car l) (suma-lista (cdr l))))))

;; Tests
(test (suma-lista '()) 0)
(test (suma-lista '(1)) 1)
(test (suma-lista '(1 2 3 4)) 10)
(test (suma-lista '(-1 -2 -3 -4 10)) 0)


;; 7
;; suma-fibs-cuadrado : int -> num
;; Suma los cuadrados de los primeros k números de Fibonacci.
;; En caso de lista vacía, la suma es cero
(define (suma-fibs-cuadrado k)
  (suma-lista (map (lambda(x) (* x x)) (lista-fibs-2 k))))

(define (suma-fibs-cubo k)
  (suma-lista (map (lambda(x) (* x x x)) (lista-fibs-2 k))))

(define (suma-fibs-mitad k)
  (suma-lista (map (lambda(x) (/ x 2)) (lista-fibs-2 k))))


;; 8
;; Basta definir suma-lista en función de foldl, y luego reemplazar en las sumas
(define (suma-lista-fold l)
  (foldl + 0 l))


;; 9
;; map implementado en función de foldr
;; Observe que la función argumento de foldr es una composición entre cons y la
;; función f que es parámetro de map
(define (map-fold f l)
  (foldr (lambda(x y)(cons (f x) y)) '() l))
