#lang scheme
(define test equal?)
(define z 10)

(define (fact n)
  (if (= n 0)
      1
      (* n (fact (- n 1)))))

(define (mayor-o-menor-o-igual x y)
  (cond
    ((< x y) "menor")
    ((> x y) "mayor")
    (else    "igual")))

(let ((x (+ 5 5))
      (y 4))
  (+ x y))

  
(let ((x 2))
  (let ((y (* x 2)))
    (+ x y)))

(let* ((double (lambda (x) (* 2 x)))
       (x 2)
       (y (double x)))
  (+ x y))

(let* ((x 2)
       (y ((lambda (x) (* 2 x)) x)))
  (+ x y))

(define (my-length l)
  (if (empty? l)
      0
      (+ 1 (my-length (cdr l)))))

(cons (car '(1 2 3))
      (cdr '(1 2 3)))

(append '(1 2 3) '(4 5 6))

(cons 1 2)

(+ (car (cons 1 2))
   (cdr (cons 1 2)))

;(define (sum l)
;  (if (empty? l) 0
;      (+ (first l) (sum (rest l)))))

;(define (prod l)
;  (if (empty? l) 1
;      (* (first l) (prod (rest l)))))

(define (process l op base)
  (if (empty? l) base
      (op (first l) (process (rest l) op base))))


(define (prod l)
  (process l * 1))

(define (sum l)
  (process l + 0))

(sum '(1 2 3))
(prod '(1 2 3 4))

;; member? :: num x list(num) -> bool
;; retorna true si el numero dado esta en la lista
;; false sino
(define (member? x l)
  (if (empty? l) (begin (write "not found")
                        #f)
      (or (equal? x (car l))
          (member? x (cdr l)))))

(test (member? 1 '(1 2 3)) #t)
(test (member? 1 '(2 3)) #f)

(define (my-sqrt x)
  
  (define (try guess x)
    (if (good-enough? guess x) 
        guess
        (try (improve guess x) x)))

  (define (good-enough? g x)
    (< (abs (- x (square g))) *epsilon*))

  (define *epsilon* .0001)
  
  (define (improve g x)
    (average g (/ x g)))

  (define (square x) (* x x))
  (define (average x y)
    (/ (+ x y) 2))

  (try 1 x))


(define (proc l op)
  (if (empty? l) '()
      (cons (op (car l))
            (proc (cdr l) op))))

(define (add1-list l)
  (proc l (lambda (x) (+ x 1))))

(define (double-list l)
  (proc l (lambda (x) (* x 2))))

(test (add1-list '(1 2 3 4)) '(2 3 4 5))
(test (double-list '(1 2 3 4)) '(2 4 6 8))





