// radiosity.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <math.h>	// Math library header file
#include <stdio.h>	// Header file for standard Input/Output
#include <string.h>
#include <iostream.h>
#include "vertice.h"
#include <list>
using namespace std;

#define MAXARRAY 50
#define PI 3.1415926

list <Vertice*> vertLista;
list <Vertice*> vertListabak;

/*void readstr(FILE *f,char *string)
{
	do
	{
		fgets(string, 500, f);
	} while ((string[0] == '/') || (string[0] == '\n'));
	return;
}*/

int main(int argc, char* argv[]){

	char oneline[255];
	FILE* filein;
	int numtriangles;
	int loopPol, loopVert;
	float x, y, z, u, v, r, g, b, l, i;
	int j, k;

	filein = fopen("data/world.txt", "rt");
	readstr(filein,oneline);
	sscanf(oneline, "NUMPOLLIES %d\n", &numtriangles);
	//cout << "Triangulos: "<< numtriangles << \n;

	if(MAXARRAY< numtriangles){
		cout << "Arreglo demasiado pequeo. Ejecucin abortada\n" ;
		return -1;
	}
	
	//Creamos los poligonos y los cargamos del archivo de texto
	Poligono* matrizPol = new Poligono[numtriangles];

	for(loopPol=0; loopPol<numtriangles*3; loopPol++){
		//for(loopVert = 0; loopVert<3; loopVert++){
		readstr(filein,oneline);
		sscanf(oneline, "%f %f %f %f %f %f %f %f %f %f", &x, &y, &z, &u, &v, &r, &g, &b, &l, &i);
		//cout << "linea: " << oneline <<"\n";
		Vertice* vert = new Vertice(x,y,z,u,v,r,g,b,l,i);
		vertLista.push_front(vert);
		//}
	}

	for(loopPol = 0; loopPol<numtriangles; loopPol++){
		for(loopVert = 0; loopVert < 3; loopVert++){
			switch(loopVert){
				case 0:
					//matrizPol[loopPol].SetA(*vertLista.back());
					//vertLista.pop_back();
					matrizPol[loopPol].a = *vertLista.back();
					//cout << vertLista.back()->X()<<"\n";
					vertLista.pop_back();
					//cout << "matrizPol[" << loopPol <<"].V1(): " << (double)matrizPol[loopPol].V1().X()<<","<<(double)matrizPol[loopPol].V1().Y()<<","<<(double)matrizPol[loopPol].V1().Z()<< "\n";
					break;
				case 1:
					matrizPol[loopPol].SetB(*vertLista.back());
					vertLista.pop_back();
					//cout << "matrizPol[" << loopPol <<"].V2(): " << (double)matrizPol[loopPol].V2().X()<<","<<(double)matrizPol[loopPol].V2().Y()<<","<<(double)matrizPol[loopPol].V2().Z()<< "\n";
					break;
				case 2:
					matrizPol[loopPol].SetC(*vertLista.back());
					vertLista.pop_back();
					//cout << "matrizPol[" << loopPol <<"].V3(): " << (double)matrizPol[loopPol].V3().X()<<","<<(double)matrizPol[loopPol].V3().Y()<<","<<(double)matrizPol[loopPol].V3().Z()<< "\n";
					break;
				default:
					cout << loopPol <<","<<loopVert<<": Default case\n";
					break;
			}
			
		}
		//cout << "matrizPol[" << loopPol <<"].Normal(): " << (double)matrizPol[loopPol].Normal().X() <<","<<(double)matrizPol[loopPol].Normal().Y()<<","<<(double)matrizPol[loopPol].Normal().Z()<< "\n";
		//cout << i << " ";
	}
	fclose(filein);

	//Imprimimos las normales
	/*for(j=0;j<numtriangles;j++){
		cout << "Normal:(" << matrizPol[j].Normal().X() << "\t" << matrizPol[j].Normal().Y() << "\t" << matrizPol[j].Normal().Z() << ") Mod " << matrizPol[j].Normal().Modulo() <<"\n";
	}*/

	//Calculamos los prod. puntos, solo como comprobacion
	/*
	for(j = 0; j < numtriangles; j++){
		for(int k = 0; k<=j; k++){
			cout << "matrizPol[" << j <<"].Normal(): " << (double)matrizPol[j].Normal().X() <<","<<(double)matrizPol[j].Normal().Y()<<","<<(double)matrizPol[j].Normal().Z()<< "\n";
			cout << j <<" * " << k << " : " << (double)matrizPol[j].Normal().Punto(matrizPol[k].Normal()) << "\n";
		}
	}*/

	//calculamos las distancias
	/*for(j = 0; j < numtriangles; j++){
		for(int k = 0; k<=j; k++){
			cout << "matrizPol[" << j <<"].Distancia("<<k<<"):" << (double)matrizPol[j].Distancia(matrizPol[k]) <<"\n";
			//cout << j <<" * " << k << " : " << (double)matrizPol[j].Normal().Punto(matrizPol[k].Normal()) << "\n";
		}
	}*/

	//calculamos las areas
	/*for(j = 0; j < numtriangles; j++){
			cout << "matrizPol[" << j <<"].Area():" << (double)matrizPol[j].Area()<<"\n";
			//cout << j <<" * " << k << " : " << (double)matrizPol[j].Normal().Punto(matrizPol[k].Normal()) << "\n";
	}*/

	double formfactor[MAXARRAY][MAXARRAY];
	for(j = 0; j< numtriangles; j++){
		for(k = 0; k<numtriangles; k++){
			formfactor[j][k] = 0;
		}
	}

	//Aqui calculamos el factor de forma
	
	cout << "matriz de radiosidad\n:";
	for(j = 0; j<numtriangles; j++){
		for(k = 0; k<numtriangles; k++){
			if(j!=k){
				myVector VectEntreIJ = matrizPol[k].Centro().vertVect();
				VectEntreIJ.Menos(matrizPol[j].Centro().vertVect());
				double IJX = VectEntreIJ.X();
				double IJY = VectEntreIJ.Y();
				double IJZ = VectEntreIJ.Z();
				double norma = VectEntreIJ.Norm();
				
				cout << j << ":" <<k << ":\n";
				cout << "Centro 1: (" << matrizPol[j].Centro().X() << "," << matrizPol[j].Centro().Y() << "," << matrizPol[j].Centro().Z() << ")\n";
				cout << "Centro 2: (" << matrizPol[k].Centro().X() << "," << matrizPol[k].Centro().Y() << "," << matrizPol[k].Centro().Z() << ")\n";
				cout << "Normal 1: (" << matrizPol[j].Normal().X() << "," << matrizPol[j].Normal().Y() << "," << matrizPol[j].Normal().Z() << ")\n";
				cout << "Normal 2: (" << matrizPol[k].Normal().X() << "," << matrizPol[k].Normal().Y() << "," << matrizPol[k].Normal().Z() << ")\n";
				cout << "V entre centro1: (" << VectEntreIJ.X() << "," << VectEntreIJ.Y() << "," << VectEntreIJ.Z() << ")\n";
				
				double ppunto1 = matrizPol[j].Normal().Punto(VectEntreIJ.Unitario());

				VectEntreIJ= matrizPol[j].Centro().vertVect();
				VectEntreIJ.Menos(matrizPol[k].Centro().vertVect());
				
				cout << "V entre centro2: (" << VectEntreIJ.X() << "," << VectEntreIJ.Y() << "," << VectEntreIJ.Z() << ")\n";
			
				double ppunto2 = matrizPol[k].Normal().Punto(VectEntreIJ.Unitario());

				if(ppunto1 < 0){
					ppunto1 = -ppunto1;
				}
				if(ppunto2 < 0){
					ppunto2 = -ppunto2;
				}
				double divisor = PI*matrizPol[j].Distancia(matrizPol[k])*matrizPol[j].Distancia(matrizPol[k]);
				formfactor[j][k]=(ppunto1*ppunto2*matrizPol[j].Ve(matrizPol[k])*matrizPol[k].AngSol(matrizPol[j].Distancia(matrizPol[k])))/divisor;
				if(formfactor[j][k]<0){
					formfactor[j][k] = - formfactor[j][k];
				}
			
				cout << "ppunto dif theta1: " << ppunto1 << "\n";
				cout << "ppunto dif theta2: " << ppunto2 << "\n";
				cout << "Area: " << matrizPol[k].Area() << "\n";
				cout << "Distancia: " << matrizPol[j].Distancia(matrizPol[k]) <<"\n";
				cout << "Angulo Solido: " << matrizPol[k].AngSol(matrizPol[j].Distancia(matrizPol[k]))/3.1415926<<" PI\n";
				cout << "Form factor: " << formfactor[j][k] << "\n\n";
			}else{
				formfactor[j][k] = 0;
			}	
		}
	}

	
	//Vemos la matriz de radiosidad
	
	for(j = 0; j<numtriangles; j++){
		for(k = 0; k<numtriangles; k++){
			cout << formfactor[j][k] << "\t\t";
		}
		cout <<"\n";
	}
	
	/*for(j=0;j<numtriangles;j++){
			double ff = 0;
			for(k=0; k<numtriangles; k++){
				ff = ff+formfactor[j][k];
			}
			cout << "Energia irr por " << j << ": " << ff << "\n";
	}*/
	return 0;
}

/*
Crear; 
-Poligono::Area()
-Poligono::Ve(Poligono objetivo) (Hij en los apuntes)
-double Poligono::Distancia(Poligono objetivo)
-Poligono::Centro()
*/
