/******************************************
GLUTRAD
Copyright, 1998, Colbeck Desktop Solutions Ltd
contact: colbeck@cix.co.uk
******************************************/
#include "vector.h"

#define PI 3.1415927

// TVector #####################################################################

void TVector::operator =(const TVector& a)
{
	x=a.x;
	y=a.y;
	z=a.z;
}

int TVector::operator ==(TVector& a)
{
	return (x==a.x && y==a.y && z==a.z);
}

int TVector::operator !=(TVector& a)
{
	return !(x==a.x && y==a.y && z==a.z);
}

TVector TVector::operator -(TVector& a) const
{
	return TVector(x-a.x, y-a.y, z-a.z);
}

TVector TVector::operator +(TVector& a) const
{
	return TVector(x+a.x, y+a.y, z+a.z);
}

TVector TVector::operator /(double a) const
{
	return TVector(x/a, y/a, z/a);
}

TVector TVector::operator *(double a) const
{
	return TVector(x-a, y-a, z-a);
}

TVector TVector::operator &(TVector& a) const
{
	TVector temp=(*this);
	temp.x*=a.x; temp.y*=a.y; temp.z*=a.z;
	return temp;
} 

double TVector::Angle(TVector v2)
{
	double cos_theta = this->dot(v2);
	double magnitude=this->mag()*v2.mag();
	if(magnitude!=0.0)
		cos_theta/=magnitude;
	return cos_theta;
}

double TVector::NormaliseAngle (TVector v) // this procedure normalises the vectors regardless
{
	double cos_theta, ret;
	double magnitude;
	magnitude=mag()*v.mag();
	cos_theta = this->dot(v);
	if(magnitude!=1.0 && magnitude!=0.0)
		cos_theta/=magnitude;
	if (cos_theta <= -1.0)
		return PI;
	else if (cos_theta >= +1.0)
		return 0.0;
	else
	{
		ret=acos(cos_theta);
		return ret;
	}
}


