#ifndef __VERTICE_H
	#define __VERTICE_H

#include <math.h>
#include <string.h>

//#define max(a, b)  (((a) > (b)) ? (a) : (b)) 

class myVector{
private:
	double x, y, z, mod;
public:
	//Constructores
	myVector(){}
	myVector(double X, double Y, double Z){
		x = X;
		y = Y;
		z = Z;
		//norm = 1;
		mod = sqrt(x*x+y*y+z*z);
	}
	//Mtodos
	void myVector::Set(double a, double b, double c){
		x = a;
		y = b;
		z = c;
		//norm = 1;
		mod = sqrt(x*x+y*y+z*z);
	}
	double myVector::Modulo(){
		return mod;
	}
	double myVector::X(){
		return this->x;
	}
	double myVector::Y(){
		return this->y;
	}
	double myVector::Z(){
		return this->z;
	}
	double myVector::Norm(){
		return this->mod;
	}
	void myVector::Mas(myVector V){
		x=this->x+V.x;
		y=this->y+V.y;
		z=this->z+V.z;
		mod = sqrt(x*x+y*y+z*z);
	}
	void myVector::Menos(myVector V){
		x=this->x-V.x;
		y=this->y-V.y;
		z=this->z-V.z;
		mod = sqrt(x*x+y*y+z*z);
	}
	/*myVector myVector::operator+(myVector V){
		x=this->x+V.x;
		y=this->y+V.y;
		z=this->z+V.z;
		mod = sqrt(x*x+y*y+z*z);
		return *this;
	}*/
	double myVector::Punto(myVector V){
		double c = this->x*V.x+this->y*V.y+this->z*V.z;
		return c;
	}
	myVector myVector::Cruz(myVector V){
		myVector c;
		c.Set(this->y*V.z-this->z*V.y,this->z*V.x-this->x*V.z,this->x*V.y-this->y*V.x);
		return c;
	}
	myVector myVector::Unitario(){
		myVector c;
		c.Set(x/this->Norm(),y/this->Norm(),z/this->Norm());
		return c;
	}
	myVector myVector::Pond(double num){
		myVector c;
		c.Set(x*num,y*num,z*num);
		return c;
	}
};


class Vertice
{
private:
	double v1, v2, v3, u, v, red, green, blue, ilum, irr;
public:
	//Constructores
	Vertice(){}
	Vertice(double a, double b, double c, double U, double V, double Red, double Green, double Blue, double Ilum, double Irr)
	{
		v1 = a;
		v2 = b;
		v3 = c;
		u = U;
		v = V;
		red = Red;
		green = Green;
		blue = Blue;
		ilum = Ilum;
		irr = Irr;
	}

	//Mtodos
	void Vertice::Set(double a, double b, double c, double Red, double Green, double Blue, double Ilum, double Irr)
	{
		v1 = a;
		v2 = b;
		v3 = c;
		red = Red;
		green = Green;
		blue = Blue;
		ilum = Ilum;
		irr = Irr;
	}
	double Vertice::X(){
		return v1;
	}
	double Vertice::Y(){
		return v2;
	}
	double Vertice::Z(){
		return v3;
	}	
	double Vertice::U(){
		return u;
	}
	double Vertice::V(){
		return v;
	}
	double Red(){
		return red;
	}
	double Green(){
		return green;
	}
	double Blue(){
		return blue;
	}
	double Vertice::Ilum(){
		//cout << "Ilum: " << ilum << "\n";
		return ilum;
	}
	double Vertice::Irr(){
		//cout << "Irr(): " << irr << "\n";
		return irr;
	}
	myVector Vertice::vertVect(){
		myVector c;
		c.Set(v1,v2,v3);
		return c;
	}
};

class Poligono
{
private:
	//Vertice a, b, c;
	double ilum, irr;
public:
	Vertice a, b, c;
	//double ilum, irr;
	Poligono(){}
	Poligono(Vertice A, Vertice B, Vertice C){
		a = A;
		b = B;
		c = C;
		ilum = (a.Ilum()+b.Ilum()+c.Ilum())/3.0;
		irr = (a.Irr()+b.Irr()+c.Irr())/3.0;
	}
	void Poligono::Set(Vertice A, Vertice B, Vertice C){
		a = A;
		b = B;
		c = C;
		ilum = (a.Ilum()+b.Ilum()+c.Ilum())/3.0;
		irr = (a.Irr()+b.Irr()+c.Irr())/3.0;
	}
	void Poligono::SetA(Vertice A){
		a = A;
	}
	void Poligono::SetB(Vertice B){
		b = B;
	}
	void Poligono::SetC(Vertice C){
		c = C;
	}
	void Poligono::SetIlum(double Il){
		ilum = Il;
	}
	void Poligono::SetIlumIrr(){
		ilum = (a.Ilum()+b.Ilum()+c.Ilum())/3.0;
		irr = (a.Irr()+b.Irr()+c.Irr())/3.0;
	}
	void Poligono::SetIrr(double Irr){
		irr = Irr;
	}
	Vertice Poligono::V1(){
		return a;
	}
	Vertice Poligono::V2(){
		return b;
	}
	Vertice Poligono::V3(){
		return c;
	}
	double Poligono::Ilum(){
		return ilum;
	}
	double Poligono::Irr(){
		return irr;
	}
	double Poligono::Red(){
		return (a.Red()+b.Red()+c.Red())/3;
	}
	double Poligono::Green(){
		return (a.Green()+b.Green()+c.Green())/3;
	}
	double Poligono::Blue(){
		return (a.Blue()+b.Blue()+c.Blue())/3;
	}
	double Poligono::Area(){	
		myVector* v1 = new myVector(c.vertVect());
		myVector* v2 = new myVector(b.vertVect());
		v1->Menos(a.vertVect());
		v2->Menos(a.vertVect());
		myVector comp = v2->Pond(v1->Punto(*v2)/(v2->Norm()*v2->Norm()));
		double h = v1->Norm()*sin(acos(comp.Norm()/v1->Norm()));
		//cout << "v1:("<<v1->X()<<" , "<<v1->Y()<<" , "<<v1->Z()<<")\n";
		//cout << "v2:("<<v2->X()<<" , "<<v2->Y()<<" , "<<v2->Z()<<")\n";
		//cout << "h: " << h <<"\n";
		double area = h*v2->Norm()/2.0;
		//cout << "Area: " << area << "\n";
		return area;
	}
	myVector Poligono::Normal(){
		myVector v1 = this->b.vertVect();
		myVector v2 = this->c.vertVect();
		v1.Menos(this->a.vertVect());
		v2.Menos(this->a.vertVect());
		myVector cruz = v1.Cruz(v2);
		double r1 = cruz.X()/cruz.Norm();
		double r2 = cruz.Y()/cruz.Norm();
		double r3 = cruz.Z()/cruz.Norm();
		cruz.Set(r1,r2,r3);
		return cruz;
	}
	Vertice Poligono::Centro(){
		//Vertice* centro = new Vertice();
		double centroX = (a.X()+b.X()+c.X())/3.0;
		double centroY = (a.Y()+b.Y()+c.Y())/3.0;
		double centroZ = (a.Z()+b.Z()+c.Z())/3.0;
		double centroU = (a.U()+b.U()+c.U())/3.0;
		double centroV = (a.V()+b.V()+c.V())/3.0;
		Vertice *centro = new Vertice(centroX, centroY, centroZ, centroU, centroV, 0,0,0,0,0);
		return *centro;
	}
	double Poligono::Distancia(Poligono objetivo){
		Vertice centro1 = this->Centro();
		Vertice centro2 = objetivo.Centro();
		double x2 = (centro2.X()-centro1.X())*(centro2.X()-centro1.X());
		double y2 = (centro2.Y()-centro1.Y())*(centro2.Y()-centro1.Y());
		double z2 = (centro2.Z()-centro1.Z())*(centro2.Z()-centro1.Z());
		double distancia = sqrt(x2+y2+z2);
		return distancia;
	}
	int Poligono::Ve(Poligono objetivo){
		return 1;
	}
	double Poligono::AngSol(double distancia){
		double area = this->Area();
		double radio = sqrt(area/3.1415926);
		//cout << "**atan: " << atan(radio/distancia) << "\n";
		double theta = atan(radio/distancia);
		//cout << "**radio sol: " << radio << "\n";
		//cout << "**Theta Sol: " << theta << "\n";
		double angsol = (cos((3.1415926/2)-theta));
		return angsol;
	}
	
};


#endif
