	//---------------------------------------------------------------------------

#include <windows.h>    // Header file for windows
#include "stdafx.h"
#include <math.h>	// Math library header file
#include <stdio.h>	// Header file for standard Input/Output
#include <string.h>
#include <iostream.h>
#include <gl\gl.h>      // Header file for the OpenGL32 library
#include <gl\glu.h>     // Header file for the GLu32 library
#include <gl\glaux.h>   // Header file for the GLaux library
#include "vertice.h"
#include <list>
using namespace std;

#pragma hdrstop

#define MAXARRAY 50
#define IRRLIMIT 0.1
#define PI 3.1415926

list <Vertice*> vertLista;
list <Vertice*> vertListabak;

//list <double> ilumLista;
//list <double> ilumListabak;

//---------------------------------------------------------------------------
//#pragma argsused


HGLRC hRC = NULL;               // Permanent rendering context
HDC hDC = NULL;                 // Private GDI device context
HWND hWnd = NULL;               // Holds our window handle
HINSTANCE hInstance = NULL;     // Holds the instance of the application

bool keys[256];                 // Array used for the keyboard routine
bool active = true;             // Window active flag set to TRUE by default
bool fullscreen = true;         // Fullscreen flag set to fullscreen mode by default

bool blend;			// Blending ON/OFF
bool bp;			// B pressed?
bool fp;			// F pressed?
bool rad;			// R pressed?

const float piover180 = 0.0174532925f;
float heading;
float xpos;
float zpos;

GLfloat	yrot;                   // Y Rotation
GLfloat walkbias = 0;
GLfloat walkbiasangle = 0;
GLfloat lookupdown = 0.0f;
GLfloat	z = 0.0f;               // Depth into the screen

Poligono* matrizPol = new Poligono[MAXARRAY];
double formfactor[MAXARRAY][MAXARRAY];
int numtriangles, numvertices, cero;

GLuint filter;			// Which filter to use
//GLuint texture[3];		// Storage for 3 textures

typedef struct tagVERTEX
{
	float x, y, z;
	float u, v;
} VERTEX;

typedef struct tagCOLOR
{
	float r, g, b;
} COLOR;
typedef struct tagILUM
{
	float ilum, irr;
	//double ilum, irr;
} ILUM;
typedef struct tagTRIANGLE
{
	VERTEX vertex[3];
	COLOR color[3];
	ILUM ilum[3];
} TRIANGLE;

typedef struct tagSECTOR
{
	int numtriangles;
	TRIANGLE* triangle;
} SECTOR;

SECTOR sector1;         // Our model goes here:

LRESULT	CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);   // Declaration for WndProc

void readstr(FILE *f,char *string)
{
	do
	{
		fgets(string, 500, f);
	} while ((string[0] == '/') || (string[0] == '\n'));
	return;
}

void SetupWorld()
{
	float x, y, z, u, v, r, g, b, l, i;
	FILE *filein;
	cout << "Nombre del archivo a abrir: " ;
	char *archivo;
	archivo = new char[255];
	cin.get(archivo,255);
	filein = fopen(archivo, "rt");	 

	char oneline[500];
	readstr(filein,oneline);
	readstr(filein,oneline);
	sscanf(oneline, "%d %d %d", &numvertices, &numtriangles, &cero);
	cout << numvertices <<" vertices, "<<numtriangles <<" triangulos\n";
	sector1.triangle = new TRIANGLE[numtriangles];
	Vertice* matrizVertices = new Vertice[numvertices];
	sector1.numtriangles = numtriangles;
	
	if(MAXARRAY< numtriangles){
		cout << "Arreglo demasiado pequeo. Ejecucin abortada\n" ;
		return;
	}
	
	
	for(int loop = 0; loop < numvertices; loop++){
		readstr(filein,oneline);
		sscanf(oneline, "%f %f %f %f %f %f %f %f", &x, &y, &z, &r, &g, &b, &l, &i);
		matrizVertices[loop].Set(x,y,z,r,g,b,l,i);
	}
	for(loop = 0; loop < numtriangles; loop++){
		readstr(filein, oneline);
		int a,b,c;
		sscanf(oneline, "%d %d %d %d", &u, &a, &b, &c);
		sector1.triangle[loop].vertex[0].x = matrizVertices[a].X();
		sector1.triangle[loop].vertex[0].y = matrizVertices[a].Y();
		sector1.triangle[loop].vertex[0].z = matrizVertices[a].Z();
		sector1.triangle[loop].color[0].r = matrizVertices[a].Red();
		sector1.triangle[loop].color[0].g = matrizVertices[a].Green();
		sector1.triangle[loop].color[0].b = matrizVertices[a].Blue();
		sector1.triangle[loop].ilum[0].ilum = matrizVertices[a].Ilum();
		sector1.triangle[loop].ilum[0].irr = matrizVertices[a].Irr();
			

		sector1.triangle[loop].vertex[1].x = matrizVertices[b].X();
		sector1.triangle[loop].vertex[1].y = matrizVertices[b].Y();
		sector1.triangle[loop].vertex[1].z = matrizVertices[b].Z();
		sector1.triangle[loop].color[1].r = matrizVertices[b].Red();
		sector1.triangle[loop].color[1].g = matrizVertices[b].Green();
		sector1.triangle[loop].color[1].b = matrizVertices[b].Blue();
		sector1.triangle[loop].ilum[1].ilum = matrizVertices[b].Ilum();
		sector1.triangle[loop].ilum[1].irr = matrizVertices[b].Irr();
		
		sector1.triangle[loop].vertex[2].x = matrizVertices[c].X();
		sector1.triangle[loop].vertex[2].y = matrizVertices[c].Y();
		sector1.triangle[loop].vertex[2].z = matrizVertices[c].Z();
		sector1.triangle[loop].color[2].r = matrizVertices[c].Red();
		sector1.triangle[loop].color[2].g = matrizVertices[c].Green();
		sector1.triangle[loop].color[2].b = matrizVertices[c].Blue();
		sector1.triangle[loop].ilum[2].ilum = matrizVertices[c].Ilum();
		sector1.triangle[loop].ilum[2].irr = matrizVertices[c].Irr();
		
	}
	/*
	for (int loop = 0; loop < numtriangles; loop++)
	{
		for (int vert = 0; vert < 3; vert++)
		{
			readstr(filein,oneline);
			sscanf(oneline, "%f %f %f %f %f %f %f %f %f %f", &x, &y, &z, &u, &v, &r, &g, &b, &l, &i);
			sector1.triangle[loop].vertex[vert].x = x;
			sector1.triangle[loop].vertex[vert].y = y;
			sector1.triangle[loop].vertex[vert].z = z;
			sector1.triangle[loop].vertex[vert].u = u;
			sector1.triangle[loop].vertex[vert].v = v;
			sector1.triangle[loop].color[vert].r = r;
			sector1.triangle[loop].color[vert].g = g;
			sector1.triangle[loop].color[vert].b = b;
			sector1.triangle[loop].ilum[vert].ilum = l;
			sector1.triangle[loop].ilum[vert].irr = i;
			//char cadena[20];
			//int k = sprintf(cadena,"ilum: %f\n irr: %f\n b: %f",sector1.triangle[loop].ilum[vert].ilum ,sector1.triangle[loop].ilum[vert].irr, sector1.triangle[loop].color[vert].b);
			//MessageBox(NULL,cadena,"informacion confidencial",MB_OK | MB_ICONINFORMATION);

		}
	}
	*/
	fclose(filein);

	// Calculo del factor de forma

	int loopPol, loopVert;
	int j, k;
	
	filein = fopen(archivo, "rt");

	readstr(filein,oneline);
	readstr(filein,oneline);
	readstr(filein,oneline);

	//Creamos los polgonos para CALCULO a partir de los poligonos para DIBUJO
	
	for(loopPol=0; loopPol<numtriangles*3; loopPol++){
		readstr(filein,oneline);
		sscanf(oneline, "%f %f %f %f %f %f %f %f %f %f", &x, &y, &z, &u, &v, &r, &g, &b, &l, &i);
		Vertice* vert = new Vertice(x,y,z,u,v,r,g,b,l,i);
		//cout << "Iluminacion vertice: " << vert->Ilum() << "\n";
		vertLista.push_front(vert);
	}


	for(loopPol = 0; loopPol<numtriangles; loopPol++){
		double ilum_temp = 0;
		for(loopVert = 0; loopVert < 3; loopVert++){
			switch(loopVert){
				case 0:
					matrizPol[loopPol].SetA(*vertLista.back());
					vertLista.pop_back();
					break;
				case 1:
					matrizPol[loopPol].SetB(*vertLista.back());
					vertLista.pop_back();
					break;
				case 2:
					matrizPol[loopPol].SetC(*vertLista.back());
					vertLista.pop_back();
					break;
				default:
					cout << loopPol <<","<<loopVert<<": Default case\n";
					break;
			}
			matrizPol[loopPol].SetIlumIrr();
		}
		//cout << "Iluminacion: " << matrizPol[loopPol].Ilum() << "\n";
	}
	//fclose(filein);

	
	for(j = 0; j< numtriangles; j++){
		for(k = 0; k<numtriangles; k++){
			formfactor[j][k] = 0;
		}
	}

	//Aqui calculamos el factor de forma
	
	//cout << "matriz de radiosidad\n:";
	for(j = 0; j<numtriangles; j++){
		for(k = 0; k<numtriangles; k++){
			if(j!=k){
				myVector VectEntreIJ = matrizPol[k].Centro().vertVect();
				VectEntreIJ.Menos(matrizPol[j].Centro().vertVect());
				double IJX = VectEntreIJ.X();
				double IJY = VectEntreIJ.Y();
				double IJZ = VectEntreIJ.Z();
				double norma = VectEntreIJ.Norm();
				
				//cout << j << ":" <<k << ":\n";
				//cout << "Centro 1: (" << matrizPol[j].Centro().X() << "," << matrizPol[j].Centro().Y() << "," << matrizPol[j].Centro().Z() << ")\n";
				//cout << "Centro 2: (" << matrizPol[k].Centro().X() << "," << matrizPol[k].Centro().Y() << "," << matrizPol[k].Centro().Z() << ")\n";
				//cout << "Normal 1: (" << matrizPol[j].Normal().X() << "," << matrizPol[j].Normal().Y() << "," << matrizPol[j].Normal().Z() << ")\n";
				//cout << "Normal 2: (" << matrizPol[k].Normal().X() << "," << matrizPol[k].Normal().Y() << "," << matrizPol[k].Normal().Z() << ")\n";
				//cout << "V entre centro1: (" << VectEntreIJ.X() << "," << VectEntreIJ.Y() << "," << VectEntreIJ.Z() << ")\n";
				
				double ppunto1 = matrizPol[j].Normal().Punto(VectEntreIJ.Unitario());

				VectEntreIJ= matrizPol[j].Centro().vertVect();
				VectEntreIJ.Menos(matrizPol[k].Centro().vertVect());
				
				//cout << "V entre centro2: (" << VectEntreIJ.X() << "," << VectEntreIJ.Y() << "," << VectEntreIJ.Z() << ")\n";
			
				double ppunto2 = matrizPol[k].Normal().Punto(VectEntreIJ.Unitario());

				/*if(ppunto1 < 0){
					ppunto1 = -ppunto1;
				}
				if(ppunto2 < 0){
					ppunto2 = -ppunto2;
				}*/
				double divisor = PI*matrizPol[j].Distancia(matrizPol[k])*matrizPol[j].Distancia(matrizPol[k]);
				formfactor[j][k]=(ppunto1*ppunto2*matrizPol[j].Ve(matrizPol[k])*matrizPol[k].AngSol(matrizPol[j].Distancia(matrizPol[k])))/divisor;
				if(formfactor[j][k]<0){
					formfactor[j][k] = - formfactor[j][k];
				}
			
				//cout << "ppunto dif theta1: " << ppunto1 << "\n";
				//cout << "ppunto dif theta2: " << ppunto2 << "\n";
				//cout << "Area: " << matrizPol[k].Area() << "\n";
				//cout << "Distancia: " << matrizPol[j].Distancia(matrizPol[k]) <<"\n";
				//cout << "Angulo Solido: " << matrizPol[k].AngSol(matrizPol[j].Distancia(matrizPol[k]))/3.1415926<<" PI\n";
				//cout << "Form factor: " << formfactor[j][k] << "\n\n";
			}else{
				formfactor[j][k] = 0;
			}	
		}
	}

	
	//Vemos la matriz de radiosidad
	/*
	for(j = 0; j<numtriangles; j++){
		for(k = 0; k<numtriangles; k++){
			cout << formfactor[j][k] << "\t\t";
		}
		cout <<"\n";
	}*/
	
	/*for(j=0;j<numtriangles;j++){
			double ff = 0;
			for(k=0; k<numtriangles; k++){
				ff = ff+formfactor[j][k];
			}
			cout << "Energia irr por " << j << ": " << ff << "\n";
	}*/

	/*for (j = 0; j< numtriangles; j++){
		cout << "iluminacion asignada: " << matrizPol[j].Ilum() << "\n";
		ilum[j] = matrizPol[j].Ilum();
	}*/
	return;
}

GLvoid ReSizeGLScene(GLsizei width, GLsizei height)     // Resize and initialize the GL window
{
        if (height == 0)                        // Prevent a divide by zero by
        {
                height = 1;                     // Making height equal One
        }

        glViewport(0, 0, width, height);        // Reset the current viewport

        glMatrixMode(GL_PROJECTION);            // Select the projection matrix
	glLoadIdentity();                       // Reset the projection matrix

	// Calculate the aspect ratio of the window
	gluPerspective(45.0f,(GLfloat)width/(GLfloat)height,0.1f,100.0f);

	glMatrixMode(GL_MODELVIEW);             // Select the modelview matrix
	glLoadIdentity();                       // Reset the modelview matrix
}

int InitGL(GLvoid)      // All setup for OpenGL goes here
{
	/*
	if (!LoadGLTextures())          // Jump to texture loading routine
	{
		return false;           // If texture didn't load return FALSE
	}
	*/
	//glEnable(GL_TEXTURE_2D);	        // Enable texture mapping
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);	// Set the blending function for translucency
	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);	// This will clear the background color to black
	glClearDepth(1.0);			// Enables clearing of the depth buffer
	glDepthFunc(GL_LESS);			// The type of depth test to do
	glEnable(GL_DEPTH_TEST);		// Enables depth testing
	glShadeModel(GL_SMOOTH);		// Enables smooth color shading
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	// Really nice perspective calculations

	SetupWorld();

	return TRUE;            // Initialization went OK
}

int DrawGLScene(GLvoid)         // Here's where we do all the drawing
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);     // Clear the screen and the depth buffer
	glLoadIdentity();					// Reset the view

	GLfloat x_m, y_m, z_m, u_m, v_m, r_aux, g_aux, b_aux;
	GLfloat ilum_aux;
	//GLdouble ilum_aux, irr_aux;
	GLfloat xtrans = -xpos;
	GLfloat ztrans = -zpos;
	GLfloat ytrans = -walkbias-0.25f;
	GLfloat sceneroty = 360.0f - yrot;

	int numtriangles;

	glRotatef(lookupdown,1.0f,0,0);
	glRotatef(sceneroty,0,1.0f,0);
	
	glTranslatef(xtrans, ytrans, ztrans);
	//glBindTexture(GL_TEXTURE_2D, texture[filter]);
	
	numtriangles = sector1.numtriangles;
	
	// Process each triangle
	for (int loop_m = 0; loop_m < numtriangles; loop_m++)
	{
		glBegin(GL_TRIANGLES);
			glNormal3f( 0.0f, 0.0f, 1.0f);

			ilum_aux = matrizPol[loop_m].Ilum();
			r_aux = sector1.triangle[loop_m].color[0].r;
			g_aux = sector1.triangle[loop_m].color[0].g;
			b_aux = sector1.triangle[loop_m].color[0].b;
			x_m = sector1.triangle[loop_m].vertex[0].x;
			y_m = sector1.triangle[loop_m].vertex[0].y;
			z_m = sector1.triangle[loop_m].vertex[0].z;
			u_m = sector1.triangle[loop_m].vertex[0].u;
			v_m = sector1.triangle[loop_m].vertex[0].v;
			//char cadena[20];
			//double aux = r_aux*ilum_aux;
			//int k = sprintf(cadena,"aux%g\n r_aux%g\n ilum_aux%g",aux,r_aux,ilum_aux);
			//sprintf( buffer,     "\tString:    %s\n", s );
			glColor3f(r_aux*ilum_aux,g_aux*ilum_aux,b_aux*ilum_aux);
			//MessageBox(NULL,cadena,"SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
			//glTexCoord2f(u_m,v_m); 
			glVertex3f(x_m,y_m,z_m);
			
			r_aux = sector1.triangle[loop_m].color[1].r;
			g_aux = sector1.triangle[loop_m].color[1].g;
			b_aux = sector1.triangle[loop_m].color[1].b;
			x_m = sector1.triangle[loop_m].vertex[1].x;
			y_m = sector1.triangle[loop_m].vertex[1].y;
			z_m = sector1.triangle[loop_m].vertex[1].z;
			u_m = sector1.triangle[loop_m].vertex[1].u;
			v_m = sector1.triangle[loop_m].vertex[1].v;
			glColor3f(r_aux*ilum_aux,g_aux*ilum_aux,b_aux*ilum_aux);
			//glTexCoord2f(u_m,v_m); 
			glVertex3f(x_m,y_m,z_m);
			
			r_aux = sector1.triangle[loop_m].color[2].r;
			g_aux = sector1.triangle[loop_m].color[2].g;
			b_aux = sector1.triangle[loop_m].color[2].b;
			x_m = sector1.triangle[loop_m].vertex[2].x;
			y_m = sector1.triangle[loop_m].vertex[2].y;
			z_m = sector1.triangle[loop_m].vertex[2].z;
			u_m = sector1.triangle[loop_m].vertex[2].u;
			v_m = sector1.triangle[loop_m].vertex[2].v;
			glColor3f(r_aux*ilum_aux,g_aux*ilum_aux,b_aux*ilum_aux);
			//glTexCoord2f(u_m,v_m); 
			glVertex3f(x_m,y_m,z_m);
		glEnd();
	}
	return true;            // Everything went OK
}

void Radiosity(){
	int j,k;
	for(j = 0; j<numtriangles;j++){
		//cout << "Poligono " << j << " irradia " << matrizPol[j].Irr() << "\n";
		for(k=0;k<numtriangles;k++){
			double irr = matrizPol[j].Irr();
			double ilum = matrizPol[j].Ilum();
			matrizPol[k].SetIlum(matrizPol[k].Ilum()+irr*ilum*formfactor[j][k]);
			matrizPol[j].SetIrr(irr*(1-irr*formfactor[j][k]));
		}
	}
	return;
}

GLvoid KillGLWindow(GLvoid)     // Properly kill the window
{
	if (fullscreen)         // Are we in fullscreen mode?
	{
		ChangeDisplaySettings(NULL,0);  // If so switch back to the desktop
		ShowCursor(true);               // Show mouse pointer
	}

	if (hRC)        // Do we have a rendering context?
	{
		if (!wglMakeCurrent(NULL,NULL))         // Are we able to release the DC and RC contexts?
		{
			MessageBox(NULL,"Release of DC and RC failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		}

		if (!wglDeleteContext(hRC))             // Are we able to delete the RC?
		{
			MessageBox(NULL,"Release rendering context failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		}
		hRC = NULL;             // Set RC to NULL
	}

	if (hDC && !ReleaseDC(hWnd,hDC))        // Are we able to release the DC
	{
		MessageBox(NULL,"Release device context failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		hDC = NULL;             // Set DC to NULL
	}

	if (hWnd && !DestroyWindow(hWnd))       // Are we able to destroy the window?
	{
		MessageBox(NULL,"Could not release hWnd.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		hWnd = NULL;            // Set hWnd to NULL
	}

	if (!UnregisterClass("OpenGL",hInstance))       // Are we able to unregister class
	{
		MessageBox(NULL,"Could not unregister class.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		hInstance = NULL;       // Set hInstance to NULL
	}
}

/*	This Code Creates Our OpenGL Window.  Parameters Are:
 *	title			- Title To Appear At The Top Of The Window
 *	width			- Width Of The GL Window Or Fullscreen Mode
 *	height			- Height Of The GL Window Or Fullscreen Mode
 *	bits			- Number Of Bits To Use For Color (8/16/24/32)
 *	fullscreenflag	- Use Fullscreen Mode (TRUE) Or Windowed Mode (FALSE)*/
 
BOOL CreateGLWindow(char* title, int width, int height, int bits, bool fullscreenflag)
{
	GLuint		PixelFormat;		// Holds the results after searching for a match
	WNDCLASS	wc;		        // Windows class structure
	DWORD		dwExStyle;              // Window extended style
	DWORD		dwStyle;                // Window style
	RECT		WindowRect;             // Grabs rctangle upper left / lower right values
	WindowRect.left = (long)0;              // Set left value to 0
	WindowRect.right = (long)width;		// Set right value to requested width
	WindowRect.top = (long)0;               // Set top value to 0
	WindowRect.bottom = (long)height;       // Set bottom value to requested height

	fullscreen = fullscreenflag;              // Set the global fullscreen flag

	hInstance               = GetModuleHandle(NULL);		// Grab an instance for our window
	wc.style                = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;   // Redraw on size, and own DC for window
	wc.lpfnWndProc          = (WNDPROC) WndProc;			// WndProc handles messages
	wc.cbClsExtra           = 0;					// No extra window data
	wc.cbWndExtra           = 0;					// No extra window data
	wc.hInstance            = hInstance;				// Set the Instance
	wc.hIcon                = LoadIcon(NULL, IDI_WINLOGO);		// Load the default icon
	wc.hCursor              = LoadCursor(NULL, IDC_ARROW);		// Load the arrow pointer
	wc.hbrBackground        = NULL;					// No background required for GL
	wc.lpszMenuName		= NULL;					// We don't want a menu
	wc.lpszClassName	= "OpenGL";				// Set the class name

	if (!RegisterClass(&wc))					// Attempt to register the window class
	{
		MessageBox(NULL,"Failed To Register The Window Class.","ERROR",MB_OK|MB_ICONEXCLAMATION);

		return false;   // Return FALSE
	}
	
	if (fullscreen)         // Attempt fullscreen mode?
	{
		DEVMODE dmScreenSettings;                                       // Device mode
		memset(&dmScreenSettings,0,sizeof(dmScreenSettings));	        // Makes sure memory's cleared
		dmScreenSettings.dmSize         = sizeof(dmScreenSettings);     // Size of the devmode structure
		dmScreenSettings.dmPelsWidth	= width;                        // Selected screen width
		dmScreenSettings.dmPelsHeight	= height;                       // Selected screen height
		dmScreenSettings.dmBitsPerPel	= bits;	                        // Selected bits per pixel
		dmScreenSettings.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;

		// Try to set selected mode and get results. NOTE: CDS_FULLSCREEN gets rid of start bar.
		if (ChangeDisplaySettings(&dmScreenSettings,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL)
		{
			// If the mode fails, offer two options. Quit or use windowed mode.
			if (MessageBox(NULL,"The requested fullscreen mode is not supported by\nyour video card. Use windowed mode instead?","NeHe GL",MB_YESNO|MB_ICONEXCLAMATION)==IDYES)
			{
				fullscreen = false;       // Windowed mode selected. Fullscreen = FALSE
			}
			else
			{
				// Pop up a message box letting user know the program is closing.
				MessageBox(NULL,"Program will now close.","ERROR",MB_OK|MB_ICONSTOP);
				return false;           // Return FALSE
			}
		}
	}

	if (fullscreen)                         // Are We Still In Fullscreen Mode?
	{
		dwExStyle = WS_EX_APPWINDOW;    // Window extended style
		dwStyle = WS_POPUP;		// Windows style
		ShowCursor(false);		// Hide mouse pointer
	}
	else
	{
		dwExStyle=WS_EX_APPWINDOW | WS_EX_WINDOWEDGE;           // Window extended style
		dwStyle=WS_OVERLAPPEDWINDOW;                            // Windows style
	}

	AdjustWindowRectEx(&WindowRect, dwStyle, FALSE, dwExStyle);     // Adjust window to true requested size

	// Create the window
	if (!(hWnd = CreateWindowEx(dwExStyle,          // Extended Style For The Window
                "OpenGL",				// Class name
		title,					// Window title
		dwStyle |				// Defined window style
		WS_CLIPSIBLINGS |			// Required window style
		WS_CLIPCHILDREN,			// Required window style
		0, 0,					// Window position
		WindowRect.right-WindowRect.left,	// Calculate window width
		WindowRect.bottom-WindowRect.top,	// Calculate window height
		NULL,					// No parent window
		NULL,					// No menu
		hInstance,				// Instance
		NULL)))					// Dont pass anything to WM_CREATE
	{
		KillGLWindow();                         // Reset the display
		MessageBox(NULL,"Window Creation Error.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return false;                           // Return FALSE
	}

	static	PIXELFORMATDESCRIPTOR pfd =             // pfd tells windows how we want things to be
	{
		sizeof(PIXELFORMATDESCRIPTOR),          // Size of this pixel format descriptor
		1,					// Version number
		PFD_DRAW_TO_WINDOW |			// Format must support window
		PFD_SUPPORT_OPENGL |			// Format must support OpenGL
		PFD_DOUBLEBUFFER,			// Must support double buffering
		PFD_TYPE_RGBA,				// Request an RGBA format
		bits,					// Select our color depth
		0, 0, 0, 0, 0, 0,			// Color bits ignored
		0,					// No alpha buffer
		0,					// Shift bit ignored
		0,					// No accumulation buffer
		0, 0, 0, 0,				// Accumulation bits ignored
		16,					// 16Bit Z-Buffer (Depth buffer)
		0,					// No stencil buffer
		0,					// No auxiliary buffer
		PFD_MAIN_PLANE,				// Main drawing layer
		0,					// Reserved
		0, 0, 0					// Layer masks ignored
	};
	
	if (!(hDC=GetDC(hWnd)))         // Did we get a device context?
	{
		KillGLWindow();         // Reset the display
		MessageBox(NULL,"Can't create a GL device context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return false;           // Return FALSE
	}

	if (!(PixelFormat=ChoosePixelFormat(hDC,&pfd)))	// Did windows find a matching pixel format?
	{
		KillGLWindow();         // Reset the display
		MessageBox(NULL,"Can't find a suitable pixelformat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return false;           // Return FALSE
	}

	if(!SetPixelFormat(hDC,PixelFormat,&pfd))       // Are we able to set the pixel format?
	{
		KillGLWindow();         // Reset the display
		MessageBox(NULL,"Can't set the pixelformat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return false;           // Return FALSE
	}

	if (!(hRC=wglCreateContext(hDC)))               // Are we able to get a rendering context?
	{
		KillGLWindow();         // Reset the display
		MessageBox(NULL,"Can't create a GL rendering context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return false;           // Return FALSE
	}

	if(!wglMakeCurrent(hDC,hRC))    // Try to activate the rendering context
	{
		KillGLWindow();         // Reset the display
		MessageBox(NULL,"Can't activate the GL rendering context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return false;           // Return FALSE
	}

	ShowWindow(hWnd,SW_SHOW);       // Show the window
	SetForegroundWindow(hWnd);      // Slightly higher priority
	SetFocus(hWnd);                 // Sets keyboard focus to the window
	ReSizeGLScene(width, height);   // Set up our perspective GL screen

	if (!InitGL())                  // Initialize our newly created GL window
	{
		KillGLWindow();         // Reset the display
		MessageBox(NULL,"Initialization failed.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return false;           // Return FALSE
	}

	return true;                    // Success
}

LRESULT CALLBACK WndProc(HWND hWnd,     // Handle for this window
                        UINT uMsg,      // Message for this window
			WPARAM wParam,  // Additional message information
			LPARAM lParam)  // Additional message information
{
	switch (uMsg)                           // Check for windows messages
	{
		case WM_ACTIVATE:               // Watch for window activate message
		{
			if (!HIWORD(wParam))    // Check minimization state
			{
				active = true;  // Program is active
			}
			else
			{
				active = false; // Program is no longer active
			}

			return 0;               // Return to the message loop
		}

		case WM_SYSCOMMAND:             // Intercept system commands
		{
			switch (wParam)         // Check system calls
			{
				case SC_SCREENSAVE:     // Screensaver trying to start?
				case SC_MONITORPOWER:	// Monitor trying to enter powersave?
				return 0;       // Prevent from happening
			}
			break;                  // Exit
		}

		case WM_CLOSE:                  // Did we receive a close message?
		{
			PostQuitMessage(0);     // Send a quit message
			return 0;               // Jump back
		}

		case WM_KEYDOWN:                // Is a key being held down?
		{
			keys[wParam] = true;    // If so, mark it as TRUE
			return 0;               // Jump back
		}

		case WM_KEYUP:                  // Has a key been released?
		{
			keys[wParam] = false;   // If so, mark it as FALSE
			return 0;               // Jump back
		}

		case WM_SIZE:                   // Resize the OpenGL window
		{
			ReSizeGLScene(LOWORD(lParam),HIWORD(lParam));  // LoWord = Width, HiWord = Height
			return 0;               // Jump back
		}
	}

	// Pass all unhandled messages to DefWindowProc
	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}

WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
        MSG msg;                // Windows message structure
	bool done = false;      // Bool variable to exit loop

	// Ask the user which screen mode they prefer
	if (MessageBox(NULL,"Would you like to run in fullscreen mode?", "Start FullScreen?",MB_YESNO|MB_ICONQUESTION)==IDNO)
	{
		fullscreen = false;       // Windowed mode
	}

	// Create our OpenGL window
	if (!CreateGLWindow("Alfredo's Radiosity",640,480,16,fullscreen))
	{
		return 0;               // Quit if window was not created
	}

	while(!done)            // Loop that runs while done = FALSE
	{
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))	// Is there a message waiting?
		{
			if (msg.message == WM_QUIT)             // Have we received a quit message?
			{
				done = true;                    // If so done = TRUE
			}
			else                                    // If not, deal with window messages
			{
				TranslateMessage(&msg);         // Translate the message
				DispatchMessage(&msg);          // Dispatch the message
			}
		}
		else            // If there are no messages
		{
			
			// Draw the scene.  Watch for ESC key and quit messages from DrawGLScene()
			if ((active && !DrawGLScene()) || keys[VK_ESCAPE])	// Active?  Was there a quit received?
			{
				done = true;                    // ESC or DrawGLScene signalled a quit
			}
			else                                    // Not time to quit, update screen
			{
				SwapBuffers(hDC);               // Swap buffers (double buffering)
				if (keys['B'] && !bp)
				{
					bp = true;
					blend = !blend;
					if (!blend)
					{
						glDisable(GL_BLEND);
						glEnable(GL_DEPTH_TEST);
					}
					else
					{
						glEnable(GL_BLEND);
						glDisable(GL_DEPTH_TEST);
					}
				}
				if (!keys['B'])
				{
					bp = false;
				}

				if (keys['F'] && !fp)
				{
					fp = true;
					filter+=1;
					if (filter>2)
					{
						filter=0;
					}
				}
				if (!keys['F'])
				{
					fp = false;
				}
				if (keys['R'] && !rad){
					rad = true;
					Radiosity();
				}		
				if (!keys['R']){
					rad = false;
				}
				if (keys[VK_PRIOR])
				{
					z-=0.02f;
				}

				if (keys[VK_NEXT])
				{
					z+=0.02f;
				}

				if (keys[VK_UP])
				{

					xpos -= (float)sin(heading*piover180) * 0.05f;
					zpos -= (float)cos(heading*piover180) * 0.05f;
					if (walkbiasangle >= 359.0f)
					{
						walkbiasangle = 0.0f;
					}
					else
					{
						walkbiasangle+= 10;
					}
					walkbias = (float)sin(walkbiasangle * piover180)/20.0f;
				}

				if (keys[VK_DOWN])
				{
					xpos += (float)sin(heading*piover180) * 0.05f;
					zpos += (float)cos(heading*piover180) * 0.05f;
					if (walkbiasangle <= 1.0f)
					{
						walkbiasangle = 359.0f;
					}
					else
					{
						walkbiasangle-= 10;
					}
					walkbias = (float)sin(walkbiasangle * piover180)/20.0f;
				}

				if (keys[VK_RIGHT])
				{
					heading -= 1.0f;
					yrot = heading;
				}

				if (keys[VK_LEFT])
				{
					heading += 1.0f;	
					yrot = heading;
				}

				if (keys[VK_PRIOR])
				{
					lookupdown-= 1.0f;
				}

				if (keys[VK_NEXT])
				{
					lookupdown+= 1.0f;
				}

				if (keys[VK_F1])			// Is F1 neing pressed?
				{
					keys[VK_F1] = false;		// If so make key FALSE
					KillGLWindow();			// Kill our current window
					fullscreen = !fullscreen;	// Toggle fullscreen / windowed mode
					// Recreate our OpenGL window
					if (!CreateGLWindow("Alfredo's Radiosity",640,480,16,fullscreen))
					{
						return 0;       // Quit if window was not created
					}
				}
			}
		}
	}

	// Shutdown
	KillGLWindow();         // Kill the window
	return (msg.wParam);    // Exit the program
}
//---------------------------------------------------------------------------
