/******************************************
GLUTRAD
Copyright, 1998, Colbeck Desktop Solutions Ltd
contact: colbeck@cix.co.uk
******************************************/
#ifndef __POLIGONO_H
	#define __POLIGONO_H

#include <math.h>

//#define max(a, b)  (((a) > (b)) ? (a) : (b)) 


class Tpol{
public:
	Tvertex a, b, c;
	Tpol() {}

	Tpol(Tvertex A, Tvertex B, Tvertex C){
		a = A;
		b = B;
		c = C;
	}

	double[] Center(Tpol pol){
		double aux[3];
		aux[0]=(a->v1+a->v2+a->v3)/3;
		aux[1]=(b->v1+b->v2+b->v3)/3;
		aux[2]=(c->v1+c->v2+c->v3)/3;
	}
}
/*
class TColour
{
public:
	double r, g, b;
	TColour()
	{
		r=g=b=0.0;
	}
	void Set(double red, double green, double blue)
	{
		r=red; g=green; b=blue;
	}
	void Set(TColour c)
	{
		r=c.r; g=c.g; b=c.b;
	}
	double Sum()
	{
		return r+b+g;
	}
	void ConvertToColour()
	{
		double limit=max(max(r, g), max(b, 1.0));
		r/=limit; g/=limit; b/=limit; 
	}
	void Scale(double factor)
	{
		r=r*factor; g=g*factor; b=b*factor;
	}
};

class TVector
{
public:
	TVector()
	{
		x=y=z=0.0;
	}
	TVector(TVector& v)
	{
		x=v.x; y=v.y; z=v.z;
	}
	TVector(double a, double b, double c)
	{
		x=a; y=b; z=c;
	}
	void Set(double a, double b, double c)
	{
		x=a; y=b; z=c;
	}
	void Set(TVector a)
	{
		x=a.x; y=a.y; z=a.z;
	}
	double x, y, z;
	void operator =(const TVector& a);
	int operator ==(TVector& a);
	int operator !=(TVector& a);
	TVector operator -(TVector& a) const;
	TVector operator +(TVector& a) const;
	TVector operator /(double a) const;
	TVector operator *(double a) const;

	void operator /=(double a)
	{
		x/=a; y/=a; z/=a;
	}

	TVector GetDirection()
	{
		TVector result;
		double mag=this->mag();
		result.x=x/mag; result.y=y/mag; result.z=z/mag;
		return result;
	}
	TVector Inverse()
	{
		TVector result;
		result.x=-x; result.y=-y; result.z=-z;
		return result;
	}
	double Normalise()
	{
		double m=mag();
		x=x/m; y=y/m; z=z/m;
		return m;
	}
	double mag() const
	{
		return sqrt(x*x + y*y + z*z);
	}
	double dot(TVector v)
	{
		return (x*v.x + y*v.y + z*v.z);
	}
	TVector cross(TVector v)
	{
		TVector result(y*v.z-z*v.y, z*v.x-x*v.z, x*v.y-y*v.x);
		return result;
	}
	double Angle(TVector v2); // Return the angle between two vectors
	double NormaliseAngle (TVector v); // this procedure normalises the vectors regardless
};

struct TTriangleLink
{
	TTriangle *t; 
	TTriangleLink *next;
	TTriangleLink(TTriangle* tri)
	{
		t=tri; next=0;
	}
};

class TVertex
{
public:
	TVector v;
	TVector d;
	TColour energy;
	int count;
	TTriangleLink *user, *user_head;
	void AddUser(TTriangle* tri)
	{
		if(user_head)
		{
			user->next=new TTriangleLink(tri);
			user=user->next;
		}
		else
		{
			user_head=new TTriangleLink(tri);
			user=user_head;
		}
	}
	TVertex()
	{
		count=0; user_head=0;
		d.Set(0, 0, 0);
	}
	TVertex(TVector a, TVector b)
	{
		count=0; user_head=0;
		v=a; d=b;
	}
	~TVertex()
	{
		TTriangleLink *tl=user_head;
		while(tl)
		{
			user=tl->next;
			delete tl;
			tl=user;
		}
	}
	TVertex& operator =(TVertex& vt)
	{
		v=vt.v; d=vt.d;
		return *this;
	}
	void Set(TVector a, TVector b)
	{
		v=a; d=b;
	}
	void Set(TVector a, int val)
	{
		v=a; d.Set(val, val, val);
	}
	void ResetDirection()
	{
		d.Set(0.0, 0.0, 0.0); count=0;
	}
};

class TTriangle 
{
public:
	TTriangle()
	{
		ff=0; 
	}
	void Set(TVertex* a, TVertex* b, TVertex* c, int i0, int i1, int i2)
	{
		V[0]=a; V[1]=b; V[2]=c;
		index[0]=i0; index[1]=i1; index[2]=i2;
	}
	void Set(TVertex* a, TVertex* b, TVertex* c)
	{
		V[0]=a; V[1]=b; V[2]=c;
	}
	TVertex* V[3];
	int index[3]; // index of the vertex in the object's list
	TVector N;
	TVector centre;
	double area;
	TColour energy, emission, unshot;
	double ff; // form factor

	TVector GetNormal()
	{
		N.x=V[0]->v.y*(V[1]->v.z-V[2]->v.z)+V[1]->v.y*(V[2]->v.z-V[0]->v.z)+V[2]->v.y*(V[0]->v.z-V[1]->v.z);
		N.y=V[0]->v.z*(V[1]->v.x-V[2]->v.x)+V[1]->v.z*(V[2]->v.x-V[0]->v.x)+V[2]->v.z*(V[0]->v.x-V[1]->v.x);
		N.z=V[0]->v.x*(V[1]->v.y-V[2]->v.y)+V[1]->v.x*(V[2]->v.y-V[0]->v.y)+V[2]->v.x*(V[0]->v.y-V[1]->v.y);
		double mag=N.mag();
		N.x/=mag; N.y/=mag; N.z/=mag;
		return N;
	}
	double CalcArea()
	{
		TVector a(V[1]->v.x-V[0]->v.x, V[1]->v.y-V[0]->v.y, V[1]->v.z-V[0]->v.z);
		TVector b(V[2]->v.x-V[0]->v.x, V[2]->v.y-V[0]->v.y, V[2]->v.z-V[0]->v.z);
		TVector temp = a.cross(b);
		area = temp.mag()/2.0;
		return area;
	}
	void CalcCentre()
	{
		centre.Set(0.0, 0.0, 0.0);
		for (int i=0; i < 3; i++)
		{
			centre.x += V[i]->v.x; centre.y += V[i]->v.y; centre.z += V[i]->v.z;
		}
		centre.x /= 3; centre.y /= 3; centre.z /= 3;
	}
};
*/
#endif
