/*	Clase Auxiliar 2 CC52B
 *  Alfredo Cofr E.
 *  Java 3D
 *
 */ 

import java.applet.Applet;
import java.awt.Frame;
import java.awt.*;
import com.sun.j3d.utils.universe.*;	//Clase que contiene a SimpleUniverse
import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.ColorCube;
import javax.media.j3d.*;
import javax.vecmath.*;


public class  HolaJava3d4 extends Applet{
	public HolaJava3d4(){
		setLayout(new BorderLayout());				//Layout de la applet
		Canvas3D canvas3d = new Canvas3D(null);		//Creamos un nuevo canvas
		add("Center",canvas3d);						//Agregamos el canvas al cuerpo de la applet
		BranchGroup scene = createSceneGraph();		//Nueva escena
		scene.compile();							//Compilamos la escena
		
		//Creamos el SimpleUniverse
		SimpleUniverse universo = new SimpleUniverse(canvas3d);

		/*Configuramos la vista grfica seteando la distancia nominal de la vista
		  a aproximadamente 2.42 metros en la vista de tranformaciones de universo.
		  getViewingPlatform es una funcin de la clase SimpleUniverse
		 */

		universo.getViewingPlatform().setNominalViewingTransform();
		universo.addBranchGraph(scene);			//Agregamos nuestro SimpleUniverse a la escena
	}

	public BranchGroup createSceneGraph(){
		//Creamos la raz del rbol
		BranchGroup raiz = new BranchGroup();

		//Creamos una rotacin, la inicializamos con la identidad, y
		//la agregamos a la raz
		TransformGroup rotacion = new TransformGroup();
		rotacion.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		raiz.addChild(rotacion);
		
		//Creamos un nodo hoja y lo agregamos a rbol de escena
		rotacion.addChild(new ColorCube(0.4));

		//Creamos una funcin del tiempo que maneja la animacin
		Alpha rotacionAlfa = new Alpha(-1,4000);

		//Creamos el comportamiento del objeto
		RotationInterpolator rotador = new RotationInterpolator(rotacionAlfa, rotacion);

		//Especificamos la esfera donde el comportamiento est activo.
		BoundingSphere limite = new BoundingSphere();
		rotador.setSchedulingBounds(limite);

		rotacion.addChild(rotador);
		return raiz;
	}

	public static void main(String[] args){
		Frame frame = new MainFrame(new HolaJava3d4(), 256, 256);
	}
}
