package dcc.cc51t.ejemplo2;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GuardaPersona extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Constructor of the object.
	 */
	public GuardaPersona() {
		super();
	}

	/**
	 * Destruction of the servlet. <br>
	 */
	public void destroy() {
		super.destroy(); // Just puts "destroy" string in log
		// Put your code here
	}

	/**
	 * The doGet method of the servlet. <br>
	 * 
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request
	 *            the request send by the client to the server
	 * @param response
	 *            the response send by the server to the client
	 * @throws ServletException
	 *             if an error occurred
	 * @throws IOException
	 *             if an error occurred
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		response.setContentType("text/html");
		PrintWriter out = response.getWriter();
		out
				.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
		out.println("<HTML>");
		out.println("  <HEAD><TITLE>A Servlet</TITLE></HEAD>");
		out.println("  <BODY>");
		out.print("    This is ");
		out.print(this.getClass());
		out.println(", using the GET method");
		out.println("  </BODY>");
		out.println("</HTML>");
		out.flush();
		out.close();
	}

	/**
	 * The doPost method of the servlet. <br>
	 * 
	 * This method is called when a form has its tag value method equals to
	 * post.
	 * 
	 * @param request
	 *            the request send by the client to the server
	 * @param response
	 *            the response send by the server to the client
	 * @throws ServletException
	 *             if an error occurred
	 * @throws IOException
	 *             if an error occurred
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		Connection con = null;
		String mensaje = "";
		try {
			Class.forName("com.mysql.jdbc.Driver");
			con = DriverManager.getConnection("jdbc:mysql://localhost/example",
					"example", "example");
			con.setAutoCommit(false);
			
			PreparedStatement pst = con.prepareStatement("INSERT INTO people "
					+ "(lastname, firstname, id, postal_code, age, sex) "
					+ "VALUES " + "(?,?,?,?,?,?)");

			if (request.getParameter("lastname") != null)
				pst.setString(1, request.getParameter("lastname"));
			else
				pst.setNull(1, java.sql.Types.VARCHAR);

			pst.setString(2, request.getParameter("firstname"));
			pst.setInt(3, Integer.parseInt(request.getParameter("id")));
			pst.setString(4, request.getParameter("postal_code"));
			pst.setInt(5, Integer.parseInt(request.getParameter("age")));
			pst.setString(6, request.getParameter("sex"));

			try {
				int rs = pst.executeUpdate();
				if (rs == 1)
					mensaje = "Insertada nueva persona";
			} catch (SQLException s) {
				mensaje = "Error al insertar : " + s.getLocalizedMessage();
			}
			// obtener listado de personas
			PreparedStatement pstSelect = con
					.prepareStatement("SELECT lastname, firstname, id, postal_code, age, sex "
							+ "FROM " + "people");
			ResultSet rsSelect = pstSelect.executeQuery();
			ArrayList<Persona> parray = new ArrayList<Persona>();
			while (rsSelect.next()) {
				Persona p = new Persona();
				p.setLastname(rsSelect.getString(1));
				p.setFirstname(rsSelect.getString(2));
				p.setId(rsSelect.getInt(3));
				p.setPostal_code(rsSelect.getInt(4));
				p.setAge(rsSelect.getInt(5));
				p.setSex(rsSelect.getString(6));
				parray.add(p);
			}
			rsSelect.close();
			pstSelect.close();
			request.setAttribute("personas", parray);
			con.commit();
		} catch (Exception e) {
			e.printStackTrace();
			mensaje = "Error! : " + e.getLocalizedMessage();
		} finally {
			try {
				con.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}

		request.setAttribute("mensaje", mensaje);
		getServletContext().getRequestDispatcher("/index.jsp").forward(request,
				response);
	}

	/**
	 * Initialization of the servlet. <br>
	 * 
	 * @throws ServletException
	 *             if an error occurs
	 */
	public void init() throws ServletException {
		// Put your code here
	}

}
