#lang plai

(define-type Expr
  (num (n number?))
  (add (l Expr?) (r Expr?))
  (sub (l Expr?) (r Expr?))
  (mul (l Expr?) (r Expr?)))

;(+ (- 3 4) 2)
;--> (add (sub (num 3) (num 4)) (num 2))

;; parse :: s-expr -> Expr
(define (parse sexp)
  (cond
    ((number? sexp) (num sexp))
    ((list? sexp) 
     ((case (first sexp)  ;; usando el hecho de que las funciones 
        ((+) add)         ;; son valores 
        ((-) sub)
        ((*) mul))
      (parse (second sexp))
      (parse (third sexp))))))
     
(test (parse 3) (num 3))
(test (parse '(+ 1 2))
      (add (num 1) (num 2)))
(test (parse '(+ (- 1 2) 3))
      (add (sub (num 1) (num 2)) (num 3)))
(test (parse '(+ (* 1 2) 3))
      (add (mul (num 1) (num 2)) (num 3)))


;; calc :: Expr -> number
(define (calc expr)
  (type-case Expr expr
    (num (val) val)
    (add (l r) (+ (calc l) (calc r)))
    (sub (l r) (- (calc l) (calc r)))
    (mul (l r) (* (calc l) (calc r)))))

(test (calc (parse 3)) 3)
(test (calc (parse '(+ 1 2))) 3)
(test (calc (parse '(+ (- 1 2) 3))) 2)
(test (calc (parse '(+ (* 1 2) 3))) 5)
