#####################################################################
# CC3501-1
#####################################################################

import pygame
from pygame.locals import *
from OpenGL.GL import *
from OpenGL.GLU import *
from math import *
from Vector3D import *

#####################################################################

class Eje:
    def __init__(self, largo):
        self.largo =  largo

    def mover(self,dt):
        a=0
        
    def dibujar(self):
        if control.verSR:
            # almaceno la matriz, para aplicar los cambios solo sobre el Eje
            glPushMatrix()
            glBegin(GL_LINES)
            # eje Y verde
            glColor4f( 0.0,   1.0, 0.0, 1.0)
            glVertex4f(0.0, self.largo, 0.0, 1.0)
            glVertex4f(0.0,   0.0, 0.0, 1.0)
            # eje x rojo
            glColor4f( 1.0  , 0.0, 0.0, 1.0)
            glVertex4f(0.0  , 0.0, 0.0, 1.0)
            glVertex4f(self.largo, 0.0, 0.0, 1.0)
            #eje z azul
            glColor4f( 0.0, 0.0, 1.0, 1.0)
            glVertex4f(0.0, 0.0,   0.0, 1.0)
            glVertex4f(0.0, 0.0, self.largo, 1.0)
            glEnd()
            #importante, recupero la matriz!
            glPopMatrix()

class Cilindro:
    def __init__(self):
        # crea lista y almacena el dibujo en ella, para no repetir calculos
        self.lista = 0
        self.crear()
        
        self.rgb = [1,1,1,1] # color del cilindro, considera transparencia
        
        self.dim = Vector(1.0,1.0,1.0) # dimensiones: ancho, alto y profundidad
        self.pos = Vector(0.0,0.0,0.0) # posicion 
        self.ang = Vector(0.0,0.0,0.0) # rotacion c/r a cada eje.

    def crear(self):
        a=Vector( 0.0, 0.0, 0.5)
        d=Vector( 0.0, 0.0,-0.5)

        #iniciar lista
        self.lista = glGenLists(1)
        glNewList(self.lista,GL_COMPILE)

        #configuracion de material
        glMaterial(GL_FRONT_AND_BACK, GL_SPECULAR, [0.01, 0.01, 0.01])
        glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE)
        glEnable(GL_COLOR_MATERIAL)

        #inicia el dibujo, setea modo de dibujo
        glBegin(GL_TRIANGLES)
        
        ang=0.0 # angulo de esta iteracion
        dang=2*pi/10.0  # angulo de la iteracion siguiente

        #se va rotando dibujando una parte del cilindro
        while ang<=2*pi:
            #definiendo puntos a conectar
            # se usa notacion cilindrica -> rho,fi,z
            b=VectorCilindricas(0.5,ang, 0.5)
            c=VectorCilindricas(0.5,ang+dang,0.5)
            f=VectorCilindricas(0.5,ang,-0.5)
            e=VectorCilindricas(0.5,ang+dang,-0.5)

            # se conectan los puntos con 2 triangulos y 1 cuadrilatero
            dibujarTriangulo(a,b,c)
            dibujarTriangulo(d,e,f)
            dibujarCuadrilatero(c,b,f,e)

            #avanzo la iteracion, girando el angulo de referencia a siguiente
            ang=ang+dang

        #termina el dibujo
        glEnd()
        #terminar lista
        glEndList()

    def dibujar(self):
        #respaldo el sistema de referencia
        glPushMatrix()

        #efectuo transformaciones 
        glTranslatef(self.pos.x,self.pos.y,self.pos.z)
        glRotatef   (self.ang.x,1,0,0)
        glRotatef   (self.ang.y,0,1,0)
        glRotatef   (self.ang.z,0,0,1)
        glScalef    (self.dim.x,self.dim.y,self.dim.z)

        #setea color
        glColor4fv(self.rgb)

        #dibuja el contenido de la lista
        glCallList(self.lista)

        #reestablece el sistema de referencia anterior
        glPopMatrix()

    def mover(self,dt):
        # accede a las variables de control...
        # con UP y DOWN modifico la transparencia del cilindro
        if control.up:
            self.rgb[3]=self.rgb[3]+dt/100.0
            if self.rgb[3]>1:
                self.rgb[3]=1
        if control.down:
            self.rgb[3]=self.rgb[3]-dt/100.0
            if self.rgb[3]<0:
                self.rgb[3]=0
                
        #modifica el angulo con respecto al eje x
        self.ang=sumar(self.ang,Vector(dt,0,0))

        #modifica el angulo con respecto al eje x e y
        #self.ang=sumar(self.ang,Vector(dt,2*dt,0))

class Botella2:
    def __init__(self,dim):      
        self.rgb = [1,1,1,1] # color, considera transparencia
        
        self.dim = dim # dimensiones: ancho, alto y profundidad
        self.pos = Vector(0.0,0.0,0.0) # posicion 
        self.ang = Vector(0.0,0.0,0.0) # rotacion c/r a cada eje.

        # crea lista y almacena el dibujo en ella, para no repetir calculos
        self.lista = 0
        self.crear()

    def crear(self):
        #iniciar lista
        self.lista = glGenLists(1)
        glNewList(self.lista,GL_COMPILE)

        glEnable(GL_COLOR_MATERIAL)
        glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE)
        glMaterialfv(GL_FRONT, GL_SPECULAR, [  1.0,   1.0,   1.0])
        glMaterialfv(GL_FRONT, GL_SHININESS, [30.0])

        #configuracion de material

        no_mat			= [ 0.0, 0.0, 0.0, 1.0 ]
        mat_ambient		= [ 0.7, 0.7, 0.7, 1.0 ]
        mat_ambient_color	= [ 0.8, 0.8, 0.2, 1.0 ]
        mat_diffuse		= [ 0.1, 0.5, 0.8, 1.0 ]
        mat_specular		= [ 1.0, 1.0, 1.0, 1.0 ]
        no_shininess		= [ 0 ]
        low_shininess		= [ 5 ]
        high_shininess		= [ 10 ]
        mat_emission		= [0.4, 0.2, 0.2, 0.0]

##        glMaterialfv(GL_FRONT, GL_AMBIENT, [0.2,0.2,0.2,1.0])
##        glMaterialfv(GL_FRONT, GL_DIFFUSE, [0.8, 0.8, 0.8, 1.0])
##        glMaterialfv(GL_FRONT, GL_SPECULAR, [0, 0, 0, 1])
##        glMaterialiv(GL_FRONT, GL_SHININESS, [0])
##        glMaterialfv(GL_FRONT, GL_EMISSION, [0, 0, 0, 1])

        glMaterialfv(GL_FRONT, GL_AMBIENT, no_mat)
        glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_diffuse)
        glMaterialfv(GL_FRONT, GL_SPECULAR, no_mat)
        glMaterialiv(GL_FRONT, GL_SHININESS, no_shininess)
        glMaterialfv(GL_FRONT, GL_EMISSION, no_mat)

##        glMaterialfv(GL_FRONT, GL_AMBIENT, no_mat)
##        glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_diffuse)
##        glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular)
##        glMaterialiv(GL_FRONT, GL_SHININESS, low_shininess)
##        glMaterialfv(GL_FRONT, GL_EMISSION, no_mat)

##        glMaterialfv(GL_FRONT, GL_AMBIENT, no_mat)
##        glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_diffuse)
##        glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular)
##        glMaterialiv(GL_FRONT, GL_SHININESS, high_shininess)
##        glMaterialfv(GL_FRONT, GL_EMISSION, no_mat)

##        glMaterialfv(GL_FRONT, GL_AMBIENT, no_mat)
##        glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_diffuse)
##        glMaterialfv(GL_FRONT, GL_SPECULAR, no_mat)
##        glMaterialiv(GL_FRONT, GL_SHININESS, no_shininess)
##        glMaterialfv(GL_FRONT, GL_EMISSION, mat_emission)

##        glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE)
##        glEnable(GL_COLOR_MATERIAL)

        #inicia el dibujo, setea modo de dibujo
        glBegin(GL_TRIANGLES)
        
        ang=0.0 # angulo de esta iteracion
        dang=2*pi/50.0  # angulo de la iteracion siguiente

        r=self.dim.rho()
        z=self.dim.z

        a=Vector( 0.0, 0.0, 1.0*z)
        j=Vector( 0.0, 0.0, 0.0)

        #se va rotando dibujando una parte del cilindro
        while ang<=2*pi:
            #definiendo puntos a conectar
            # se usa notacion cilindrica -> rho,fi,z
            b=VectorCilindricas(0.2*r,ang, 1.0*z)
            c=VectorCilindricas(0.2*r,ang+dang,1.0*z)
            
            d=VectorCilindricas(0.2*r,ang, 0.8*z)
            e=VectorCilindricas(0.2*r,ang+dang, 0.8*z)
            
            f=VectorCilindricas(0.5*r,ang, 0.6*z)
            g=VectorCilindricas(0.5*r,ang+dang, 0.6*z)
            
            h=VectorCilindricas(0.5*r,ang, 0.0)
            i=VectorCilindricas(0.5*r,ang+dang, 0.0)

            # se conectan los puntos con 2 triangulos y 1 cuadrilatero
            dibujarTriangulo(a,b,c)
            dibujarCuadrilatero(c,b,d,e)
            dibujarCuadrilatero(e,d,f,g)
            dibujarCuadrilatero(g,f,h,i)
            dibujarTriangulo(h,j,i)

            #avanzo la iteracion, girando el angulo de referencia a siguiente
            ang=ang+dang

        #termina el dibujo
        glEnd()
        #terminar lista
        glEndList()

    def dibujar(self):
        #respaldo el sistema de referencia
        glPushMatrix()

        #efectuo transformaciones 
        glTranslatef(self.pos.x,self.pos.y,self.pos.z)
        glRotatef   (self.ang.x,1,0,0)
        glRotatef   (self.ang.y,0,1,0)
        glRotatef   (self.ang.z,0,0,1)
        # no se escala pues el dibujo se construyo en el tamano correcto
        #glScalef    (self.dim.x,self.dim.y,self.dim.z)

        #setea color
        glColor4fv(self.rgb)

        #dibuja el contenido de la lista
        glCallList(self.lista)

        #reestablece el sistema de referencia anterior
        glPopMatrix()

    def mover(self,dt):
        # accede a las variables de control...
        # con UP y DOWN modifico el angulo de la botella
        if control.up:
            #modifica el angulo con respecto al eje y
            self.ang=sumar(self.ang,Vector(0,dt,0))
        if control.down:
            #modifica el angulo con respecto al eje y
            self.ang=sumar(self.ang,Vector(0,-dt,0))
        

#####################################################################

#entregar puntos segun regla de mano derecha
def dibujarTriangulo(p1,p2,p3):
    glNormal3fv(normal(p1,p2,p3).cartesianas())
    glVertex3fv(p1.cartesianas())
    glVertex3fv(p2.cartesianas())
    glVertex3fv(p3.cartesianas())

def dibujarCuadrilatero(p1,p2,p3,p4):
    dibujarTriangulo(p1,p4,p3)
    dibujarTriangulo(p3,p2,p1)

#####################################################################

class Control:
    def __init__(self):
        # variables de control. La idea es utilizar una por tecla...
        self.up = False
        self.down = False
        self.left = False
        self.right = False
        self.wireframe = False
        self.verSR = True

class Camara:
    def __init__(self):
        # configuracion de camara, vista inicial
        self.eye = Vector(200.0,200.0,200.0)
        self.at = Vector(0.0, 0.0, 0.0)
        self.up = Vector(0.0, 0.0, 1.0)

##        self.eye = Vector(1500.0,pi/2,2*pi/3)
##        self.at = Vector(0.0, 0.0, 100.0)
##        self.up = Vector(0.0, 0.0, 1.0)

    def mover(self,dt):

        if control.left:
            #roto el ojo en torno al eje z
            self.eye=rotarFi(self.eye,dt*0.03)
        if control.right:
            #roto el ojo en torno al eje z
            self.eye=rotarFi(self.eye,-dt*0.03)
        
        glLoadIdentity()
        gluLookAt(self.eye.x,self.eye.y,self.eye.z,
              self.at.x,self.at.y,self.at.z,
              self.up.x,self.up.y,self.up.z)

    def dibujar(self):
        a=0

#####################################################################
# Funciones de graficos
#####################################################################

def reshape((width, height)):
    if height == 0:
        height = 1
    glViewport(0, 0, width, height)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()

    # establecer tipo de proyeccion: perspectiva u ortogonal
    gluPerspective(45, float(width)/float(height),1, 2000.0)
    #glOrtho(-w,w,-h,h,1,2000)
    
    glMatrixMode(GL_MODELVIEW)

def init():
    glClearColor(0.0, 0.0, 0.0, 0.0)
    glShadeModel(GL_SMOOTH)
    glClearDepth(1.0)
    glEnable(GL_DEPTH_TEST)
    glDepthFunc(GL_LEQUAL)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST)

    # habilita iluminacion
    glEnable(GL_LIGHTING)

    # agrega una fuente de luz y la configura
    glEnable(GL_LIGHT0)
    glLightfv(GL_LIGHT0, GL_POSITION, [-1000.0 , -1500.0 , -1500.0 , 1.0])
    glLightfv(GL_LIGHT0, GL_SPECULAR, [  1.0,   1.0,   1.0])
    glLightfv(GL_LIGHT0, GL_AMBIENT,  [ 0.1, 0.1, 0.1])
	
##    glEnable(GL_LIGHT1)
##    glLightfv(GL_LIGHT1, GL_POSITION, [ 700, 700.0, 700.0, 1.0])
##    
##    glLightfv(GL_LIGHT1, GL_SPECULAR, [ 10, 10, 10])
##    glLightfv(GL_LIGHT1, GL_DIFFUSE,  [ 200, 200.0, 200.0, 1.0])

    #se habilitan las transparencias
    glEnable(GL_BLEND)
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)

    # el color debe incluir la cuarta componente, alpha
    # alpha=1  --> objeto totalmente opaco
    # alpha=0  --> opbjeto totalmente transparente

#####################################################################

def accion(dt):
    # limpia la escena
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_ACCUM_BUFFER_BIT | GL_STENCIL_BUFFER_BIT)
    glClearDepth(1.0)

    # establece modo de dibujo
    if control.wireframe:
        # malla de alambre
        glPolygonMode(GL_FRONT, GL_LINE)
        glPolygonMode(GL_BACK, GL_LINE)
    else:
        # "normal"
        glPolygonMode(GL_FRONT, GL_FILL)
        glPolygonMode(GL_BACK, GL_FILL)

    # cada objeto en la lista se mueve y dibuja
    for f in fs:
        f.mover(dt)
        f.dibujar()
        #eventualmente se deberia detectar interacciones
        
#####################################################################
# Programa principal
#####################################################################

def main(argv):

    # visibles en todo el archivo
    global h,w,fs,control

    w=640 #ancho de ventana
    h=480 #alto de ventana

    #encapsula las instrucciones de control posibles
    control=Control()

    #para encapsular las variables de la camara
    camara=Camara()

    #para visualizar el eje del SR
    eje=Eje(100000)

    # genera ventana con pygame
    pygame.init()
    pygame.display.set_mode((w,h), HWSURFACE | OPENGL | DOUBLEBUF)
    pygame.display.set_caption("Botella 2")

    # lista con todos los actores de la escena
    fs=[camara,eje]

    # crear una botella del tamano especificado
    c=Botella2(Vector(40,40,150))
    c.rgb=[1,0,0,1] # asigna color azul
    c.pos=Vector(1,1,0) # setea posicion 
    fs=fs+[c] # agrega a la lista de actores

    # inicializa y configura OpenGL
    reshape((w,h))
    init()

    # tiempo inicial de una iteracion
    t0=pygame.time.get_ticks()

    run=True
    while run: # iteracion
        
        # tiempo final de una iteracion
        t1=pygame.time.get_ticks()

        # detectar eventos...
        for event in pygame.event.get():

            # cerrar ventana
            if event.type == QUIT:
                run=False

            # presionar tecla
            if event.type == KEYDOWN:
                if event.key == K_ESCAPE:
                    run=False
                if event.key == K_w:
                    control.wireframe = not control.wireframe
                if event.key == K_s:
                    control.verSR = not control.verSR
                if event.key == K_UP:
                    control.up = True
                if event.key == K_DOWN:
                    control.down = True
                if event.key == K_LEFT:
                    control.left = True
                if event.key == K_RIGHT:
                    control.right = True

            # soltar tecla
            if event.type == KEYUP:
                if event.key == K_UP:
                    control.up = False
                if event.key == K_DOWN:
                    control.down = False
                if event.key == K_LEFT:
                    control.left = False
                if event.key == K_RIGHT:
                    control.right = False

        # mueve los objetos, efectua interacciones y dibuja el frame
        accion((t1-t0)/10.0)
        #fija el tiempo inicial de la sgte iteracion
        t0=t1
        #actualiza la escena
        pygame.display.flip()
        # ajustar a 30 fps
        pygame.time.wait(1000/30) 

    # una vez fuera del loop cierra la ventana
    pygame.quit()
    
if __name__ == "__main__":
    import sys
    main(sys.argv)

#####################################################################
