#####################################################################
# CC3501-1
#####################################################################

import pygame
from pygame.locals import *
from OpenGL.GL import *
from OpenGL.GLU import *
from math import *
from Vector3D import *

#####################################################################

class Eje:
    def __init__(self, largo):
        self.largo =  largo

    def mover(self,dt):
        a=0
        
    def dibujar(self):
        if verSR:
            # almaceno la matriz, para aplicar los cambios solo sobre el Eje
            glPushMatrix()
            glBegin(GL_LINES)
            # eje Y verde
            glColor4f( 0.0,   1.0, 0.0, 1.0)
            glVertex4f(0.0, self.largo, 0.0, 1.0)
            glVertex4f(0.0,   0.0, 0.0, 1.0)
            # eje x rojo
            glColor4f( 1.0  , 0.0, 0.0, 1.0)
            glVertex4f(0.0  , 0.0, 0.0, 1.0)
            glVertex4f(self.largo, 0.0, 0.0, 1.0)
            #eje z azul
            glColor4f( 0.0, 0.0, 1.0, 1.0)
            glVertex4f(0.0, 0.0,   0.0, 1.0)
            glVertex4f(0.0, 0.0, self.largo, 1.0)
            glEnd()
            #importante, recupero la matriz!
            glPopMatrix()

class Cilindro:
    def __init__(self):
        # crea lista y almacena el dibujo en ella, para no repetir calculos
        self.lista = 0
        self.crear()
        
        self.rgb = [1,1,1,1] # color del cilindro, considera transparencia
        
        self.dim = Vector(1.0,1.0,1.0) # dimensiones: ancho, alto y profundidad
        self.pos = Vector(0.0,0.0,0.0) # posicion 
        self.ang = Vector(0.0,0.0,0.0) # rotacion c/r a cada eje.

    def crear(self):
        a=Vector( 0.0, 0.0, 0.5)
        d=Vector( 0.0, 0.0,-0.5)

        #iniciar lista
        self.lista = glGenLists(1)
        glNewList(self.lista,GL_COMPILE)

        #configuracion de material
        glMaterial(GL_FRONT_AND_BACK, GL_SPECULAR, [0.01, 0.01, 0.01])
        glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE)
        glEnable(GL_COLOR_MATERIAL)

        #inicia el dibujo, setea modo de dibujo
        glBegin(GL_TRIANGLES)
        
        ang=0.0 # angulo de esta iteracion
        dang=2*pi/10.0  # angulo de la iteracion siguiente

        #se va rotando dibujando una parte del cilindro
        while ang<=2*pi:
            #definiendo puntos a conectar
            # se usa notacion cilindrica -> rho,fi,z
            b=VectorCilindricas(0.5,ang, 0.5)
            c=VectorCilindricas(0.5,ang+dang,0.5)
            f=VectorCilindricas(0.5,ang,-0.5)
            e=VectorCilindricas(0.5,ang+dang,-0.5)

            # se conectan los puntos con 2 triangulos y 1 cuadrilatero
            dibujarTriangulo(a,b,c)
            dibujarTriangulo(d,e,f)
            dibujarCuadrilatero(c,b,f,e)

            #avanzo la iteracion, girando el angulo de referencia a siguiente
            ang=ang+dang

        #termina el dibujo
        glEnd()
        #terminar lista
        glEndList()

    def dibujar(self):
        #respaldo el sistema de referencia
        glPushMatrix()

        #efectuo transformaciones 
        glTranslatef(self.pos.x,self.pos.y,self.pos.z)
        glRotatef   (self.ang.x,1,0,0)
        glRotatef   (self.ang.y,0,1,0)
        glRotatef   (self.ang.z,0,0,1)
        glScalef    (self.dim.x,self.dim.y,self.dim.z)

        #setea color
        glColor4fv(self.rgb)

        #dibuja el contenido de la lista
        glCallList(self.lista)

        #reestablece el sistema de referencia anterior
        glPopMatrix()

    def mover(self,dt):
        #modifica el angulo con respecto al eje x
        self.ang=sumar(self.ang,Vector(dt,0,0))

        #modifica el angulo con respecto al eje x e y
        #self.ang=sumar(self.ang,Vector(dt,2*dt,0))
        

#####################################################################

#entregar puntos segun regla de mano derecha
def dibujarTriangulo(p1,p2,p3):
    glNormal3fv(normal(p1,p2,p3).cartesianas())
    glVertex3fv(p1.cartesianas())
    glVertex3fv(p2.cartesianas())
    glVertex3fv(p3.cartesianas())

def dibujarCuadrilatero(p1,p2,p3,p4):
    dibujarTriangulo(p1,p4,p3)
    dibujarTriangulo(p3,p2,p1)

#####################################################################

class Camara:
    def __init__(self):
        # configuracion de camara, vista inicial
        self.eye = VectorEsfericas(1500.0,pi/4,pi/3)
        self.at = Vector(0.0, 0.0, 100.0)
        self.up = Vector(0.0, 0.0, 1.0)

    def mover(self,dt):
        
        glLoadIdentity()
        gluLookAt(self.eye.x,self.eye.y,self.eye.z,
              self.at.x,self.at.y,self.at.z,
              self.up.x,self.up.y,self.up.z)

    def dibujar(self):
        a=0

#####################################################################
# Funciones de graficos
#####################################################################

def reshape((width, height)):
    if height == 0:
        height = 1
    glViewport(0, 0, width, height)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()

    # establecer tipo de proyeccion: perspectiva u ortogonal
    gluPerspective(45, float(width)/float(height),1, 2000.0)
    #glOrtho(-w,w,-h,h,1,2000)
    
    glMatrixMode(GL_MODELVIEW)

def init():
    glClearColor(0.0, 0.0, 0.0, 0.0)
    glShadeModel(GL_SMOOTH)
    glClearDepth(1.0)
    glEnable(GL_DEPTH_TEST)
    glDepthFunc(GL_LEQUAL)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST)

    # habilita iluminacion
    glEnable(GL_LIGHTING)

    # agrega una fuente de luz y la configura
    glEnable(GL_LIGHT1)
    glLightfv(GL_LIGHT1, GL_POSITION, [ 700, 700.0, 700.0, 1.0])
    glLightfv(GL_LIGHT1, GL_AMBIENT,  [ 0.2, 0.2, 0.2])
    glLightfv(GL_LIGHT1, GL_SPECULAR, [ 10, 10, 10])
    glLightfv(GL_LIGHT1, GL_DIFFUSE,  [ 200, 200.0, 200.0, 1.0])

    #se habilitan las transparencias
    glEnable(GL_BLEND)
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)

    # el color debe incluir la cuarta componente, alpha
    # alpha=1  --> objeto totalmente opaco
    # alpha=0  --> opbjeto totalmente transparente

#####################################################################

def accion(dt):
    # limpia la escena
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
    glClearDepth(1.0)

    # establece modo de dibujo
    if wireframe:
        # malla de alambre
        glPolygonMode(GL_FRONT, GL_LINE)
        glPolygonMode(GL_BACK, GL_LINE)
    else:
        # "normal"
        glPolygonMode(GL_FRONT, GL_FILL)
        glPolygonMode(GL_BACK, GL_FILL)

    # cada objeto en la lista se mueve y dibuja
    for f in fs:
        f.mover(dt)
        f.dibujar()
        #eventualmente se deberia detectar interacciones
        
#####################################################################
# Programa principal
#####################################################################

def main(argv):

    # visibles en todo el archivo
    global h,w,fs,wireframe,verSR

    w=640 #ancho de ventana
    h=480 #alto de ventana

    #variables de control
    wireframe=False
    verSR=True

    #para encapsular las variables de la camara
    camara=Camara()

    #para visualizar el eje del SR
    eje=Eje(100000)

    # genera ventana con pygame
    pygame.init()
    pygame.display.set_mode((w,h), OPENGL|DOUBLEBUF)
    pygame.display.set_caption("Cilindro")

    # lista con todos los actores de la escena
    fs=[camara,eje]

    # crea 1 cilindro
    c=Cilindro()
    c.rgb=[0,0,1,1] # asigna color azul
    c.pos=Vector(0,0,0) # setea posicion 
    c.dim=Vector(150,150,300) # setea tamano
    fs=fs+[c] # agrega a la lista de actores

    # inicializa y configura OpenGL
    reshape((w,h))
    init()

    # tiempo inicial de una iteracion
    t0=pygame.time.get_ticks()

    run=True
    while run: # iteracion
        
        # tiempo final de una iteracion
        t1=pygame.time.get_ticks()

        # detectar eventos...
        for event in pygame.event.get():

            # cerrar ventana
            if event.type == QUIT:
                run=False

            # presionar tecla
            if event.type == KEYDOWN:
                if event.key == K_ESCAPE:
                    run=False
                if event.key == K_w:
                    wireframe = not wireframe
                if event.key == K_s:
                    verSR = not verSR

        # mueve los objetos, efectua interacciones y dibuja el frame
        accion((t1-t0)/10.0)
        #fija el tiempo inicial de la sgte iteracion
        t0=t1
        #actualiza la escena
        pygame.display.flip()
        # ajustar a 30 fps
        pygame.time.wait(1000/30) 

    # una vez fuera del loop cierra la ventana
    pygame.quit()
    
if __name__ == "__main__":
    import sys
    main(sys.argv)

#####################################################################
