#####################################################################
# CC3501-1 : Clase Vector 3D
#####################################################################

from math import *

#####################################################################

class Vector:
    def __init__(self, x, y, z):
        self.x = x
        self.y = y
        self.z = z

    def fi(self):
        return atan2(self.y,self.x)

    def theta(self):
        return acos(self.z/self.modulo())

    def rho(self):
        return (self.x**2 + self.y**2)**0.5

    def modulo(self):
        return (self.x**2 + self.y**2 + self.z**2)**0.5

    def esfericas(self):
        return self.modulo(),self.fi(),self.theta()

    def cilindricas(self):
        return self.rho(),self.fi(),self.z

    def cartesianas(self):
        return self.x,self.y,self.z

    def dibujar(self):
        glPushMatrix()
        glDisable(GL_LIGHTING)
        glBegin(GL_POINTS)
        glColor4f(1.0, 1.0, 1.0, 0.0)
        glVertex3fv(self.cartesianas())
        glEnd()
        glEnable(GL_LIGHTING)
        glPopMatrix()

#####################################################################

def VectorEsfericas(r,fi,theta):
    return Vector(r*sin(theta)*cos(fi),r*sin(theta)*sin(fi),r*cos(theta))

def VectorCilindricas(r,fi,z):
    return Vector(r*cos(fi),r*sin(fi),z)

def sumar(r2,r1):
    return Vector(r2.x + r1.x , r2.y + r1.y, r2.z + r1.z)

def restar(r2,r1):
    return Vector(r2.x - r1.x , r2.y - r1.y, r2.z - r1.z)

def multiplicar(r2,r1):
    return Vector(r2.x * r1.x , r2.y * r1.y, r2.z * r1.z)

def ponderar(a,r):
    return Vector(a*r.x,a*r.y,a*r.z)

def normalizar(r):
    m=r.modulo()
    if m>0:
        return Vector(r.x/m,r.y/m)
    else:
        return r

def desplazarRadialmente(r,d):
    return VectorEsfericas(r.modulo()+d,r.fi(),r.theta())

def rotarFi(r,a):
    a2=r.fi()+a
    if a2>=2*pi:
        a2=a2-2*pi
    if a2<0:
        a2=a2+2*pi
    return VectorCilindricas(r.rho(),a2,r.z)

def rotarTheta(r,a):
    a2=r.theta()+a
    if a2>=pi:
        a2=a2-2*pi
    if a2<-pi:
        a2=a2+2*pi
    return VectorEsfericas(r.modulo(),r.fi(),a2)

def distancia(r1,r2):
    return restar(r1,r2).modulo()

def punto(r1,r2):
    return r1.x*r2.x + r1.y*r2.y + r1.z*r2.z

def cruz(r1,r2):
    return Vector(r1.y*r2.z - r1.z*r2.y, r1.z*r2.x - r1.x*r2.z, r1.x*r2.y - r1.y*r2.x)

def normal(r0,r1,r2):
    n=cruz(restar(r1,r0),restar(r2,r0))
    m=n.modulo()
    if m!=0:
        return ponderar( 1.0/m, n)
    else:
        return n

#####################################################################
