#####################################################################
# CC3501-1 : Clase Vector
#####################################################################

from math import *

#####################################################################

class Vector:
    def __init__(self, x, y):
        self.x = x
        self.y = y

    def angulo(self):
        if self.x!=0:
            return atan2(self.y,self.x)
        else:
            if self.y>0:
                return pi/2.0
            else:
                return -pi/2.0

    def modulo(self):
        return (self.x**2 + self.y**2)**0.5

    def polares(self):
        return self.modulo(),self.angulo()

    def cartesianas(self):
        return self.x,self.y        

#####################################################################

def VectorPolar(m,a):
    return Vector(m*cos(a),m*sin(a))

def sumar(r1,r2):
    return Vector(r1.x + r2.x, r1.y + r2.y)

def restar(r1,r2):
    return Vector(r1.x - r2.x , r1.y - r2.y)

def ponderar(a,r):
    return Vector(a*r.x,a*r.y)

def normalizar(r):
    m=r.modulo()
    if m>0:
        return Vector(r.x/m,r.y/m)
    else:
        return r

def angulo(r1,r2):
    return r1.angulo()-r2.angulo()

def rotar(r,a):
    return VectorPolar(r.modulo(),r.angulo()+a)

def distancia(r1,r2):
    return restar(r1,r2).modulo()

def punto(r1,r2):
    return r1.x*r2.x+r1.y*r2.y

#####################################################################
