#include<stdio.h>
#include<stdlib.h>

#include "jsocket6.h"

#define MAX_CLIENTS 3
#define PORT 6666
#define MAX_SIZE 256

int main() {
  int s, i, ret;
  int cliente[MAX_CLIENTS];
  fd_set rmask, wmask; /* read and write masks */
  int cnt,j;
  char buf[MAX_SIZE];
  struct timeval zero;

  for (i=0;i<MAX_CLIENTS;i++) 
    cliente[i] = -1;

  s = j_socket();

  if(j_bind(s,PORT) < 0) {
    fprintf(stderr,"No pude tomar la puerta\n");
    exit(1);
  }
  j = 0;
  FD_ZERO(&wmask);
 for(;;) {

   FD_ZERO(&rmask);
   FD_SET(s,&rmask);
   
   for(i = 0; i < MAX_CLIENTS; i++) /* cada socket cliente */
     if( cliente[i] != -1 ) {
       if(FD_ISSET(cliente[i], &wmask)) {
	 FD_SET(cliente[i], &rmask);
	 FD_CLR(cliente[i],&wmask);
       }
       else
	 FD_SET(cliente[i], &wmask);
     }



   if (select(getdtablesize(),&rmask,&wmask,NULL,NULL) < 0) {
     fprintf(stderr,"Error en select\n");
     exit(1);
   }
   
   printf("SELECT %d\n",j++);
   
   FD_ZERO(&wmask);
   for(i = 0; i < MAX_CLIENTS; i++) /* cada socket cliente */
     if( cliente[i] != -1 )
       FD_SET(cliente[i], &wmask);
   zero.tv_sec = zero.tv_usec = 0;
   
   ret = select( getdtablesize(), NULL, &wmask, NULL, &zero);
   
   if( ret < 0 ) { perror("select 2"); exit(-1);}
   
   for (i=0;i<MAX_CLIENTS;i++) {
     if (cliente[i] != -1 && FD_ISSET(cliente[i],&rmask) && FD_ISSET(cliente[i],&wmask)) 
       if ((cnt=read(cliente[i],buf,MAX_SIZE)) > 0  && write(cliente[i],buf,cnt) > 0){
	 buf[cnt] = '\0';
	 printf("Envio %s",buf);
       }
       else {
	 fprintf(stderr,"El cliente murio %d\n",cnt);
	 FD_CLR(cliente[i],&wmask);
	 close(cliente[i]);
	 cliente[i] = -1;
       }
   }
   
   if (FD_ISSET(s,&rmask)) {
     /* debo encontrar un cliente vacio para el accept */
     for (i=0;i<MAX_CLIENTS;i++) 
       if (cliente[i] == -1) break;
     
     if (i == MAX_CLIENTS) {
       close(j_accept(s));
       continue;
     }
     
     cliente[i] = j_accept(s);
     printf("LLEGO UN CLIENTE\n");
   } 
 }
 
}
