#include<stdio.h>
#include<stdlib.h>
#include<pthread.h>

#include "jsocket6.h"

#define BUFFER_SIZE 100
#define PORT 6666

#define MAX_CLIENTS 3

int clientes = 0;

pthread_mutex_t mut;

void servir(int ss) {
  int cnt;
  char buf[BUFFER_SIZE];
  
  
  while((cnt=read(ss,buf,BUFFER_SIZE)) > 0) {
    write(ss,buf,cnt);
    write(1,buf,cnt);

    if (strncmp(buf,"quit",4) == 0)
      break;
  }

    pthread_mutex_lock(&mut);
    clientes--;
    pthread_mutex_unlock(&mut);

  close(ss);
  pthread_exit((void *)1);
}

int main() {
  int s, s2;
  pthread_t pid;

  pthread_mutex_init(&mut,NULL);

  s = j_socket();

  if(j_bind(s, PORT) < 0) {
    fprintf(stderr,"Fallo el bind del port %d\n", PORT);
    exit(1);
  }

  for (;;) {
    if ((s2 = j_accept(s)) < 0) {
      fprintf(stderr,"Error en el socket al accept\n");
      close(s2);
      continue;
    }
    
    if (clientes >= MAX_CLIENTS) {
      write(s2,"Lo siento, maximo alcanzado, chao\n",37);
      close(s2);
      continue;
    }
    

    printf("Alguien se conecto\n");

    if (pthread_create(&pid,NULL,(void *)servir,(void *)s2) != 0) {
      fprintf(stderr,"Error al crear el thread para atender\n");
      continue;
    }

    pthread_mutex_lock(&mut);
    clientes++;
    pthread_mutex_unlock(&mut);
  }

  close(s);
}
